"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getImportPathForFile = getImportPathForFile;
function getImportPathForFile(ts, languageServiceHost, program, fileName, incomingFileName, preferences) {
    const incomingFile = program.getSourceFile(incomingFileName);
    const sourceFile = program.getSourceFile(fileName);
    if (!sourceFile || !incomingFile) {
        return;
    }
    const getModuleSpecifiersWithCacheInfo = ts.moduleSpecifiers.getModuleSpecifiersWithCacheInfo;
    const resolutionHost = ts.createModuleSpecifierResolutionHost(program, languageServiceHost);
    const { moduleSpecifiers } = getModuleSpecifiersWithCacheInfo(incomingFile.symbol, program.getTypeChecker(), languageServiceHost.getCompilationSettings(), sourceFile, resolutionHost, preferences);
    return moduleSpecifiers[0];
}
//# sourceMappingURL=getImportPathForFile.js.map