/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.graphlisteners;

import java.util.List;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.callgraph.StapGraph;
import org.eclipse.linuxtools.internal.callgraph.StapNode;
import org.eclipse.linuxtools.internal.callgraph.core.FileFinderOpener;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.StapGraphFocusListener;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.StapGraphMouseExitListener;
import org.eclipse.linuxtools.internal.callgraph.graphlisteners.StapGraphMouseMoveListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.zest.core.widgets.GraphNode;

public class StapGraphMouseListener
implements MouseListener {
    private int x;
    private int y;
    private StapGraph graph;
    private StapGraphMouseMoveListener listener;
    private StapGraphFocusListener focus;
    private StapGraphMouseExitListener exitListener;

    public StapGraphMouseListener(StapGraph g) {
        this.graph = g;
        this.listener = new StapGraphMouseMoveListener(this.graph);
        this.focus = new StapGraphFocusListener(this.listener);
        this.exitListener = new StapGraphMouseExitListener(this.listener);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (e.stateMask == 262144) {
            this.controlDoubleClick();
            return;
        }
        if (this.graph.getDrawMode() == 1) {
            StapNode node = this.getNodeFromSelection();
            if (node == null) {
                return;
            }
            this.graph.getTreeViewer().collapseToLevel((Object)node.getData(), 0);
            this.graph.getTreeViewer().expandToLevel((Object)node.getData(), 0);
            this.graph.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node.getData()));
            int id = node.getData().id;
            this.graph.scale = 1.0;
            this.graph.draw(id);
            node = this.graph.getNode(id);
            node.unhighlight();
            if (this.graph.getNodeData(id).isMarked()) {
                node.setBackgroundColor(StapGraph.CONSTANT_MARKED);
            } else {
                node.setBackgroundColor(this.graph.DEFAULT_NODE_COLOR);
            }
            return;
        }
        StapNode node = this.getNodeFromSelection();
        if (node == null) {
            return;
        }
        this.unhighlightall(node);
        this.graph.setSelection(null);
        int id = node.getData().id;
        this.graph.draw(id);
        this.graph.setSelection(null);
    }

    public void mouseDown(MouseEvent e) {
        if (this.graph.getProjectionist() != null) {
            this.graph.getProjectionist().pause();
        }
        this.mouseDownEvent(e.x, e.y);
    }

    public void mouseUp(MouseEvent e) {
        this.mouseUpEvent();
    }

    private void unhighlightall(StapNode n) {
        int id = n.id;
        List<Integer> callees = null;
        callees = this.graph.isCollapseMode() ? this.graph.getNodeData((int)id).collapsedChildren : this.graph.getNodeData((int)id).children;
        if (callees == null) {
            return;
        }
        for (int subID : callees) {
            if (this.graph.getNode(subID) == null) continue;
            this.graph.getNode(subID).unhighlight();
        }
        if (this.graph.getParentNode(id) != null) {
            this.graph.getParentNode(id).unhighlight();
        }
        n.unhighlight();
    }

    private StapNode getNodeFromSelection() {
        List stapNodeList = this.graph.getSelection();
        if (stapNodeList.isEmpty() || stapNodeList.size() != 1) {
            this.graph.setSelection(null);
            return null;
        }
        StapNode node = null;
        if (!(stapNodeList.get(0) instanceof StapNode)) {
            this.graph.setSelection(null);
            return null;
        }
        node = (StapNode)((Object)stapNodeList.remove(0));
        return node;
    }

    private GraphNode getAggregateNodeFromSelection() {
        List graphNodeList = this.graph.getSelection();
        if (graphNodeList.isEmpty() || graphNodeList.size() != 1) {
            this.graph.setSelection(null);
            return null;
        }
        GraphNode node = null;
        if (!(graphNodeList.get(0) instanceof GraphNode)) {
            this.graph.setSelection(null);
            return null;
        }
        node = (GraphNode)graphNodeList.remove(0);
        return node;
    }

    public void controlDoubleClick() {
        if (this.graph.getDrawMode() == 3) {
            GraphNode node = this.getAggregateNodeFromSelection();
            if (node == null) {
                return;
            }
            String functionName = (String)node.getData("AGGREGATE_NAME");
            FileFinderOpener.findAndOpen((ICProject)this.graph.getProject(), (String)functionName);
            node.unhighlight();
        } else {
            StapNode node = this.getNodeFromSelection();
            if (node == null) {
                return;
            }
            int caller = node.getData().id;
            if (caller < this.graph.getFirstUsefulNode()) {
                caller = this.graph.getFirstUsefulNode();
            }
            FileFinderOpener.findAndOpen((ICProject)this.graph.getProject(), (String)this.graph.getNodeData((int)caller).name);
            node.unhighlight();
        }
        this.graph.setSelection(null);
    }

    public void mouseDownEvent(int x, int y) {
        List list = this.graph.getSelection();
        if (list.size() < 1) {
            this.listener.setPoint(x, y);
            this.listener.setStop(false);
            this.graph.addMouseMoveListener(this.listener);
            this.graph.addListener(7, this.exitListener);
        }
    }

    public void mouseUpEvent() {
        this.listener.setStop(true);
        this.graph.removeMouseMoveListener(this.listener);
        this.graph.removeListener(7, this.exitListener);
        List list = this.graph.getSelection();
        if (list.size() == 1) {
            if (!(list.get(0) instanceof StapNode)) {
                this.graph.setSelection(null);
                return;
            }
            int id = ((StapNode)((Object)list.get((int)0))).id;
            this.graph.setSelection(null);
            if (this.graph.getDrawMode() == 2 || this.graph.getDrawMode() == 0) {
                for (StapNode n : this.graph.getNodes()) {
                    this.unhighlightall(n);
                }
                List<Integer> callees = null;
                callees = this.graph.isCollapseMode() ? this.graph.getNodeData((int)id).collapsedChildren : this.graph.getNodeData((int)id).children;
                for (int subID : callees) {
                    if (this.graph.getNode(subID) == null) continue;
                    this.graph.getNode(subID).highlight();
                }
                if (this.graph.getParentNode(id) != null) {
                    this.graph.getParentNode(id).highlight();
                }
                this.graph.getNode(id).highlight();
                return;
            }
        } else if (list.size() == 0 && this.graph.getDrawMode() != 3) {
            for (StapNode n : this.graph.getNodes()) {
                this.unhighlightall(n);
            }
        }
    }
}

