/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui;

import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;

public class FileRelevance {
    private static final int PREFERRED_PROJECT = 64;
    private static final int CDT_PROJECT = 32;
    private static final int ON_SOURCE_ROOT = 16;
    private static final int LINK_PENALTY = 1;
    private static final int INACCESSIBLE_SHIFT = 4;

    public static int getRelevance(IFile f, IProject preferredProject) {
        int result = 0;
        IProject p = f.getProject();
        if (p.equals((Object)preferredProject)) {
            result += 64;
        }
        if (CoreModel.hasCNature((IProject)p)) {
            result += 32;
            ICProject cproject = CoreModel.getDefault().create(p);
            if (cproject.isOnSourceRoot((IResource)f)) {
                result += 16;
            }
        }
        if (!f.isAccessible()) {
            result >>= 4;
        } else {
            ResourceAttributes ra = f.getResourceAttributes();
            if (f.isLinked() || ra != null && ra.isSymbolicLink()) {
                --result;
            }
        }
        return result;
    }
}

