/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.resources.evProcessor;

import java.util.Vector;
import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeComponent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEvent;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeEventResource;
import org.eclipse.linuxtools.lttng.ui.model.trange.TimeRangeResourceFactory;
import org.eclipse.linuxtools.lttng.ui.views.common.AbsTRangeUpdate;
import org.eclipse.linuxtools.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.lttng.ui.views.resources.model.ResourceContainer;
import org.eclipse.linuxtools.lttng.ui.views.resources.model.ResourceModelFactory;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;

public abstract class AbsResourcesTRangeUpdate
extends AbsTRangeUpdate
implements ILttngEventProcessor {
    protected ResourceContainer resContainer = ResourceModelFactory.getResourceContainer();
    protected ParamsUpdater params = ResourceModelFactory.getParamsUpdater();
    protected static final Long ANY_CPU = 0L;

    protected TimeRangeEventResource addLocalResource(long traceStartTime, long traceEndTime, String traceId, TimeRangeEventResource.ResourceTypes type, Long resId, long insertionTime) {
        String resourceName = String.valueOf(type.toString()) + " " + resId.toString();
        TimeRangeEventResource localRessource = TimeRangeResourceFactory.getInstance().createResource(this.resContainer.getUniqueId(), traceStartTime, traceEndTime, resourceName, traceId, "", type, resId, insertionTime);
        this.resContainer.addItem(localRessource);
        if (TraceDebug.isRV()) {
            TraceDebug.traceRV("addLocalResource():" + localRessource);
        }
        return localRessource;
    }

    protected boolean withinViewRange(long stime, long etime) {
        long windowStartTime = this.params.getStartTime();
        long windowEndTime = this.params.getEndTime();
        if (stime > windowEndTime) {
            return false;
        }
        if (etime >= windowStartTime) {
            return true;
        }
        return stime <= windowStartTime && etime >= windowEndTime;
    }

    public TimeRangeEventResource resourcelist_obtain_bdev(LttngTraceState traceState, Long resourceId) {
        return this.resourcelist_obtain_generic(resourceId, TimeRangeEventResource.ResourceTypes.BDEV, traceState.getTraceId());
    }

    public TimeRangeEventResource resourcelist_obtain_trap(LttngTraceState traceState, Long resourceId) {
        return this.resourcelist_obtain_generic(resourceId, TimeRangeEventResource.ResourceTypes.TRAP, traceState.getTraceId());
    }

    public TimeRangeEventResource resourcelist_obtain_irq(LttngTraceState traceState, Long resourceId) {
        return this.resourcelist_obtain_generic(resourceId, TimeRangeEventResource.ResourceTypes.IRQ, traceState.getTraceId());
    }

    public TimeRangeEventResource resourcelist_obtain_soft_irq(LttngTraceState traceState, Long resourceId) {
        return this.resourcelist_obtain_generic(resourceId, TimeRangeEventResource.ResourceTypes.SOFT_IRQ, traceState.getTraceId());
    }

    public TimeRangeEventResource resourcelist_obtain_cpu(LttngTraceState traceState, Long resourceId) {
        return this.resourcelist_obtain_generic(resourceId, TimeRangeEventResource.ResourceTypes.CPU, traceState.getTraceId());
    }

    public TimeRangeEventResource resourcelist_obtain_machine(LttngTraceState traceState, Long resourceId) {
        return this.resourcelist_obtain_generic(resourceId, TimeRangeEventResource.ResourceTypes.UNKNOWN, traceState.getTraceId());
    }

    public TimeRangeEventResource resourcelist_obtain_generic(Long resourceId, TimeRangeEventResource.ResourceTypes resourceType, String traceId) {
        return this.resContainer.findItem(resourceId, resourceType, traceId);
    }

    protected boolean globalProcessBeforeExecmode(LttngEvent trcEvent, LttngTraceState traceSt) {
        TimeRangeEventResource localResource = this.resourcelist_obtain_cpu(traceSt, trcEvent.getCpuId());
        Long cpu = trcEvent.getCpuId();
        if (localResource == null) {
            TmfTimeRange timeRange = traceSt.getContext().getTraceTimeWindow();
            localResource = this.addLocalResource(timeRange.getStartTime().getValue(), timeRange.getEndTime().getValue(), traceSt.getTraceId(), TimeRangeEventResource.ResourceTypes.CPU, cpu, trcEvent.getTimestamp().getValue());
        }
        long stime = localResource.getNext_good_time();
        String cpuStateMode = localResource.getStateMode(traceSt);
        this.makeDraw(traceSt, stime, trcEvent.getTimestamp().getValue(), localResource, this.params, cpuStateMode);
        return false;
    }

    protected boolean makeDraw(LttngTraceState traceSt, long stime, long etime, TimeRangeEventResource localResource, ParamsUpdater params, String stateMode) {
        TimeRangeEvent.Type eventType;
        long insertion;
        if (TraceDebug.isRV()) {
            TraceDebug.traceRV("makeDraw():[" + localResource + ",candidate=[stime=" + stime + ",etime=" + etime + ",state=" + stateMode + "]]");
        }
        if (!this.withinViewRange(stime, etime)) {
            params.incrementEventsDiscarded(0);
            return false;
        }
        if (etime < stime) {
            params.incrementEventsDiscardedWrongOrder();
            return false;
        }
        if (stime < params.getStartTime() && stime == (insertion = localResource.getInsertionTime())) {
            long halfPage = (params.getEndTime() - params.getStartTime()) / 2L;
            long initTime = params.getStartTime() - halfPage;
            if (initTime > insertion) {
                stime = initTime;
            }
        }
        double duration = etime - stime;
        double k = this.getPixelsPerNs(traceSt, params);
        double pixels = duration * k;
        boolean visible = true;
        if (pixels < 1.0) {
            boolean prevEventVisibility = true;
            Vector<TimeRangeComponent> inMemEvents = localResource.getTraceEvents();
            if (inMemEvents.size() != 0) {
                TimeRangeComponent prevEvent = inMemEvents.get(inMemEvents.size() - 1);
                prevEventVisibility = prevEvent.isVisible();
                Long eventSpan = stime - prevEvent.getStartTime();
                if (!prevEventVisibility && (double)eventSpan.longValue() * k < 2.0) {
                    params.incrementEventsDiscarded(1);
                    return false;
                }
            }
            visible = false;
        }
        if ((eventType = this.getEventType(localResource)) != null) {
            TimeRangeEvent time_window = new TimeRangeEvent(stime, etime, localResource, eventType, stateMode);
            time_window.setVisible(visible);
            localResource.addChildren(time_window);
            localResource.setNext_good_time(etime);
        }
        return false;
    }

    private TimeRangeEvent.Type getEventType(TimeRangeEventResource resource) {
        TimeRangeEventResource.ResourceTypes resType = resource.getType();
        TimeRangeEvent.Type eventType = null;
        switch (resType) {
            case CPU: {
                eventType = TimeRangeEvent.Type.CPU_MODE;
                break;
            }
            case IRQ: {
                eventType = TimeRangeEvent.Type.IRQ_MODE;
                break;
            }
            case SOFT_IRQ: {
                eventType = TimeRangeEvent.Type.SOFT_IRQ_MODE;
                break;
            }
            case TRAP: {
                eventType = TimeRangeEvent.Type.TRAP_MODE;
                break;
            }
            case BDEV: {
                eventType = TimeRangeEvent.Type.BDEV_MODE;
                break;
            }
            default: {
                eventType = TimeRangeEvent.Type.PROCESS_MODE;
            }
        }
        return eventType;
    }
}

