/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.test.plugin.launchers;

import com.google.gson.Gson;
import com.microsoft.java.test.plugin.launchers.JUnitLaunchConfiguration;
import com.microsoft.java.test.plugin.launchers.JUnitLaunchConfigurationDelegate;
import com.microsoft.java.test.plugin.launchers.TestInfo;
import com.microsoft.java.test.plugin.model.TestKind;
import com.microsoft.java.test.plugin.model.TestLevel;
import com.microsoft.java.test.plugin.util.TestSearchUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.Position;

public class JUnitLaunchUtils {
    private static final String TESTNG_LOADER = "com.microsoft.java.test.loader.testng";
    private static final String JUNIT5_LOADER = "org.eclipse.jdt.junit.loader.junit5";
    private static final String JUNIT4_LOADER = "org.eclipse.jdt.junit.loader.junit4";

    private JUnitLaunchUtils() {
    }

    public static JUnitLaunchConfigurationDelegate.JUnitLaunchArguments resolveLaunchArgument(List<Object> arguments, IProgressMonitor monitor) throws URISyntaxException, CoreException {
        Gson gson = new Gson();
        Argument args = (Argument)gson.fromJson((String)arguments.get(0), Argument.class);
        TestInfo info = new TestInfo();
        info.testKind = JUnitLaunchUtils.getEclipseTestKind(args.testKind);
        IJavaProject javaProject = ProjectUtils.getJavaProject((String)args.project);
        if (javaProject == null || !javaProject.exists()) {
            throw new RuntimeException("Failed to get the project with name: " + args.project);
        }
        info.project = javaProject.getProject();
        if (args.scope == TestLevel.ROOT || args.scope == TestLevel.FOLDER) {
            info.testContainer = StringEscapeUtils.escapeXml((String)javaProject.getHandleIdentifier());
        } else {
            File file = Paths.get(new URI(args.uri)).toFile();
            if (args.scope == TestLevel.PACKAGE && file.isDirectory()) {
                JUnitLaunchUtils.parseConfigurationInfoForContainer(info, args);
            } else if ((args.scope == TestLevel.CLASS || args.scope == TestLevel.METHOD) && file.isFile()) {
                JUnitLaunchUtils.parseConfigurationInfoForClass(info, args, monitor);
            } else {
                throw new RuntimeException("The resource: " + file.getPath() + " is not testable.");
            }
        }
        JUnitLaunchConfiguration configuration = new JUnitLaunchConfiguration("JUnit Launch Configuration", info);
        JUnitLaunchConfigurationDelegate delegate = new JUnitLaunchConfigurationDelegate();
        if (monitor.isCanceled()) {
            return null;
        }
        if (TESTNG_LOADER.equals(info.testKind)) {
            return JUnitLaunchUtils.resolveTestNGLaunchArguments((ILaunchConfiguration)configuration, javaProject, delegate);
        }
        return delegate.getJUnitLaunchArguments((ILaunchConfiguration)configuration, "run", monitor);
    }

    public static void addOverrideDependencies(List<String> vmArgs, String dependencies) {
        if (dependencies != null && dependencies.length() > 0) {
            String[] parseArguments = DebugPlugin.parseArguments((String)dependencies);
            vmArgs.addAll(Arrays.asList(parseArguments));
        }
    }

    private static void parseConfigurationInfoForClass(TestInfo info, Argument args, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((String)args.uri);
        if (cu == null) {
            throw new RuntimeException("Cannot resolve compilation unit from: " + args.uri);
        }
        IType[] iTypeArray = cu.getAllTypes();
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (type.getFullyQualifiedName().equals(args.classFullName)) {
                info.mainType = args.classFullName;
                info.testName = JUnitLaunchUtils.parseTestName(args, cu, monitor);
                break;
            }
            ++n2;
        }
        if (info.mainType == null) {
            throw new RuntimeException("Failed to find class '" + args.classFullName + "'");
        }
    }

    private static String parseTestName(Argument args, ICompilationUnit cu, IProgressMonitor monitor) throws JavaModelException {
        String testName;
        String string = testName = StringUtils.isEmpty((CharSequence)args.testName) ? "" : args.testName;
        if (args.testKind == TestKind.JUnit5 && args.scope == TestLevel.METHOD) {
            ASTNode unit = TestSearchUtils.parseToAst(cu, monitor);
            if (unit == null) {
                return "";
            }
            int startOffset = JsonRpcHelpers.toOffset((IOpenable)cu.getOpenable(), (int)args.start.getLine(), (int)args.start.getCharacter());
            int endOffset = JsonRpcHelpers.toOffset((IOpenable)cu.getOpenable(), (int)args.end.getLine(), (int)args.end.getCharacter());
            ASTNode methodDeclaration = NodeFinder.perform((ASTNode)unit, (int)startOffset, (int)(endOffset - startOffset), (ITypeRoot)cu);
            while (!(methodDeclaration instanceof MethodDeclaration)) {
                methodDeclaration = methodDeclaration.getParent();
            }
            LinkedList<String> parameters = new LinkedList<String>();
            for (Object obj : ((MethodDeclaration)methodDeclaration).parameters()) {
                if (!(obj instanceof SingleVariableDeclaration)) continue;
                ITypeBinding paramTypeBinding = ((SingleVariableDeclaration)obj).getType().resolveBinding();
                if (paramTypeBinding.isParameterizedType()) {
                    parameters.add(paramTypeBinding.getBinaryName());
                    continue;
                }
                parameters.add(paramTypeBinding.getQualifiedName());
            }
            if (parameters.size() > 0) {
                testName = String.valueOf(testName) + String.format("(%s)", String.join((CharSequence)",", parameters));
            }
        }
        return testName;
    }

    private static void parseConfigurationInfoForContainer(TestInfo info, Argument args) throws URISyntaxException {
        IContainer[] targetContainers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(new URI(args.uri));
        if (targetContainers == null || targetContainers.length == 0) {
            throw new RuntimeException("Cannot find resource containers from: " + args.uri);
        }
        Arrays.sort(targetContainers, (a, b) -> a.getFullPath().toPortableString().length() - b.getFullPath().toPortableString().length());
        IJavaElement targetElement = null;
        IContainer[] iContainerArray = targetContainers;
        int n = targetContainers.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject javaProject;
            IContainer container = iContainerArray[n2];
            targetElement = JavaCore.create((IResource)container);
            if (targetElement != null && (javaProject = targetElement.getJavaProject()) != null) {
                info.project = javaProject.getProject();
                break;
            }
            ++n2;
        }
        if (targetElement == null) {
            throw new RuntimeException("Cannot resolve valid element from: " + args.uri);
        }
        info.testContainer = StringEscapeUtils.escapeXml((String)targetElement.getHandleIdentifier());
    }

    private static JUnitLaunchConfigurationDelegate.JUnitLaunchArguments resolveTestNGLaunchArguments(ILaunchConfiguration configuration, IJavaProject javaProject, JUnitLaunchConfigurationDelegate delegate) throws CoreException {
        String id;
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])unresolved, (ILaunchConfiguration)configuration);
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        LinkedHashSet<String> modulepaths = new LinkedHashSet<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolved;
        int n = resolved.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            String location = entry.getLocation();
            if (location != null) {
                if (entry.getClasspathProperty() == 3 || entry.getClasspathProperty() == 5) {
                    classpaths.add(location);
                } else if (entry.getClasspathProperty() == 4) {
                    modulepaths.add(location);
                }
            }
            ++n2;
        }
        JUnitLaunchConfigurationDelegate.JUnitLaunchArguments launchArguments = new JUnitLaunchConfigurationDelegate.JUnitLaunchArguments();
        launchArguments.projectName = javaProject.getProject().getName();
        launchArguments.classpath = classpaths.toArray(new String[classpaths.size()]);
        launchArguments.modulepath = modulepaths.toArray(new String[modulepaths.size()]);
        IPath projectLocation = javaProject.getProject().getLocation();
        if (projectLocation != null) {
            launchArguments.workingDirectory = projectLocation.toFile().getAbsolutePath();
        }
        ArrayList<String> vmArgs = new ArrayList<String>();
        vmArgs.add("-ea");
        if (JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            for (String pkg : JUnitLaunchUtils.getSourcePackages(javaProject)) {
                JUnitLaunchUtils.collectAddOpensVmArgs(vmArgs, pkg, javaProject);
            }
            vmArgs.add("--add-modules=ALL-MODULE-PATH");
        }
        if ("enabled".equals(id = javaProject.getOption("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", true))) {
            vmArgs.add("--enable-preview");
        }
        JUnitLaunchUtils.addOverrideDependencies(vmArgs, delegate.getModuleCLIOptions(configuration));
        launchArguments.vmArguments = vmArgs.toArray(new String[vmArgs.size()]);
        return launchArguments;
    }

    private static void collectAddOpensVmArgs(List<String> addOpensVmArgs, String pkgName, IJavaProject javaProject) throws CoreException {
        String sourceModuleName = javaProject.getModuleDescription().getElementName();
        addOpensVmArgs.add("--add-opens");
        addOpensVmArgs.add(String.valueOf(sourceModuleName) + "/" + pkgName + "=ALL-UNNAMED");
    }

    private static Set<String> getSourcePackages(IJavaProject javaProject) throws JavaModelException {
        HashSet<String> pkgs = new HashSet<String>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.getPackageFragmentRoots();
        int n = iPackageFragmentRootArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot pkgFragmentRoot = iPackageFragmentRootArray[n2];
            if (!pkgFragmentRoot.isArchive()) {
                IJavaElement[] iJavaElementArray = pkgFragmentRoot.getChildren();
                int n3 = iJavaElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement pkg = iJavaElementArray[n4];
                    if (!pkg.getElementName().isEmpty() && !(pkg instanceof IFolder) && ((IPackageFragment)pkg).containsJavaResources()) {
                        pkgs.add(((IPackageFragment)pkg).getElementName());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return pkgs;
    }

    private static String getEclipseTestKind(TestKind testKind) {
        switch (testKind) {
            case JUnit: {
                return JUNIT4_LOADER;
            }
            case JUnit5: {
                return JUNIT5_LOADER;
            }
            case TestNG: {
                return TESTNG_LOADER;
            }
        }
        throw new IllegalArgumentException("The test kind: " + testKind.name() + " is not supported yet.");
    }

    class Argument {
        public String uri;
        public String classFullName;
        public String testName;
        public String project;
        public TestLevel scope;
        public TestKind testKind;
        public Position start;
        public Position end;

        Argument() {
        }
    }
}

