/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import { AbstractCommandsQuickAccessProvider } from '../../../platform/quickinput/browser/commandsQuickAccess';
import { stripIcons } from '../../../base/common/iconLabels';
var AbstractEditorCommandsQuickAccessProvider = /** @class */ (function (_super) {
    __extends(AbstractEditorCommandsQuickAccessProvider, _super);
    function AbstractEditorCommandsQuickAccessProvider(options, instantiationService, keybindingService, commandService, telemetryService, notificationService) {
        return _super.call(this, options, instantiationService, keybindingService, commandService, telemetryService, notificationService) || this;
    }
    AbstractEditorCommandsQuickAccessProvider.prototype.getCodeEditorCommandPicks = function () {
        var e_1, _a;
        var activeTextEditorControl = this.activeTextEditorControl;
        if (!activeTextEditorControl) {
            return [];
        }
        var editorCommandPicks = [];
        try {
            for (var _b = __values(activeTextEditorControl.getSupportedActions()), _c = _b.next(); !_c.done; _c = _b.next()) {
                var editorAction = _c.value;
                editorCommandPicks.push({
                    commandId: editorAction.id,
                    commandAlias: editorAction.alias,
                    label: stripIcons(editorAction.label) || editorAction.id,
                });
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return editorCommandPicks;
    };
    return AbstractEditorCommandsQuickAccessProvider;
}(AbstractCommandsQuickAccessProvider));
export { AbstractEditorCommandsQuickAccessProvider };
