/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import { Registry } from '../../registry/common/platform';
import { coalesce } from '../../../base/common/arrays';
import { toDisposable } from '../../../base/common/lifecycle';
export var DefaultQuickAccessFilterValue;
(function (DefaultQuickAccessFilterValue) {
    /**
     * Keep the value as it is given to quick access.
     */
    DefaultQuickAccessFilterValue[DefaultQuickAccessFilterValue["PRESERVE"] = 0] = "PRESERVE";
    /**
     * Use the value that was used last time something was accepted from the picker.
     */
    DefaultQuickAccessFilterValue[DefaultQuickAccessFilterValue["LAST"] = 1] = "LAST";
})(DefaultQuickAccessFilterValue || (DefaultQuickAccessFilterValue = {}));
export var Extensions = {
    Quickaccess: 'workbench.contributions.quickaccess'
};
var QuickAccessRegistry = /** @class */ (function () {
    function QuickAccessRegistry() {
        this.providers = [];
        this.defaultProvider = undefined;
    }
    QuickAccessRegistry.prototype.registerQuickAccessProvider = function (provider) {
        var _this = this;
        // Extract the default provider when no prefix is present
        if (provider.prefix.length === 0) {
            this.defaultProvider = provider;
        }
        else {
            this.providers.push(provider);
        }
        // sort the providers by decreasing prefix length, such that longer
        // prefixes take priority: 'ext' vs 'ext install' - the latter should win
        this.providers.sort(function (providerA, providerB) { return providerB.prefix.length - providerA.prefix.length; });
        return toDisposable(function () {
            _this.providers.splice(_this.providers.indexOf(provider), 1);
            if (_this.defaultProvider === provider) {
                _this.defaultProvider = undefined;
            }
        });
    };
    QuickAccessRegistry.prototype.getQuickAccessProviders = function () {
        return coalesce(__spreadArray([this.defaultProvider], __read(this.providers)));
    };
    QuickAccessRegistry.prototype.getQuickAccessProvider = function (prefix) {
        var result = prefix ? (this.providers.find(function (provider) { return prefix.startsWith(provider.prefix); }) || undefined) : undefined;
        return result || this.defaultProvider;
    };
    QuickAccessRegistry.prototype.clear = function () {
        var _this = this;
        var providers = __spreadArray([], __read(this.providers));
        var defaultProvider = this.defaultProvider;
        this.providers = [];
        this.defaultProvider = undefined;
        return function () {
            _this.providers = providers;
            _this.defaultProvider = defaultProvider;
        };
    };
    return QuickAccessRegistry;
}());
export { QuickAccessRegistry };
Registry.add(Extensions.Quickaccess, new QuickAccessRegistry());
