/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BooleanLiteral;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CharacterLiteral;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintFilterManager;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintsParameterMode;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

class InlayHintVisitor
extends ASTVisitor {
    private List<InlayHint> hints;
    private int startOffset;
    private int endOffset;
    private ITypeRoot typeRoot;
    private PreferenceManager preferenceManager;

    InlayHintVisitor(int startOffset, int endOffset, ITypeRoot typeRoot, PreferenceManager preferenceManager) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.typeRoot = typeRoot;
        this.hints = new ArrayList<InlayHint>();
        this.preferenceManager = preferenceManager;
    }

    public boolean visit(EnumConstantDeclaration node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(ClassInstanceCreation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(MethodInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveInlayHints(node.resolveMethodBinding(), node.arguments());
        return true;
    }

    public boolean visit(SuperMethodInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveInlayHints(node.resolveMethodBinding(), node.arguments());
        return true;
    }

    public boolean visit(ConstructorInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public boolean visit(SuperConstructorInvocation node) {
        if (this.isOutOfRange((ASTNode)node) || this.isGenerated((ASTNode)node)) {
            return true;
        }
        this.resolveInlayHints(node.resolveConstructorBinding(), node.arguments());
        return true;
    }

    public List<InlayHint> getInlayHints() {
        return this.hints;
    }

    private boolean isOutOfRange(ASTNode node) {
        return node.getStartPosition() > this.endOffset || node.getStartPosition() + node.getLength() < this.startOffset;
    }

    private boolean isGenerated(ASTNode node) {
        try {
            return (Boolean)node.getClass().getField("$isGenerated").get(node);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
    }

    private void resolveInlayHints(IMethodBinding methodBinding, List<Expression> arguments) {
        if (methodBinding == null) {
            return;
        }
        if (arguments.size() == 0) {
            return;
        }
        String[] parameterNames = this.getParameterNames(methodBinding);
        if (parameterNames == null) {
            return;
        }
        if (!methodBinding.isVarargs() && arguments.size() != parameterNames.length) {
            return;
        }
        if (InlayHintFilterManager.instance().match((IMethod)methodBinding.getJavaElement())) {
            return;
        }
        try {
            int paramNum = Math.min(parameterNames.length, arguments.size());
            int i = 0;
            while (i < paramNum) {
                Expression arg = arguments.get(i);
                if (this.acceptArgument(arg, parameterNames[i])) {
                    String label = String.valueOf(parameterNames[i]) + ":";
                    if (i == parameterNames.length - 1 && methodBinding.isVarargs()) {
                        label = "..." + label;
                    }
                    int[] lineAndColumn = JsonRpcHelpers.toLine(this.typeRoot.getBuffer(), arg.getStartPosition());
                    InlayHint hint = new InlayHint(new Position(lineAndColumn[0], lineAndColumn[1]), Either.forLeft((Object)label));
                    this.hints.add(hint);
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
        }
    }

    private String[] getParameterNames(IMethodBinding methodBinding) {
        if (!this.hasSource(methodBinding)) {
            return null;
        }
        String[] parameterNames = null;
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method != null) {
            try {
                parameterNames = method.getParameterNames();
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException(e);
            }
        } else if (methodBinding.getDeclaringClass().isRecord()) {
            parameterNames = methodBinding.getParameterNames();
        }
        return parameterNames;
    }

    private boolean hasSource(IMethodBinding methodBinding) {
        IType type = (IType)methodBinding.getDeclaringClass().getJavaElement();
        if (type == null) {
            return false;
        }
        ITypeRoot typeRoot = type.getTypeRoot();
        if (typeRoot == null || !typeRoot.exists()) {
            return false;
        }
        try {
            return typeRoot.getBuffer() != null;
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return false;
        }
    }

    private boolean acceptArgument(Expression argument, String paramName) {
        if (InlayHintsParameterMode.LITERALS.equals((Object)this.preferenceManager.getPreferences().getInlayHintsParameterMode()) && !this.isLiteral(argument)) {
            return false;
        }
        return !this.isSameName(argument, paramName);
    }

    private boolean isLiteral(Expression argument) {
        return argument instanceof BooleanLiteral || argument instanceof CharacterLiteral || argument instanceof NullLiteral || argument instanceof NumberLiteral || argument instanceof StringLiteral || argument instanceof TypeLiteral;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameName(Expression argument, String paramName) {
        Expression expression = argument;
        if (expression instanceof CastExpression) {
            void castExpression;
            CastExpression castExpression2 = (CastExpression)expression;
            CastExpression cfr_ignored_0 = (CastExpression)expression;
            argument = castExpression.getExpression();
        }
        if (!(argument instanceof SimpleName)) {
            return false;
        }
        String argName = ((SimpleName)argument).getIdentifier();
        return Objects.equals(argName, paramName);
    }
}

