/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.search.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentDescription;

public class FileCharSequenceProvider {
    private static int NUMBER_OF_BUFFERS = 3;
    public static int BUFFER_SIZE = 524288;
    private FileCharSequence fReused = null;

    public CharSequence newCharSequence(IFile file) throws CoreException, IOException {
        if (this.fReused == null) {
            return new FileCharSequence(file);
        }
        FileCharSequence curr = this.fReused;
        this.fReused = null;
        curr.reset(file);
        return curr;
    }

    /*
     * WARNING - void declaration
     */
    public void releaseCharSequence(CharSequence seq) throws IOException {
        CharSequence charSequence = seq;
        if (charSequence instanceof FileCharSequence) {
            void curr;
            FileCharSequence fileCharSequence = (FileCharSequence)charSequence;
            FileCharSequence cfr_ignored_0 = (FileCharSequence)charSequence;
            try {
                curr.close();
            }
            finally {
                if (this.fReused == null) {
                    this.fReused = curr;
                }
            }
        }
    }

    private static final class Buffer {
        private final char[] fBuf = new char[BUFFER_SIZE];
        private int fOffset;
        private int fLength;
        private Buffer fNext;
        private Buffer fPrevious;

        public Buffer() {
            this.reset();
            this.fNext = this;
            this.fPrevious = this;
        }

        public boolean contains(int pos) {
            int offset = this.fOffset;
            return offset <= pos && pos < offset + this.fLength;
        }

        public boolean fill(Reader reader, int pos) throws IOException {
            int res = reader.read(this.fBuf);
            if (res == -1) {
                this.fOffset = pos;
                this.fLength = 0;
                return true;
            }
            int charsRead = res;
            while (charsRead < BUFFER_SIZE) {
                res = reader.read(this.fBuf, charsRead, BUFFER_SIZE - charsRead);
                if (res == -1) {
                    this.fOffset = pos;
                    this.fLength = charsRead;
                    return true;
                }
                charsRead += res;
            }
            this.fOffset = pos;
            this.fLength = BUFFER_SIZE;
            return false;
        }

        public char get(int pos) {
            return this.fBuf[pos - this.fOffset];
        }

        public StringBuilder append(StringBuilder buf, int start, int length) {
            return buf.append(this.fBuf, start - this.fOffset, length);
        }

        public StringBuilder appendAll(StringBuilder buf) {
            return buf.append(this.fBuf, 0, this.fLength);
        }

        public int getEndOffset() {
            return this.fOffset + this.fLength;
        }

        public void removeFromChain() {
            this.fPrevious.fNext = this.fNext;
            this.fNext.fPrevious = this.fPrevious;
            this.fNext = this;
            this.fPrevious = this;
        }

        public void insertBefore(Buffer other) {
            this.fNext = other;
            this.fPrevious = other.fPrevious;
            this.fPrevious.fNext = this;
            other.fPrevious = this;
        }

        public Buffer getNext() {
            return this.fNext;
        }

        public Buffer getPrevious() {
            return this.fPrevious;
        }

        public void reset() {
            this.fOffset = -1;
            this.fLength = 0;
        }
    }

    private static final class CharSubSequence
    implements CharSequence {
        private final int fSequenceOffset;
        private final int fSequenceLength;
        private final FileCharSequence fParent;

        public CharSubSequence(FileCharSequence parent, int offset, int length) {
            this.fParent = parent;
            this.fSequenceOffset = offset;
            this.fSequenceLength = length;
        }

        @Override
        public int length() {
            return this.fSequenceLength;
        }

        @Override
        public char charAt(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("index must be larger than 0");
            }
            if (index >= this.fSequenceLength) {
                throw new IndexOutOfBoundsException("index must be smaller than length");
            }
            return this.fParent.charAt(this.fSequenceOffset + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end < start) {
                throw new IndexOutOfBoundsException("end cannot be smaller than start");
            }
            if (start < 0) {
                throw new IndexOutOfBoundsException("start must be larger than 0");
            }
            if (end > this.fSequenceLength) {
                throw new IndexOutOfBoundsException("end must be smaller or equal than length");
            }
            return this.fParent.subSequence(this.fSequenceOffset + start, this.fSequenceOffset + end);
        }

        @Override
        public String toString() {
            try {
                return this.fParent.getSubstring(this.fSequenceOffset, this.fSequenceLength);
            }
            catch (IOException e) {
                throw new FileCharSequenceException(e);
            }
            catch (CoreException e) {
                throw new FileCharSequenceException(e);
            }
        }
    }

    private final class FileCharSequence
    implements CharSequence {
        private static final String CHARSET_UTF_8 = "UTF-8";
        private Reader fReader;
        private int fReaderPos;
        private Integer fLength;
        private Buffer fMostCurrentBuffer;
        private int fNumberOfBuffers = 0;
        private IFile fFile;

        public FileCharSequence(IFile file) throws CoreException, IOException {
            this.reset(file);
        }

        public void reset(IFile file) throws CoreException, IOException {
            this.fFile = file;
            this.fLength = null;
            Buffer curr = this.fMostCurrentBuffer;
            if (curr != null) {
                do {
                    curr.reset();
                } while ((curr = curr.getNext()) != this.fMostCurrentBuffer);
            }
            this.initializeReader();
        }

        private void initializeReader() throws CoreException, IOException {
            if (this.fReader != null) {
                this.fReader.close();
            }
            String charset = this.fFile.getCharset();
            this.fReader = new InputStreamReader(this.getInputStream(charset), charset);
            this.fReaderPos = 0;
        }

        private InputStream getInputStream(String charset) throws CoreException, IOException {
            boolean ok = false;
            InputStream contents = this.fFile.getContents();
            try {
                IContentDescription description;
                if (CHARSET_UTF_8.equals(charset) && (description = this.fFile.getContentDescription()) != null && description.getProperty(IContentDescription.BYTE_ORDER_MARK) != null) {
                    int bytes;
                    int bomLength = IContentDescription.BOM_UTF_8.length;
                    byte[] bomStore = new byte[bomLength];
                    int bytesRead = 0;
                    do {
                        if ((bytes = contents.read(bomStore, bytesRead, bomLength - bytesRead)) != -1) continue;
                        throw new IOException();
                    } while ((bytesRead += bytes) < bomLength);
                    if (!Arrays.equals(bomStore, IContentDescription.BOM_UTF_8)) {
                        contents.close();
                        contents = this.fFile.getContents();
                    }
                }
                ok = true;
            }
            finally {
                if (!ok && contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return contents;
        }

        private void clearReader() throws IOException {
            if (this.fReader != null) {
                this.fReader.close();
            }
            this.fReader = null;
            this.fReaderPos = Integer.MAX_VALUE;
        }

        @Override
        public int length() {
            if (this.fLength == null) {
                try {
                    this.getBuffer(Integer.MAX_VALUE);
                }
                catch (IOException e) {
                    throw new FileCharSequenceException(e);
                }
                catch (CoreException e) {
                    throw new FileCharSequenceException(e);
                }
            }
            return this.fLength;
        }

        private Buffer getBuffer(int pos) throws IOException, CoreException {
            Buffer curr = this.fMostCurrentBuffer;
            if (curr != null) {
                do {
                    if (!curr.contains(pos)) continue;
                    return curr;
                } while ((curr = curr.getNext()) != this.fMostCurrentBuffer);
            }
            Buffer buf = this.findBufferToUse();
            this.fillBuffer(buf, pos);
            if (buf.contains(pos)) {
                return buf;
            }
            return null;
        }

        private Buffer findBufferToUse() {
            if (this.fNumberOfBuffers < NUMBER_OF_BUFFERS) {
                ++this.fNumberOfBuffers;
                Buffer newBuffer = new Buffer();
                if (this.fMostCurrentBuffer == null) {
                    this.fMostCurrentBuffer = newBuffer;
                    return newBuffer;
                }
                newBuffer.insertBefore(this.fMostCurrentBuffer);
                return newBuffer;
            }
            return this.fMostCurrentBuffer.getPrevious();
        }

        private boolean fillBuffer(Buffer buffer, int pos) throws CoreException, IOException {
            if (this.fReaderPos > pos) {
                this.initializeReader();
            }
            do {
                boolean endReached = buffer.fill(this.fReader, this.fReaderPos);
                this.fReaderPos = buffer.getEndOffset();
                if (!endReached) continue;
                this.fLength = this.fReaderPos;
                this.fReaderPos = Integer.MAX_VALUE;
                return true;
            } while (this.fReaderPos <= pos);
            return true;
        }

        @Override
        public char charAt(int index) {
            Buffer current = this.fMostCurrentBuffer;
            if (current != null && current.contains(index)) {
                return current.get(index);
            }
            if (index < 0) {
                throw new IndexOutOfBoundsException("index must be larger than 0");
            }
            if (this.fLength != null && index >= this.fLength) {
                throw new IndexOutOfBoundsException("index must be smaller than length");
            }
            try {
                Buffer buffer = this.getBuffer(index);
                if (buffer == null) {
                    throw new IndexOutOfBoundsException("index must be smaller than length");
                }
                if (buffer != this.fMostCurrentBuffer) {
                    if (buffer.getNext() != this.fMostCurrentBuffer) {
                        buffer.removeFromChain();
                        buffer.insertBefore(this.fMostCurrentBuffer);
                    }
                    this.fMostCurrentBuffer = buffer;
                }
                return buffer.get(index);
            }
            catch (IOException e) {
                throw new FileCharSequenceException(e);
            }
            catch (CoreException e) {
                throw new FileCharSequenceException(e);
            }
        }

        public String getSubstring(int start, int length) throws IOException, CoreException {
            int pos = start;
            int endPos = start + length;
            if (this.fLength != null && endPos > this.fLength) {
                throw new IndexOutOfBoundsException("end must be smaller than length");
            }
            StringBuilder res = new StringBuilder(length);
            Buffer buffer = this.getBuffer(pos);
            while (pos < endPos && buffer != null) {
                int bufEnd = buffer.getEndOffset();
                if (bufEnd >= endPos) {
                    return buffer.append(res, pos, endPos - pos).toString();
                }
                buffer.append(res, pos, bufEnd - pos);
                pos = bufEnd;
                buffer = this.getBuffer(pos);
            }
            return res.toString();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (end < start) {
                throw new IndexOutOfBoundsException("end cannot be smaller than start");
            }
            if (start < 0) {
                throw new IndexOutOfBoundsException("start must be larger than 0");
            }
            if (this.fLength != null && end > this.fLength) {
                throw new IndexOutOfBoundsException("end must be smaller than length");
            }
            return new CharSubSequence(this, start, end - start);
        }

        public void close() throws IOException {
            this.clearReader();
        }

        @Override
        public String toString() {
            int len = this.fLength != null ? this.fLength : 4000;
            StringBuilder res = new StringBuilder(len);
            try {
                Buffer buffer = this.getBuffer(0);
                while (buffer != null) {
                    buffer.appendAll(res);
                    buffer = this.getBuffer(res.length());
                }
                return res.toString();
            }
            catch (IOException e) {
                throw new FileCharSequenceException(e);
            }
            catch (CoreException e) {
                throw new FileCharSequenceException(e);
            }
        }
    }

    public static class FileCharSequenceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        FileCharSequenceException(IOException e) {
            super(e);
        }

        FileCharSequenceException(CoreException e) {
            super(e);
        }

        /*
         * WARNING - void declaration
         */
        public void throwWrappedException() throws CoreException, IOException {
            Throwable wrapped = this.getCause();
            Throwable throwable = wrapped;
            if (throwable instanceof CoreException) {
                void coreEx;
                CoreException coreException = (CoreException)throwable;
                CoreException cfr_ignored_0 = (CoreException)throwable;
                throw coreEx;
            }
            Throwable throwable2 = wrapped;
            if (throwable2 instanceof IOException) {
                void ioEx;
                IOException iOException = (IOException)throwable2;
                IOException cfr_ignored_1 = (IOException)throwable2;
                throw ioEx;
            }
        }
    }
}

