/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.embedder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.shared.utils.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProperties {
    private static final String MVN_MAVEN_CONFIG = ".mvn/maven.config";
    private static final Logger log = LoggerFactory.getLogger(MavenProperties.class);
    private static final String BUILD_VERSION_PROPERTY = "version";
    private static final String BUILD_VERSION_UNKNOWN_PROPERTY = "<version unknown>";
    private static String mavenVersion;
    private static String mavenBuildVersion;

    static {
        Properties properties = MavenProperties.getMavenRuntimeProperties();
        mavenVersion = properties.getProperty(BUILD_VERSION_PROPERTY, BUILD_VERSION_UNKNOWN_PROPERTY);
        mavenBuildVersion = MavenProperties.createMavenVersionString(properties);
    }

    private MavenProperties() {
    }

    static Properties getMavenRuntimeProperties() {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream resourceAsStream = MavenCli.class.getResourceAsStream("/org/apache/maven/messages/build.properties");){
                if (resourceAsStream != null) {
                    properties.load(resourceAsStream);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Unable to read Maven properties from JAR file: {}", (Object)e.getMessage());
        }
        return properties;
    }

    static String createMavenVersionString(Properties buildProperties) {
        String timestamp = MavenProperties.reduce(buildProperties.getProperty("timestamp"));
        String version = MavenProperties.reduce(buildProperties.getProperty(BUILD_VERSION_PROPERTY));
        String rev = MavenProperties.reduce(buildProperties.getProperty("buildNumber"));
        String distributionName = MavenProperties.reduce(buildProperties.getProperty("distributionName"));
        String msg = String.valueOf(distributionName) + " ";
        msg = String.valueOf(msg) + (version != null ? version : BUILD_VERSION_UNKNOWN_PROPERTY);
        if (rev != null || timestamp != null) {
            msg = String.valueOf(msg) + " (";
            msg = String.valueOf(msg) + (rev != null ? rev : "");
            if (StringUtils.isNotBlank((String)timestamp)) {
                String ts = MavenProperties.formatTimestamp(Long.parseLong(timestamp));
                msg = String.valueOf(msg) + (rev != null ? "; " : "") + ts;
            }
            msg = String.valueOf(msg) + ")";
        }
        return msg;
    }

    private static String reduce(String s) {
        return s != null ? (s.startsWith("${") && s.endsWith("}") ? null : s) : null;
    }

    private static String formatTimestamp(long timestamp) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
        return sdf.format(new Date(timestamp));
    }

    public static String getMavenBuildVersion() {
        return mavenBuildVersion;
    }

    public static String getMavenVersion() {
        return mavenVersion;
    }

    public static void setProperties(Properties properties) {
        if (properties != null) {
            properties.setProperty("maven.version", mavenVersion);
            properties.setProperty("maven.build.version", mavenBuildVersion);
        }
    }

    public static File computeMultiModuleProjectDirectory(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        return MavenProperties.computeMultiModuleProjectDirectory(location.toFile());
    }

    public static File computeMultiModuleProjectDirectory(File file) {
        if (file == null) {
            return null;
        }
        File basedir = file.isDirectory() ? file : file.getParentFile();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceRoot = workspace.getRoot().getLocation().toFile();
        File root = basedir;
        while (root != null && !root.equals(workspaceRoot)) {
            if (new File(root, ".mvn").isDirectory()) {
                return root;
            }
            root = root.getParentFile();
        }
        return null;
    }

    public static CommandLine getMavenArgs(File multiModuleProjectDirectory) throws IOException, ParseException {
        File configFile;
        if (multiModuleProjectDirectory != null && (configFile = new File(multiModuleProjectDirectory, MVN_MAVEN_CONFIG)).isFile()) {
            ArrayList<String> args = new ArrayList<String>();
            String[] stringArray = new String(Files.readAllBytes(configFile.toPath())).split("\\s+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                if (!arg.isEmpty()) {
                    args.add(arg);
                }
                ++n2;
            }
            CLIManager manager = new CLIManager();
            return manager.parse((String[])args.toArray(String[]::new));
        }
        return null;
    }

    public static void getProfiles(CommandLine commandLine, Consumer<String> activeProfilesConsumer, Consumer<String> inactiveProfilesConsumer) {
        String[] profileOptionValues;
        if (commandLine != null && commandLine.hasOption('P') && (profileOptionValues = commandLine.getOptionValues('P')) != null) {
            String[] stringArray = profileOptionValues;
            int n = profileOptionValues.length;
            int n2 = 0;
            while (n2 < n) {
                String profileOptionValue = stringArray[n2];
                StringTokenizer tokenizer = new StringTokenizer(profileOptionValue, ",");
                while (tokenizer.hasMoreTokens()) {
                    MavenProperties.getProfile(tokenizer.nextToken().trim(), activeProfilesConsumer, inactiveProfilesConsumer);
                }
                ++n2;
            }
        }
    }

    public static void getProfile(String profile, Consumer<String> activeProfilesConsumer, Consumer<String> inactiveProfilesConsumer) {
        if (profile.startsWith("-") || profile.startsWith("!")) {
            inactiveProfilesConsumer.accept(profile.substring(1));
        } else if (profile.startsWith("+")) {
            activeProfilesConsumer.accept(profile.substring(1));
        } else {
            activeProfilesConsumer.accept(profile);
        }
    }

    public static void getCliProperties(CommandLine commandLine, BiConsumer<String, String> consumer) {
        String[] defStrs;
        if (commandLine != null && commandLine.hasOption('D') && (defStrs = commandLine.getOptionValues('D')) != null) {
            String[] stringArray = defStrs;
            int n = defStrs.length;
            int n2 = 0;
            while (n2 < n) {
                String defStr = stringArray[n2];
                MavenProperties.getCliProperty(defStr, consumer);
                ++n2;
            }
        }
    }

    public static void getCliProperty(String property, BiConsumer<String, String> consumer) {
        int index = property.indexOf(61);
        if (index <= 0) {
            consumer.accept(property.trim(), "true");
        } else {
            consumer.accept(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
    }
}

