/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.ls.core.internal.IProjectImporter;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;

public abstract class AbstractProjectImporter
implements IProjectImporter {
    protected File rootFolder;
    protected Collection<Path> directories;

    @Override
    public void initialize(File rootFolder) {
        if (!Objects.equals(this.rootFolder, rootFolder)) {
            this.reset();
        }
        this.rootFolder = rootFolder;
    }

    @Override
    public abstract boolean applies(IProgressMonitor var1) throws OperationCanceledException, CoreException;

    @Override
    public boolean isResolved(File folder) throws OperationCanceledException, CoreException {
        return this.directories != null && this.directories.contains(folder.toPath());
    }

    @Override
    public abstract void importToWorkspace(IProgressMonitor var1) throws OperationCanceledException, CoreException;

    @Override
    public abstract void reset();

    protected static Preferences getPreferences() {
        return JavaLanguageServerPlugin.getPreferencesManager() == null || JavaLanguageServerPlugin.getPreferencesManager().getPreferences() == null ? new Preferences() : JavaLanguageServerPlugin.getPreferencesManager().getPreferences();
    }

    protected Collection<Path> findProjectPathByConfigurationName(Collection<IPath> projectConfigurations, List<String> names, boolean includeNested) {
        HashSet<Path> set = new HashSet<Path>();
        for (IPath path : projectConfigurations) {
            boolean matched = names.stream().anyMatch(name -> path.lastSegment().endsWith((String)name));
            if (!matched) continue;
            set.add(path.removeLastSegments(1).toFile().toPath());
        }
        List<Path> filteredPaths = set.stream().sorted().collect(Collectors.toList());
        if (includeNested) {
            return filteredPaths;
        }
        Path parentDir = null;
        LinkedList<Path> result = new LinkedList<Path>();
        for (Path path : filteredPaths) {
            if (parentDir == null) {
                result.add(path);
                parentDir = path;
                continue;
            }
            if (path.startsWith(parentDir)) continue;
            result.add(path);
            parentDir = path;
        }
        return result;
    }
}

