/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.eclipse.core.resources.IFile;
import org.eclipse.titan.common.parsers.SyntacticErrorStorage;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.ASN1Type;
import org.eclipse.titan.designer.AST.ASN1.Block;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting_Object;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting_ObjectSet;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting_Type;
import org.eclipse.titan.designer.AST.ASN1.Object.FieldSetting_Value;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_Visitor;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_literal;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_root;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_sequence;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClassSyntax_setting;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASN1.ObjectSet;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.ParserMarkerSupport;
import org.eclipse.titan.designer.parsers.asn1parser.Asn1Parser;
import org.eclipse.titan.designer.parsers.asn1parser.BlockLevelTokenStreamTracker;
import org.eclipse.titan.designer.parsers.asn1parser.TokenWithIndexAndSubTokens;

public final class ObjectClassSyntax_Parser
extends ObjectClassSyntax_Visitor {
    private final Block mBlock;
    private final Object_Definition myObject;
    private boolean success;
    private boolean previousSuccess;
    private int internalIndex;

    public ObjectClassSyntax_Parser(Block aBlock, Object_Definition myObject) {
        this.myObject = myObject;
        List<Token> tempTokens = aBlock.getTokenList();
        ArrayList<Token> temp = new ArrayList<Token>(tempTokens.size());
        for (int i = 0; i < tempTokens.size(); ++i) {
            temp.add(tempTokens.get(i));
        }
        temp.add((Token)new TokenWithIndexAndSubTokens(-1));
        this.mBlock = new Block(temp, aBlock.getLocation());
        this.mBlock.setFullNameParent(aBlock);
        this.success = true;
        this.internalIndex = 0;
    }

    @Override
    public void visitSetting(ObjectClassSyntax_setting parameter) {
        FieldSetting fieldSetting = null;
        switch (parameter.getSettingType()) {
            case S_T: {
                ASN1Type type = this.parseType();
                if (null == type) break;
                fieldSetting = new FieldSetting_Type(parameter.getIdentifier().newInstance(), type);
                fieldSetting.setLocation(this.mBlock.getLocation());
                break;
            }
            case S_V: {
                Value value = this.parseValue();
                if (value == null) break;
                fieldSetting = new FieldSetting_Value(parameter.getIdentifier().newInstance(), value);
                fieldSetting.setLocation(this.mBlock.getLocation());
                break;
            }
            case S_VS: {
                break;
            }
            case S_O: {
                ASN1Object object = this.parseObject();
                if (null == object) break;
                fieldSetting = new FieldSetting_Object(parameter.getIdentifier().newInstance(), object);
                fieldSetting.setLocation(this.mBlock.getLocation());
                break;
            }
            case S_OS: {
                ObjectSet objectSet = this.parseObjectSet();
                if (null == objectSet) break;
                fieldSetting = new FieldSetting_ObjectSet(parameter.getIdentifier().newInstance(), objectSet);
                fieldSetting.setLocation(this.mBlock.getLocation());
                break;
            }
        }
        this.previousSuccess = null != fieldSetting;
        this.myObject.addFieldSetting(fieldSetting);
    }

    @Override
    public void visitRoot(ObjectClassSyntax_root parameter) {
        if (!(this.mBlock == null || this.success && parameter.getIsBuilt() && !this.mBlock.getTokenList().isEmpty())) {
            return;
        }
        this.previousSuccess = false;
        parameter.getSequence().accept(this);
        if (null != this.mBlock && this.success && this.internalIndex < this.mBlock.getTokenList().size() && this.mBlock.getTokenList().get(this.internalIndex).getType() != -1) {
            this.success = false;
            Token token = this.mBlock.getTokenList().get(this.internalIndex);
            this.myObject.getLocation().reportSemanticError("Unexpected `" + token.getText() + "', it is a superfluous part");
        }
        if (!this.success) {
            this.myObject.getLocation().reportSemanticError("Check the syntax of objectclass");
            this.myObject.setIsErroneous(true);
        }
    }

    @Override
    public void visitLiteral(ObjectClassSyntax_literal parameter) {
        this.previousSuccess = false;
        if (null != this.mBlock && this.mBlock.getTokenList().size() <= this.internalIndex) {
            return;
        }
        if (null != this.mBlock) {
            Token token = this.mBlock.getTokenList().get(this.internalIndex);
            if (null == token.getText()) {
                return;
            }
            if (token.getText().equals(parameter.getLiteral())) {
                if (this.internalIndex < this.mBlock.getTokenList().size() - 1) {
                    ++this.internalIndex;
                }
                this.previousSuccess = true;
            }
        }
    }

    @Override
    public void visitSequence(ObjectClassSyntax_sequence parameter) {
        if (null != this.mBlock && this.mBlock.getTokenList().size() <= this.internalIndex) {
            return;
        }
        if (null != this.mBlock) {
            int i;
            Token token = this.mBlock.getTokenList().get(this.internalIndex);
            if (parameter.getOptionalFirstComma() && this.myObject.getNofFieldSettings() > 0) {
                if (token.getType() == 116) {
                    if (this.internalIndex < this.mBlock.getTokenList().size() - 1) {
                        ++this.internalIndex;
                    }
                } else {
                    if (parameter.getIsOptional()) {
                        this.previousSuccess = true;
                    } else {
                        this.success = false;
                        this.myObject.getLocation().reportSemanticError("Unexpected `" + token.getText() + "', expecting `,'");
                    }
                    return;
                }
                i = 0;
            } else {
                if (0 == parameter.getNofNodes()) {
                    return;
                }
                parameter.getNthNode(0).accept(this);
                if (!this.success) {
                    return;
                }
                if (!this.previousSuccess) {
                    if (parameter.getIsOptional()) {
                        this.previousSuccess = true;
                    } else {
                        this.success = false;
                        this.myObject.getLocation().reportSemanticError("Unexpected `" + token.getText() + "', expecting `" + parameter.getNthNode(0).getDisplayName() + "'");
                    }
                    return;
                }
                i = 1;
            }
            while (i < parameter.getNofNodes()) {
                parameter.getNthNode(i).accept(this);
                if (!this.previousSuccess) {
                    if (parameter.getIsOptional()) {
                        this.previousSuccess = true;
                        --this.internalIndex;
                        return;
                    }
                    this.success = false;
                    if (this.mBlock.getTokenList().size() <= this.internalIndex) {
                        return;
                    }
                    token = this.mBlock.getTokenList().get(this.internalIndex);
                    this.myObject.getLocation().reportSemanticError("Unexpected `" + token.getText() + "', expecting `" + parameter.getNthNode(i).getDisplayName() + "'");
                }
                if (!this.success) {
                    return;
                }
                ++i;
            }
        }
    }

    private ASN1Type parseType() {
        Asn1Parser parser;
        ASN1Type type = null;
        if (this.mBlock != null && (parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock, this.internalIndex)) != null) {
            type = parser.pr_special_Type().type;
            this.internalIndex += parser.nof_consumed_tokens();
            List<SyntacticErrorStorage> errors = parser.getErrorStorage();
            if (null != errors && !errors.isEmpty()) {
                for (int i = 0; i < errors.size(); ++i) {
                    IFile file = (IFile)this.mBlock.getLocation().getFile();
                    ParserMarkerSupport.createOnTheFlyMixedMarker(file, errors.get(i), 2);
                }
            }
        }
        return type;
    }

    private Value parseValue() {
        if (this.mBlock != null) {
            Asn1Parser parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock, this.internalIndex);
            if (parser != null) {
                Value temp = parser.pr_special_Value().value;
                this.internalIndex += parser.nof_consumed_tokens();
                List<SyntacticErrorStorage> errors = parser.getErrorStorage();
                if (null != errors && !errors.isEmpty()) {
                    for (int i = 0; i < errors.size(); ++i) {
                        ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
                    }
                }
                return temp;
            }
            return null;
        }
        return null;
    }

    private ASN1Object parseObject() {
        Asn1Parser parser;
        ASN1Object object = null;
        if (this.mBlock != null && (parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock, this.internalIndex)) != null) {
            object = parser.pr_special_Object().object;
            this.internalIndex += parser.nof_consumed_tokens();
            List<SyntacticErrorStorage> errors = parser.getErrorStorage();
            if (null != errors && !errors.isEmpty()) {
                for (int i = 0; i < errors.size(); ++i) {
                    ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
                }
            }
        }
        return object;
    }

    private ObjectSet parseObjectSet() {
        Asn1Parser parser;
        ObjectSet objectSet = null;
        if (this.mBlock != null && (parser = BlockLevelTokenStreamTracker.getASN1ParserForBlock(this.mBlock, this.internalIndex)) != null) {
            objectSet = parser.pr_special_ObjectSet().objectSet;
            this.internalIndex += parser.nof_consumed_tokens();
            List<SyntacticErrorStorage> errors = parser.getErrorStorage();
            if (null != errors && !errors.isEmpty()) {
                for (int i = 0; i < errors.size(); ++i) {
                    ParserMarkerSupport.createOnTheFlyMixedMarker((IFile)this.mBlock.getLocation().getFile(), errors.get(i), 2);
                }
            }
        }
        return objectSet;
    }
}

