/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.statements.Getreply_Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Parameter_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.Value_Redirection;
import org.eclipse.titan.designer.AST.TTCN3.templates.TemplateInstance;
import org.eclipse.titan.designer.AST.TTCN3.types.PortGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Signature_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Check_Getreply_Statement
extends Statement {
    private static final String FULLNAMEPART1 = ".portreference";
    private static final String FULLNAMEPART2 = ".parameter";
    private static final String FULLNAMEPART3 = ".valuematch";
    private static final String FULLNAMEPART4 = ".from";
    private static final String FULLNAMEPART5 = ".redirectValue";
    private static final String FULLNAMEPART6 = ".parameters";
    private static final String FULLNAMEPART7 = ".redirectSender";
    private static final String FULLNAMEPART8 = ".redirectIndex";
    private static final String FULLNAMEPART9 = ".redirectTimestamp";
    private static final String STATEMENT_NAME = "check-getreply";
    private final Reference portReference;
    private final boolean anyFrom;
    private final TemplateInstance parameter;
    private final TemplateInstance valueMatch;
    private final TemplateInstance fromClause;
    private final Value_Redirection redirectValue;
    private final Parameter_Redirection redirectParameter;
    private final Reference redirectSender;
    private final Reference redirectIndex;
    private final Reference redirectTimestamp;

    public Check_Getreply_Statement(Reference portReference, boolean anyFrom, TemplateInstance parameter, TemplateInstance valueMatch, TemplateInstance fromClause, Value_Redirection redirectValue, Parameter_Redirection redirectParameter, Reference redirectSender, Reference redirectIndex, Reference redirectTimestamp) {
        this.portReference = portReference;
        this.anyFrom = anyFrom;
        this.parameter = parameter;
        this.valueMatch = valueMatch;
        this.fromClause = fromClause;
        this.redirectValue = redirectValue;
        this.redirectParameter = redirectParameter;
        this.redirectSender = redirectSender;
        this.redirectIndex = redirectIndex;
        this.redirectTimestamp = redirectTimestamp;
        if (portReference != null) {
            portReference.setFullNameParent(this);
        }
        if (parameter != null) {
            parameter.setFullNameParent(this);
        }
        if (valueMatch != null) {
            valueMatch.setFullNameParent(this);
        }
        if (fromClause != null) {
            fromClause.setFullNameParent(this);
        }
        if (redirectValue != null) {
            redirectValue.setFullNameParent(this);
        }
        if (redirectParameter != null) {
            redirectParameter.setFullNameParent(this);
        }
        if (redirectSender != null) {
            redirectSender.setFullNameParent(this);
        }
        if (redirectIndex != null) {
            redirectIndex.setFullNameParent(this);
        }
        if (redirectTimestamp != null) {
            redirectTimestamp.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_CHECK_GETREPLY;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.portReference == child) {
            return builder.append(FULLNAMEPART1);
        }
        if (this.parameter == child) {
            return builder.append(FULLNAMEPART2);
        }
        if (this.valueMatch == child) {
            return builder.append(FULLNAMEPART3);
        }
        if (this.fromClause == child) {
            return builder.append(FULLNAMEPART4);
        }
        if (this.redirectValue == child) {
            return builder.append(FULLNAMEPART5);
        }
        if (this.redirectParameter == child) {
            return builder.append(FULLNAMEPART6);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART7);
        }
        if (this.redirectSender == child) {
            return builder.append(FULLNAMEPART8);
        }
        if (this.redirectTimestamp == child) {
            return builder.append(FULLNAMEPART9);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.portReference != null) {
            this.portReference.setMyScope(scope);
        }
        if (this.parameter != null) {
            this.parameter.setMyScope(scope);
        }
        if (this.valueMatch != null) {
            this.valueMatch.setMyScope(scope);
        }
        if (this.fromClause != null) {
            this.fromClause.setMyScope(scope);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setMyScope(scope);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.setMyScope(scope);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setMyScope(scope);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setMyScope(scope);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.portReference != null) {
            this.portReference.setCodeSection(codeSection);
        }
        if (this.parameter != null) {
            this.parameter.setCodeSection(codeSection);
        }
        if (this.valueMatch != null) {
            this.valueMatch.setCodeSection(codeSection);
        }
        if (this.fromClause != null) {
            this.fromClause.setCodeSection(codeSection);
        }
        if (this.redirectValue != null) {
            this.redirectValue.setCodeSection(codeSection);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.setCodeSection(codeSection);
        }
        if (this.redirectSender != null) {
            this.redirectSender.setCodeSection(codeSection);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setCodeSection(codeSection);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean hasReceivingStatement() {
        return true;
    }

    @Override
    public boolean canRepeat() {
        return false;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Getreply_Statement.checkGetreply(timestamp, this, STATEMENT_NAME, this.portReference, this.anyFrom, this.parameter, this.valueMatch, this.fromClause, this.redirectValue, this.redirectParameter, this.redirectSender, this.redirectIndex, this.redirectTimestamp);
        if (this.redirectValue != null) {
            // empty if block
        }
        if (this.redirectSender != null) {
            this.redirectSender.setUsedOnLeftHandSide();
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.setUsedOnLeftHandSide();
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.setUsedOnLeftHandSide();
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.redirectSender != null) {
            return null;
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.add(145);
        if (this.redirectParameter != null) {
            return result;
        }
        result.add(119);
        if (this.redirectValue != null) {
            return result;
        }
        result.add(253);
        if (this.fromClause != null) {
            return result;
        }
        result.add(62);
        if (this.parameter != null) {
            return result;
        }
        result.add(297);
        return result;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.portReference != null) {
            this.portReference.updateSyntax(reparser, false);
            reparser.updateLocation(this.portReference.getLocation());
        }
        if (this.parameter != null) {
            this.parameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.parameter.getLocation());
        }
        if (this.valueMatch != null) {
            this.valueMatch.updateSyntax(reparser, false);
            reparser.updateLocation(this.valueMatch.getLocation());
        }
        if (this.fromClause != null) {
            this.fromClause.updateSyntax(reparser, false);
            reparser.updateLocation(this.fromClause.getLocation());
        }
        if (this.redirectValue != null) {
            this.redirectValue.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectValue.getLocation());
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectParameter.getLocation());
        }
        if (this.redirectSender != null) {
            this.redirectSender.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectSender.getLocation());
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectIndex.getLocation());
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.updateSyntax(reparser, false);
            reparser.updateLocation(this.redirectTimestamp.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.portReference != null) {
            this.portReference.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.parameter != null) {
            this.parameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.valueMatch != null) {
            this.valueMatch.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.fromClause != null) {
            this.fromClause.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectValue != null) {
            this.redirectValue.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectParameter != null) {
            this.redirectParameter.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectSender != null) {
            this.redirectSender.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectIndex != null) {
            this.redirectIndex.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.redirectTimestamp != null) {
            this.redirectTimestamp.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.portReference != null && !this.portReference.accept(v)) {
            return false;
        }
        if (this.parameter != null && !this.parameter.accept(v)) {
            return false;
        }
        if (this.valueMatch != null && !this.valueMatch.accept(v)) {
            return false;
        }
        if (this.fromClause != null && !this.fromClause.accept(v)) {
            return false;
        }
        if (this.redirectValue != null && !this.redirectValue.accept(v)) {
            return false;
        }
        if (this.redirectParameter != null && !this.redirectParameter.accept(v)) {
            return false;
        }
        if (this.redirectSender != null && !this.redirectSender.accept(v)) {
            return false;
        }
        if (this.redirectIndex != null && !this.redirectIndex.accept(v)) {
            return false;
        }
        return this.redirectTimestamp == null || this.redirectTimestamp.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        ExpressionStruct expression = new ExpressionStruct();
        this.generateCodeExpression(aData, expression, null);
        source.append((CharSequence)expression.preamble);
        PortGenerator.generateCodeStandalone(aData, source, expression.expression.toString(), this.getStatementName(), this.canRepeat(), this.getLocation());
    }

    @Override
    public void generateCodeExpression(JavaGenData aData, ExpressionStruct expression, String callTimer) {
        if (this.portReference != null) {
            this.portReference.generateCode(aData, expression);
            expression.expression.append(".check_getreply(");
            if (this.parameter != null) {
                boolean hasDecodedParamRedirect = this.redirectParameter != null && this.redirectParameter.hasDecodedModifier();
                int parameterExpressionStart = expression.expression.length();
                this.parameter.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE, hasDecodedParamRedirect);
                String lastGenParExpression = expression.expression.substring(parameterExpressionStart);
                String lastGenValueExpression = null;
                IType signature = this.parameter.getTemplateBody().getMyGovernor();
                IType signatureType = signature.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                Type returnType = ((Signature_Type)signatureType).getSignatureReturnType();
                if (returnType != null) {
                    expression.expression.append(".set_value_template(");
                    if (this.valueMatch != null) {
                        boolean hasDecodedValueRedirect = this.redirectValue != null && this.redirectValue.hasDecodedModifier();
                        int valueExpressionStart = expression.expression.length();
                        this.valueMatch.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE, hasDecodedValueRedirect);
                        lastGenValueExpression = expression.expression.substring(valueExpressionStart);
                    } else {
                        expression.expression.append(MessageFormat.format("new {0}(template_sel.ANY_VALUE)", returnType.getGenNameTemplate(aData, expression.expression)));
                    }
                    expression.expression.append(')');
                }
                expression.expression.append(", ");
                this.generateCodeExprFromclause(aData, expression);
                if (hasDecodedParamRedirect) {
                    String tempID = aData.getTemporaryVariableName();
                    this.redirectParameter.generateCodeDecoded(aData, expression.preamble, this.parameter, tempID, true);
                    IType lastSignatureType = signature.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    String signatureName = lastSignatureType.getGenNameOwn();
                    expression.expression.append(MessageFormat.format(", new {0}_reply_redirect_{1}(", signatureName, tempID));
                } else {
                    expression.expression.append(MessageFormat.format(", new {0}_reply_redirect(", signature.getGenNameValue(aData, expression.expression)));
                }
                if (returnType != null) {
                    if (this.redirectValue == null) {
                        expression.expression.append("null");
                    } else {
                        this.redirectValue.generateCode(aData, expression, this.valueMatch, lastGenValueExpression);
                    }
                    if (this.redirectParameter != null) {
                        expression.expression.append(", ");
                    }
                }
                if (this.redirectParameter != null) {
                    this.redirectParameter.generateCode(aData, expression, this.parameter, lastGenParExpression, true);
                }
                expression.expression.append("), ");
                if (this.redirectSender == null) {
                    expression.expression.append("null");
                } else {
                    this.redirectSender.generateCode(aData, expression);
                }
            } else {
                this.generateCodeExprFromclause(aData, expression);
                expression.expression.append(", ");
                if (this.redirectSender == null) {
                    expression.expression.append("null");
                } else {
                    this.redirectSender.generateCode(aData, expression);
                }
            }
            expression.expression.append(", ");
            if (this.redirectTimestamp == null) {
                expression.expression.append("null");
            } else {
                this.redirectTimestamp.generateCode(aData, expression);
            }
            expression.expression.append(",");
            if (this.redirectIndex == null) {
                expression.expression.append("null");
            } else {
                Check_Getreply_Statement.generateCodeIndexRedirect(aData, expression, this.redirectIndex, this.getMyScope());
            }
        } else {
            expression.expression.append("TitanPort.any_check_getreply(");
            this.generateCodeExprFromclause(aData, expression);
            expression.expression.append(", ");
            if (this.redirectSender == null) {
                expression.expression.append("null");
            } else {
                this.redirectSender.generateCode(aData, expression);
            }
            expression.expression.append(", ");
            if (this.redirectTimestamp == null) {
                expression.expression.append("null");
            } else {
                this.redirectTimestamp.generateCode(aData, expression);
            }
        }
        expression.expression.append(')');
    }

    private void generateCodeExprFromclause(JavaGenData aData, ExpressionStruct expression) {
        if (this.fromClause != null) {
            this.fromClause.generateCode(aData, expression, TemplateRestriction.Restriction_type.TR_NONE);
        } else if (this.redirectSender != null) {
            IType varType = this.redirectSender.checkVariableReference(CompilationTimeStamp.getBaseTimestamp());
            if (varType == null) {
                ErrorReporter.INTERNAL_ERROR((String)("Encountered a redirection with unknown type `" + this.getFullName() + "''"));
            }
            if (varType.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp()).getTypetype() == IType.Type_type.TYPE_COMPONENT) {
                aData.addBuiltinTypeImport("TitanComponent_template");
                expression.expression.append("TitanComponent_template.any_compref");
            } else {
                expression.expression.append(MessageFormat.format("new {0}(template_sel.ANY_VALUE)", varType.getGenNameTemplate(aData, expression.expression)));
            }
        } else {
            aData.addBuiltinTypeImport("TitanComponent_template");
            expression.expression.append("TitanComponent_template.any_compref");
        }
    }
}

