/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.NULL_Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.AltGuards;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.AST.TTCN3.types.Class_Type;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class SelectClassCase
extends ASTNode
implements ILocateableNode,
IIncrementallyUpdateable {
    private static final String UNREACHABLE = "Control never reaches this code because of previous effective case(s)";
    private static final String CLASSEXPECTED = "Class type was expected";
    private static final String NEVERCHOSEN = "Control never reaches this code because the case will never be chosen";
    private final Type type;
    private final StatementBlock statementBlock;
    private boolean alwaysFalse;
    private Location location = NULL_Location.INSTANCE;

    public SelectClassCase(Type type, StatementBlock statementBlock) {
        this.type = type;
        this.statementBlock = statementBlock;
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.type != null) {
            this.type.setMyScope(scope);
        }
        if (this.statementBlock != null) {
            this.statementBlock.setMyScope(scope);
        }
    }

    public void setMyStatementBlock(StatementBlock parStatementBlock, int index) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyStatementBlock(parStatementBlock, index);
        }
    }

    public void setMyDefinition(Definition definition) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyDefinition(definition);
        }
    }

    public void setMyAltguards(AltGuards altGuards) {
        if (this.statementBlock != null) {
            this.statementBlock.setMyAltguards(altGuards);
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.type != null) {
            this.type.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.statementBlock != null) {
            this.statementBlock.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    public boolean check(CompilationTimeStamp timestamp, Class_Type governor, boolean unreachable) {
        if (unreachable) {
            this.getLocation().reportSemanticWarning(UNREACHABLE);
        }
        if (this.type != null) {
            this.type.check(timestamp);
            IType typeLast = this.type.getTypeRefdLast(timestamp);
            if (!(typeLast instanceof Class_Type)) {
                this.type.getLocation().reportSemanticError(CLASSEXPECTED);
            } else if (!unreachable) {
                Class_Type classLast = typeLast.getClassType();
                if (governor != null && !classLast.isParentClass(timestamp, governor) && !governor.isParentClass(timestamp, classLast)) {
                    this.statementBlock.getLocation().reportSemanticWarning(NEVERCHOSEN);
                    this.alwaysFalse = true;
                }
            }
        } else {
            unreachable = true;
        }
        this.statementBlock.check(timestamp);
        return unreachable;
    }

    public void postCheck() {
        if (this.statementBlock != null) {
            this.statementBlock.postCheck();
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.type != null) {
            this.type.updateSyntax(reparser, false);
            reparser.updateLocation(this.type.getLocation());
        }
        if (this.statementBlock != null) {
            this.statementBlock.updateSyntax(reparser, false);
            reparser.updateLocation(this.statementBlock.getLocation());
        }
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.type != null && !this.type.accept(v)) {
            return false;
        }
        return this.statementBlock == null || this.statementBlock.accept(v);
    }

    public StatementBlock getStatementBlock() {
        return this.statementBlock;
    }

    public Type getType() {
        return this.type;
    }
}

