/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Definition;
import org.eclipse.titan.designer.AST.TTCN3.statements.Port_Utility;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Stop_Component_Statement
extends Statement {
    private static final String FULLNAMEPART = ".componentreference";
    private static final String STATEMENT_NAME = "stop test component";
    private final IValue componentReference;

    public Stop_Component_Statement(IValue componentReference) {
        this.componentReference = componentReference;
        if (componentReference != null) {
            componentReference.setFullNameParent(this);
        }
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_STOP_COMPONENT;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.componentReference == child) {
            return builder.append(FULLNAMEPART);
        }
        return builder;
    }

    @Override
    public void setMyScope(Scope scope) {
        if (this.componentReference != null) {
            this.componentReference.setMyScope(scope);
        }
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.componentReference != null) {
            this.componentReference.setCodeSection(codeSection);
        }
    }

    @Override
    public boolean isTerminating(CompilationTimeStamp timestamp) {
        IValue last;
        if (this.componentReference != null && IValue.Value_type.EXPRESSION_VALUE.equals((Object)(last = this.componentReference.getValueRefdLast(timestamp, null)).getValuetype())) {
            switch (((Expression_Value)last).getOperationType()) {
                case SELF_COMPONENT_OPERATION: 
                case MTC_COMPONENT_OPERATION: {
                    return true;
                }
            }
        }
        return super.isTerminating(timestamp);
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        Port_Utility.checkComponentReference(timestamp, this, this.componentReference, true, false, false);
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.componentReference instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.componentReference)).updateSyntax(reparser, false);
            reparser.updateLocation(this.componentReference.getLocation());
        } else if (this.componentReference != null) {
            throw new ReParseException();
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.componentReference == null) {
            return;
        }
        this.componentReference.findReferences(referenceFinder, foundIdentifiers);
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.componentReference == null || this.componentReference.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        aData.addCommonLibraryImport("TTCN_Runtime");
        ExpressionStruct expression = new ExpressionStruct();
        if (this.componentReference == null) {
            aData.addBuiltinTypeImport("TitanComponent");
            expression.expression.append("TTCN_Runtime.stop_component(TitanComponent.ALL_COMPREF)");
        } else {
            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
            IValue last = this.componentReference.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), referenceChain);
            referenceChain.release();
            if (last.getValuetype() == IValue.Value_type.REFERENCED_VALUE) {
                last.generateCodeExpressionMandatory(aData, expression, true);
                expression.expression.append(".stop()");
            } else {
                boolean refers_to_self = false;
                if (last.getValuetype() == IValue.Value_type.EXPRESSION_VALUE) {
                    switch (((Expression_Value)last).getOperationType()) {
                        case MTC_COMPONENT_OPERATION: {
                            Definition myDefinition = this.myStatementBlock.getMyDefinition();
                            if (myDefinition == null || myDefinition.getAssignmentType() != Assignment.Assignment_type.A_TESTCASE) break;
                            refers_to_self = true;
                            break;
                        }
                        case SELF_COMPONENT_OPERATION: {
                            refers_to_self = true;
                        }
                    }
                }
                if (refers_to_self) {
                    expression.expression.append("TTCN_Runtime.stop_execution()");
                } else {
                    expression.expression.append("TTCN_Runtime.stop_component(");
                    last.generateCodeExpression(aData, expression, false);
                    expression.expression.append(')');
                }
            }
        }
        expression.mergeExpression(source);
    }
}

