/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.titan.common.fieldeditors.TITANResourceLocatorFieldEditor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathUtil;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.common.utils.StringUtils;
import org.eclipse.titan.designer.core.ant.AntLaunchConfigGenerator;
import org.eclipse.titan.designer.core.ant.AntScriptGenerator;
import org.eclipse.titan.designer.core.ant.CliScriptGenerator;
import org.eclipse.titan.designer.preferences.pages.ComboFieldEditor;
import org.eclipse.titan.designer.properties.data.MakefileCreationData;
import org.eclipse.titan.designer.properties.pages.ProjectJavaBuildPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class JavaCreationTab {
    private static final String JAVA_CREATION_TAB_TITLE = "Java target creation attributes";
    private final IProject project;
    private final PropertyPage page;
    private Composite automaticBuildPropertiesComposite;
    private Composite defaultJavaTargetComposite;
    private Composite javaTargetComposite;
    private ComboFieldEditor defaultJavaTarget;
    private TabItem creationAttributesTabItem;
    private TITANResourceLocatorFieldEditor temporalJavaTargetFileFieldEditor;
    public static final String TEMPORAL_JAVA_TARGET = "org.eclipse.titan.designer.temporalJavaTarget";
    private Button generateStartShScript;
    private Button generateStartBatScript;

    public JavaCreationTab(IProject project, PropertyPage page) {
        this.project = project;
        this.page = page;
    }

    public JavaCreationTab(IProject project) {
        this.project = project;
        this.page = null;
    }

    public void dispose() {
    }

    protected TabItem createContents(TabFolder tabFolder) {
        this.creationAttributesTabItem = new TabItem(tabFolder, 2048);
        this.creationAttributesTabItem.setText(JAVA_CREATION_TAB_TITLE);
        this.creationAttributesTabItem.setToolTipText("Settings controlling the generation of Java binaries.");
        this.automaticBuildPropertiesComposite = new Composite((Composite)tabFolder, 2);
        this.automaticBuildPropertiesComposite.setEnabled(true);
        this.automaticBuildPropertiesComposite.setLayout((Layout)new GridLayout());
        this.defaultJavaTargetComposite = new Composite(this.automaticBuildPropertiesComposite, 0);
        this.defaultJavaTarget = new ComboFieldEditor("defaultTarget", "Default target:", MakefileCreationData.DefaultJavaTarget.getDisplayNamesAndValues(), this.defaultJavaTargetComposite);
        this.defaultJavaTarget.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                JavaCreationTab.this.updateDefaultJavaTarget();
            }
        });
        this.javaTargetComposite = new Composite(this.automaticBuildPropertiesComposite, 0);
        GridLayout targetExecutableLayout = new GridLayout();
        this.javaTargetComposite.setLayout((Layout)targetExecutableLayout);
        GridData targetExecutableData = new GridData(4);
        targetExecutableData.grabExcessHorizontalSpace = true;
        targetExecutableData.horizontalAlignment = 4;
        this.javaTargetComposite.setLayoutData((Object)targetExecutableData);
        this.temporalJavaTargetFileFieldEditor = new TITANResourceLocatorFieldEditor(TEMPORAL_JAVA_TARGET, "JAR file:", this.javaTargetComposite, 1, this.project.getLocation().toOSString());
        this.temporalJavaTargetFileFieldEditor.getLabelControl(this.javaTargetComposite).setToolTipText("The target of the Java build process.\nThis field is optional.\nIf it is not set, only Java class files will be generated into the working directory.");
        String[] extensions = new String[]{"*.jar;*.zip", "*.*"};
        this.temporalJavaTargetFileFieldEditor.setFilterExtensions(extensions);
        if (this.page != null) {
            this.temporalJavaTargetFileFieldEditor.setPage((DialogPage)this.page);
        }
        this.generateStartShScript = new Button(this.automaticBuildPropertiesComposite, 32);
        this.generateStartShScript.setText("Generate 'titan_java_start.sh' shell script for starting the JAR (Linux)");
        this.generateStartShScript.setEnabled(false);
        this.generateStartShScript.setToolTipText("If this option is set, also a shell script will be generated to start the JAR");
        this.generateStartBatScript = new Button(this.automaticBuildPropertiesComposite, 32);
        this.generateStartBatScript.setText("Generate 'titan_java_start.cmd' script for starting the JAR (WIN)");
        this.generateStartBatScript.setEnabled(false);
        this.generateStartBatScript.setVisible(false);
        this.generateStartBatScript.setToolTipText("If this option is set, also a .bat script will be generated to start the JAR");
        this.creationAttributesTabItem.setControl((Control)this.automaticBuildPropertiesComposite);
        return this.creationAttributesTabItem;
    }

    public boolean checkProperties(ProjectJavaBuildPropertyPage page) {
        if (!(!this.temporalJavaTargetFileFieldEditor.getStringValue().isEmpty() && this.temporalJavaTargetFileFieldEditor.isValid() || this.isClassSelected())) {
            String errorMessage = this.temporalJavaTargetFileFieldEditor.getErrorMessage();
            if (errorMessage == null) {
                errorMessage = "The Java target is not set";
            }
            page.setErrorMessage(errorMessage);
            return false;
        }
        return true;
    }

    public void copyPropertyStore(IProject project, PreferenceStore tempStorage) {
        String temp = null;
        try {
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultJavaTarget"));
            if (temp != null) {
                tempStorage.setValue("defaultJavaTarget", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"))) != null) {
                tempStorage.setValue("targetExecutable", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartShScript"))) != null) {
                tempStorage.setValue("generateStartShScript", temp);
            }
            if ((temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartBatScript"))) != null) {
                tempStorage.setValue("generateStartBatScript", temp);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public boolean evaluatePropertyStore(IProject project, PreferenceStore tempStorage) {
        boolean result = false;
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultJavaTarget"));
            copyValue = tempStorage.getString("defaultJavaTarget");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            copyValue = tempStorage.getString("targetExecutable");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartShScript"));
            copyValue = tempStorage.getString("generateStartShScript");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
            actualValue = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartBatScript"));
            copyValue = tempStorage.getString("generateStartBatScript");
            result |= actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        return result;
    }

    public void loadProperties(IProject project) {
        boolean useAbsolutePath = false;
        try {
            String temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "defaultJavaTarget"));
            if (StringUtils.isNullOrEmpty((String)temp)) {
                this.defaultJavaTarget.setSelectedValue(MakefileCreationData.DefaultJavaTarget.getDefault().toString());
            } else {
                try {
                    this.defaultJavaTarget.setSelectedValue(MakefileCreationData.DefaultJavaTarget.createInstance(temp).toString());
                }
                catch (IllegalArgumentException e) {
                    ErrorReporter.INTERNAL_ERROR((String)("Unknown default target in Java target creation tab: " + temp));
                }
            }
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"));
            if (temp == null) {
                this.temporalJavaTargetFileFieldEditor.setStringValue(MakefileCreationData.getDefaultJavaTargetName(project, false));
            } else {
                this.temporalJavaTargetFileFieldEditor.setStringValue(temp);
            }
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartShScript"));
            this.generateStartShScript.setSelection("true".equals(temp));
            temp = project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateStartBatScript"));
            this.generateStartBatScript.setSelection("true".equals(temp));
            this.updateDefaultJavaTarget();
        }
        catch (CoreException e) {
            this.performDefaults(project);
        }
    }

    public boolean saveProperties(IProject project) {
        try {
            this.setProperty(project, "defaultJavaTarget", this.defaultJavaTarget.getActualValue());
            this.setProperty(project, "generateStartShScript", String.valueOf(this.generateStartShScript.getSelection()));
            this.setProperty(project, "generateStartBatScript", String.valueOf(this.generateStartBatScript.getSelection()));
            String temp = this.temporalJavaTargetFileFieldEditor.getStringValue();
            URI path = URIUtil.toURI((String)temp);
            URI resolvedPath = TITANPathUtilities.resolvePathURI((String)temp, (String)project.getLocation().toOSString());
            if (path.equals(resolvedPath)) {
                temp = PathUtil.getRelativePath((String)project.getLocation().toOSString(), (String)temp);
            }
            boolean updated = this.setProperty(project, "targetExecutable", temp);
            if (this.isExecutableSelected()) {
                if (AntScriptGenerator.generateAndStoreBuildXML(project, updated)) {
                    AntLaunchConfigGenerator.createAntLaunchConfiguration(project);
                    AntLaunchConfigGenerator.addAntBuilder(project);
                    project.refreshLocal(1, null);
                }
                CliScriptGenerator.generateAndStoreScripts(project);
            }
            AntLaunchConfigGenerator.setAntBuilderEnabled(project, this.isExecutableSelected());
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            return false;
        }
        return true;
    }

    public void performDefaults(IProject project) {
        this.defaultJavaTarget.setSelectedValue(MakefileCreationData.DefaultJavaTarget.getDefault().toString());
        this.temporalJavaTargetFileFieldEditor.setStringValue(MakefileCreationData.getDefaultJavaTargetName(project, false));
        this.generateStartShScript.setSelection(false);
        this.generateStartBatScript.setSelection(false);
        this.updateDefaultJavaTarget();
    }

    private boolean setProperty(IProject project, String name, String value) throws CoreException {
        QualifiedName qualifiedName = new QualifiedName("org.eclipse.titan.designer.Properties.Project", name);
        String oldValue = project.getPersistentProperty(qualifiedName);
        if (value != null && !value.equals(oldValue)) {
            project.setPersistentProperty(qualifiedName, value);
            return true;
        }
        return false;
    }

    private void updateDefaultJavaTarget() {
        this.temporalJavaTargetFileFieldEditor.setEnabled(true, this.javaTargetComposite);
        this.generateStartShScript.setEnabled(false);
        this.generateStartBatScript.setEnabled(false);
        if (this.isClassSelected()) {
            this.temporalJavaTargetFileFieldEditor.setEnabled(false, this.javaTargetComposite);
            return;
        }
        if (this.isExecutableSelected()) {
            this.generateStartShScript.setEnabled(true);
            this.generateStartBatScript.setEnabled(true);
        }
    }

    private boolean isClassSelected() {
        return this.defaultJavaTarget.getActualValue().equals(MakefileCreationData.DefaultJavaTarget.CLASS.toString());
    }

    private boolean isExecutableSelected() {
        return this.defaultJavaTarget.getActualValue().equals(MakefileCreationData.DefaultJavaTarget.EXECUTABLE.toString());
    }
}

