/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.views.testexecution;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.titan.executor.graphics.ImageCache;
import org.eclipse.titan.executor.views.testexecution.ExecutedTestcase;

public final class TestExecutionLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof ExecutedTestcase && 2 == columnIndex) {
            String verdict = ((ExecutedTestcase)element).getVerdict();
            if ("pass".equals(verdict)) {
                return ImageCache.getImage("pass.gif");
            }
            if ("inconc".equals(verdict)) {
                return ImageCache.getImage("inconc.gif");
            }
            if ("fail".equals(verdict)) {
                return ImageCache.getImage("fail.gif");
            }
            if ("error".equals(verdict)) {
                return ImageCache.getImage("error.gif");
            }
            if ("none".equals(verdict)) {
                return ImageCache.getImage("none.gif");
            }
        }
        return super.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ExecutedTestcase) {
            ExecutedTestcase executed = (ExecutedTestcase)element;
            switch (columnIndex) {
                case 0: {
                    return executed.getTimestamp();
                }
                case 1: {
                    return executed.getTestCaseName();
                }
                case 2: {
                    return executed.getVerdict();
                }
                case 3: {
                    return executed.getReason();
                }
            }
        }
        return null;
    }
}

