/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Event_Handler;
import org.eclipse.titan.runtime.core.Index_Redirect;
import org.eclipse.titan.runtime.core.TTCN_Communication;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.TTCN_Runtime;
import org.eclipse.titan.runtime.core.TTCN_Snapshot;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanAlt_Status;
import org.eclipse.titan.runtime.core.TitanCharString;
import org.eclipse.titan.runtime.core.TitanComponent;
import org.eclipse.titan.runtime.core.TitanComponent_template;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.TitanLoggerApi;
import org.eclipse.titan.runtime.core.TitanOctetString;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanPort
extends Event_Handler.Channel_And_Timeout_Event_Handler {
    private static final ThreadLocal<LinkedList<TitanPort>> PORTS = new ThreadLocal<LinkedList<TitanPort>>(){

        @Override
        protected LinkedList<TitanPort> initialValue() {
            return new LinkedList<TitanPort>();
        }
    };
    private static final ThreadLocal<LinkedList<TitanPort>> SYSTEM_PORTS = new ThreadLocal<LinkedList<TitanPort>>(){

        @Override
        protected LinkedList<TitanPort> initialValue() {
            return new LinkedList<TitanPort>();
        }
    };
    public static final ThreadLocal<Map_Params> map_params_cache = new ThreadLocal<Map_Params>(){

        @Override
        protected Map_Params initialValue() {
            return new Map_Params(0);
        }
    };
    protected String port_name;
    protected int msg_head_count;
    protected int msg_tail_count;
    protected int proc_head_count;
    protected int proc_tail_count;
    protected boolean is_active;
    protected boolean is_started;
    protected boolean is_halted;
    private final ArrayList<String> system_mappings = new ArrayList();
    private final LinkedList<port_connection> connection_list = new LinkedList();
    private static final List<Port_Parameter> PORT_PARAMETERS = new LinkedList<Port_Parameter>();
    private ByteBuffer outgoing_buffer;
    private ByteBuffer incoming_ByteBuffer;

    public TitanPort(String portName) {
        this.port_name = portName == null ? "<unknown>" : portName;
        this.is_active = false;
        this.is_started = false;
    }

    protected TitanPort() {
        this.port_name = "<unknown>";
        this.is_active = false;
        this.is_started = false;
        this.is_halted = false;
    }

    public String get_name() {
        return this.port_name;
    }

    private void add_to_list(boolean system) {
        if (system) {
            for (TitanPort port : SYSTEM_PORTS.get()) {
                if (port == this) {
                    return;
                }
                if (!port.port_name.equals(this.port_name)) continue;
                throw new TtcnError(MessageFormat.format("Internal error: There are more than one ports with name {0}.", this.port_name));
            }
            SYSTEM_PORTS.get().add(this);
        } else {
            for (TitanPort port : PORTS.get()) {
                if (port == this) {
                    return;
                }
                if (!port.port_name.equals(this.port_name)) continue;
                throw new TtcnError(MessageFormat.format("Internal error: There are more than one ports with name {0}.", this.port_name));
            }
            PORTS.get().add(this);
        }
    }

    private void remove_from_list(boolean system) {
        if (system) {
            SYSTEM_PORTS.get().remove(this);
        } else {
            PORTS.get().remove(this);
        }
    }

    private static TitanPort lookup_by_name(String parameter_port_name, boolean system) {
        if (system) {
            for (TitanPort port : SYSTEM_PORTS.get()) {
                if (!port.port_name.equals(parameter_port_name)) continue;
                return port;
            }
        } else {
            for (TitanPort port : PORTS.get()) {
                if (!port.port_name.equals(parameter_port_name)) continue;
                return port;
            }
        }
        return null;
    }

    private static void apply_parameter(Port_Parameter parameter) {
        if (parameter.port_name == null) {
            for (TitanPort port : PORTS.get()) {
                port.set_parameter(parameter.parameter_name, parameter.parameter_value);
            }
        } else {
            TitanPort port = TitanPort.lookup_by_name(parameter.port_name, false);
            if (port != null) {
                port.set_parameter(parameter.parameter_name, parameter.parameter_value);
            }
        }
    }

    private void set_system_parameters(String system_port) {
        for (Port_Parameter parameter : PORT_PARAMETERS) {
            if (parameter.component_id.id_selector != TTCN_Logger.component_id_selector_enum.COMPONENT_ID_SYSTEM || parameter.port_name != null && !parameter.port_name.equals(system_port)) continue;
            this.set_parameter(parameter.parameter_name, parameter.parameter_value);
        }
    }

    public static void add_parameter(TTCN_Logger.component_id_t component_id, String port_name, String parameter_name, String parameter_value) {
        Port_Parameter newParameter = new Port_Parameter();
        newParameter.component_id.id_selector = component_id.id_selector;
        switch (component_id.id_selector) {
            case COMPONENT_ID_NAME: {
                newParameter.component_id.id_name = component_id.id_name;
                break;
            }
            case COMPONENT_ID_COMPREF: {
                newParameter.component_id.id_compref = component_id.id_compref;
                break;
            }
        }
        if (port_name != null) {
            newParameter.port_name = port_name;
        }
        newParameter.parameter_name = parameter_name;
        newParameter.parameter_value = parameter_value;
        PORT_PARAMETERS.add(newParameter);
    }

    public static void clear_parameters() {
        PORT_PARAMETERS.clear();
    }

    public static void set_parameters(int component_reference, String component_name) {
        for (Port_Parameter parameter : PORT_PARAMETERS) {
            switch (parameter.component_id.id_selector) {
                case COMPONENT_ID_NAME: {
                    if (component_name == null || !component_name.equals(parameter.component_id.id_name)) break;
                    TitanPort.apply_parameter(parameter);
                    break;
                }
                case COMPONENT_ID_COMPREF: {
                    if (parameter.component_id.id_compref != component_reference) break;
                    TitanPort.apply_parameter(parameter);
                    break;
                }
                case COMPONENT_ID_ALL: {
                    TitanPort.apply_parameter(parameter);
                    break;
                }
            }
        }
    }

    public void activate_port(boolean system) {
        if (!this.is_active) {
            this.add_to_list(system);
            this.is_active = true;
            this.msg_head_count = 0;
            this.msg_tail_count = 0;
            this.proc_head_count = 0;
            if (this.system_mappings.isEmpty()) {
                this.init_port_variables();
            }
        }
    }

    public void deactivate_port(boolean system) {
        if (this.is_active) {
            boolean is_parallel;
            boolean bl = is_parallel = !TTCN_Runtime.is_single();
            while (!this.connection_list.isEmpty()) {
                port_connection connection = this.connection_list.getFirst();
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.removing__unterminated__connection, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                if (is_parallel) {
                    try {
                        TTCN_Communication.send_disconnected(this.port_name, connection.remote_component, connection.remote_port);
                    }
                    catch (TtcnError ttcnError) {
                        // empty catch block
                    }
                }
                this.remove_connection(connection);
            }
            while (!this.system_mappings.isEmpty()) {
                String system_port = this.system_mappings.get(0);
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.removing__unterminated__mapping, this.port_name, 0, system_port, null, -1, 0);
                Map_Params params = new Map_Params(0);
                try {
                    this.unmap(system_port, params, system);
                }
                catch (TtcnError ttcnError) {
                    // empty catch block
                }
                if (!is_parallel) continue;
                try {
                    TTCN_Communication.send_unmapped(this.port_name, system_port, params, system);
                }
                catch (TtcnError ttcnError) {}
            }
            if (this.is_started || this.is_halted) {
                try {
                    this.stop();
                }
                catch (TtcnError system_port) {
                    // empty catch block
                }
            }
            this.clear_queue();
            ArrayList<SelectableChannel> tobeRemoved = new ArrayList<SelectableChannel>();
            for (Map.Entry<SelectableChannel, Event_Handler.Channel_Event_Handler> entry : TTCN_Snapshot.channelMap.get().entrySet()) {
                if (entry.getValue() != this) continue;
                tobeRemoved.add(entry.getKey());
            }
            for (SelectableChannel channel : tobeRemoved) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                TTCN_Snapshot.channelMap.get().remove(channel);
            }
            TTCN_Snapshot.set_timer(this, 0.0, true, true, true);
            this.remove_from_list(system);
            this.is_active = false;
        }
    }

    public static void deactivate_all() {
        LinkedList temp = new LinkedList(PORTS.get());
        for (TitanPort port : temp) {
            port.deactivate_port(false);
        }
        temp.clear();
        temp.addAll(SYSTEM_PORTS.get());
        for (TitanPort port : temp) {
            port.deactivate_port(true);
        }
    }

    public void clear() {
        if (!this.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Inactive port {0} cannot be cleared.", this.port_name));
        }
        if (!this.is_started && !this.is_halted) {
            TtcnError.TtcnWarning(MessageFormat.format("Performing clear operation on port {0}, which is already stopped. The operation has no effect.", this.port_name));
        }
        this.clear_queue();
        TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.port__was__cleared, this.port_name, 0, "", "", -1, 0);
    }

    public static void all_clear() {
        for (TitanPort port : PORTS.get()) {
            port.clear();
        }
        for (TitanPort port : SYSTEM_PORTS.get()) {
            port.clear();
        }
    }

    public void start() {
        if (!this.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Inactive port {0} cannot be started.", this.port_name));
        }
        if (this.is_started) {
            TtcnError.TtcnWarning(MessageFormat.format("Performing start operation on port {0}, which is already started. The operation will clear the incoming queue.", this.port_name));
            this.clear_queue();
        } else {
            if (this.is_halted) {
                this.clear_queue();
                this.is_halted = false;
            }
            this.user_start();
            this.is_started = true;
        }
        TTCN_Logger.log_port_state(TitanLoggerApi.Port__State_operation.enum_type.started, this.port_name);
    }

    public static void all_start() {
        for (TitanPort port : PORTS.get()) {
            port.start();
        }
        for (TitanPort port : SYSTEM_PORTS.get()) {
            port.start();
        }
    }

    public void stop() {
        if (!this.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Inactive port {0} cannot be stopped.", this.port_name));
        }
        if (this.is_started) {
            this.is_started = false;
            this.is_halted = false;
            this.user_stop();
            this.clear_queue();
        } else if (this.is_halted) {
            this.is_halted = false;
            this.clear_queue();
        } else {
            TtcnError.TtcnWarning(MessageFormat.format("Performing stop operation on port {0}, which is already stopped. The operation has no effect.", this.port_name));
        }
        TTCN_Logger.log_port_state(TitanLoggerApi.Port__State_operation.enum_type.stopped, this.port_name);
    }

    public static void all_stop() {
        for (TitanPort port : PORTS.get()) {
            port.stop();
        }
        for (TitanPort port : SYSTEM_PORTS.get()) {
            port.stop();
        }
    }

    public void halt() {
        if (!this.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Inactive port {0} cannot be halted.", this.port_name));
        }
        if (this.is_started) {
            this.is_started = false;
            this.is_halted = true;
            this.user_stop();
        } else if (this.is_halted) {
            TtcnError.TtcnWarning(MessageFormat.format("Performing halt operation on port {0}, which is already halted. The operation has no effect.", this.port_name));
        } else {
            TtcnError.TtcnWarning(MessageFormat.format("Performing halt operation on port {0}, which is already stopped. The operation has no effect.", this.port_name));
        }
        TTCN_Logger.log_port_state(TitanLoggerApi.Port__State_operation.enum_type.halted, this.port_name);
    }

    public static void all_halt() {
        for (TitanPort port : PORTS.get()) {
            port.halt();
        }
        for (TitanPort port : SYSTEM_PORTS.get()) {
            port.halt();
        }
    }

    public void safe_start() {
        if (!this.is_started) {
            this.activate_port(true);
            this.start();
        }
    }

    public void add_port(TitanPort p) {
        throw new TtcnError("Internal error: Calling TitanPort.add_port");
    }

    public void remove_port(TitanPort p) {
        throw new TtcnError("Internal error: Calling TitanPort.remove_port");
    }

    public TitanPort get_provider_port() {
        return null;
    }

    public boolean incoming_message_handler(Base_Type message, String message_type, int sender_component, TitanFloat timestamp) {
        return false;
    }

    public boolean check_port_state(String type) {
        if ("Started".equals(type)) {
            return this.is_started;
        }
        if ("Halted".equals(type)) {
            return this.is_halted;
        }
        if ("Stopped".equals(type)) {
            return !this.is_started && !this.is_halted;
        }
        if ("Connected".equals(type)) {
            return !this.connection_list.isEmpty();
        }
        if ("Mapped".equals(type)) {
            return !this.system_mappings.isEmpty();
        }
        if ("Linked".equals(type)) {
            return !this.connection_list.isEmpty() || !this.system_mappings.isEmpty();
        }
        throw new TtcnError(MessageFormat.format("{0} is not an allowed parameter of checkstate().", type));
    }

    public boolean check_port_state(TitanCharString type) {
        return this.check_port_state(type.get_value().toString());
    }

    public static boolean any_check_port_state(String type) {
        for (TitanPort port : PORTS.get()) {
            if (!port.check_port_state(type)) continue;
            return true;
        }
        for (TitanPort port : SYSTEM_PORTS.get()) {
            if (!port.check_port_state(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean any_check_port_state(TitanCharString type) {
        return TitanPort.any_check_port_state(type.get_value().toString());
    }

    public static boolean all_check_port_state(String type) {
        for (TitanPort port : PORTS.get()) {
            if (port.check_port_state(type)) continue;
            return false;
        }
        for (TitanPort port : SYSTEM_PORTS.get()) {
            if (port.check_port_state(type)) continue;
            return false;
        }
        return true;
    }

    public static boolean all_check_port_state(TitanCharString type) {
        return TitanPort.all_check_port_state(type.get_value().toString());
    }

    public TitanAlt_Status receive(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.no__incoming__types, TitanLoggerApi.MatchingProblemType_operation.enum_type.receive__, false, false, this.port_name);
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_receive(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.receive__, true, false, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.receive(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Receive operation returned unexpected status code on port {0} while evaluating `any port.receive'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status check_receive(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.no__incoming__types, TitanLoggerApi.MatchingProblemType_operation.enum_type.receive__, false, true, this.port_name);
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_check_receive(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.receive__, true, true, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.check_receive(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Check-receive operation returned unexpected status code on port {0} while evaluating `any port.check(receive)'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status trigger(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.no__incoming__types, TitanLoggerApi.MatchingProblemType_operation.enum_type.trigger__, false, false, this.port_name);
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_trigger(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.trigger__, true, false, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.trigger(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Trigger operation returned unexpected status code on port {0} while evaluating `any port.trigger'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status getcall(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_getcall(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.getcall__, true, false, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.getcall(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Getcall operation returned unexpected status code on port {0} while evaluating `any port.getcall'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status check_getcall(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_check_getcall(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.getcall__, true, true, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.check_getcall(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Check-getcall operation returned unexpected status code on port {0} while evaluating `any port.check(getcall)'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status getreply(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_getreply(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.getreply__, true, false, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.getreply(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Getreply operation returned unexpected status code on port {0} while evaluating `any port.getreply'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status check_getreply(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_check_getreply(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.getreply__, true, true, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.check_getreply(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Check-getreply operation returned unexpected status code on port {0} while evaluating `any port.check(getreply)'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status get_exception(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_catch(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.catch__, true, false, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.get_exception(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Catch operation returned unexpected status code on port {0} while evaluating `any port.catch'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status check_catch(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        return TitanAlt_Status.ALT_NO;
    }

    public static TitanAlt_Status any_check_catch(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.catch__, true, true, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.check_catch(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Check-catch operation returned unexpected status code on port {0} while evaluating `any port.check(catch)'.", port.port_name));
        }
        return returnValue;
    }

    public TitanAlt_Status check(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect, Index_Redirect index_redirect) {
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        switch (this.check_getcall(sender_template, sender_pointer, timestemp_redirect, null)) {
            case ALT_YES: {
                return TitanAlt_Status.ALT_YES;
            }
            case ALT_MAYBE: {
                returnValue = TitanAlt_Status.ALT_MAYBE;
                break;
            }
            case ALT_NO: {
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: Check-getcall operation returned unexpected status code on port {0}.", this.port_name));
            }
        }
        if (!TitanAlt_Status.ALT_MAYBE.equals((Object)returnValue)) {
            switch (this.check_getreply(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    break;
                }
                case ALT_NO: {
                    break;
                }
                default: {
                    throw new TtcnError(MessageFormat.format("Internal error: Check-getreply operation returned unexpected status code on port {0}.", this.port_name));
                }
            }
        }
        if (!TitanAlt_Status.ALT_MAYBE.equals((Object)returnValue)) {
            switch (this.check_catch(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    break;
                }
                case ALT_NO: {
                    break;
                }
                default: {
                    throw new TtcnError(MessageFormat.format("Internal error: Check-catch operation returned unexpected status code on port {0}.", this.port_name));
                }
            }
        }
        switch (this.check_receive(sender_template, sender_pointer, timestemp_redirect, null)) {
            case ALT_YES: {
                return TitanAlt_Status.ALT_YES;
            }
            case ALT_MAYBE: {
                returnValue = TitanAlt_Status.ALT_MAYBE;
                break;
            }
            case ALT_NO: {
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: Check-receive operation returned unexpected status code on port {0}.", this.port_name));
            }
        }
        return returnValue;
    }

    public static TitanAlt_Status any_check(TitanComponent_template sender_template, TitanComponent sender_pointer, TitanFloat timestemp_redirect) {
        if (PORTS.get().isEmpty()) {
            TTCN_Logger.log_matching_problem(TitanLoggerApi.MatchingProblemType_reason.enum_type.component__has__no__ports, TitanLoggerApi.MatchingProblemType_operation.enum_type.check__, true, false, null);
            return TitanAlt_Status.ALT_NO;
        }
        TitanAlt_Status returnValue = TitanAlt_Status.ALT_NO;
        block5: for (TitanPort port : PORTS.get()) {
            switch (port.check(sender_template, sender_pointer, timestemp_redirect, null)) {
                case ALT_YES: {
                    return TitanAlt_Status.ALT_YES;
                }
                case ALT_MAYBE: {
                    returnValue = TitanAlt_Status.ALT_MAYBE;
                    continue block5;
                }
                case ALT_NO: {
                    continue block5;
                }
            }
            throw new TtcnError(MessageFormat.format("Internal error: Check operation returned unexpected status code on port {0} while evaluating `any port.check'.", port.port_name));
        }
        return returnValue;
    }

    public void set_parameter(String parameter_name, String parameter_value) {
        TtcnError.TtcnWarning(MessageFormat.format("Test port parameter {0} is not supported on port {1}.", parameter_name, this.port_name));
    }

    protected void Install_Handler(Set<SelectableChannel> read_channels, Set<SelectableChannel> write_channels, double call_interval) throws IOException {
        if (!this.is_active) {
            throw new TtcnError(MessageFormat.format("Event handler cannot be installed for inactive port {0}.", this.port_name));
        }
        if (read_channels != null) {
            for (SelectableChannel channel : read_channels) {
                channel.configureBlocking(false);
                TTCN_Snapshot.channelMap.get().put(channel, this);
                channel.register(TTCN_Snapshot.selector.get(), 1);
            }
        }
        if (write_channels != null) {
            for (SelectableChannel channel : write_channels) {
                channel.configureBlocking(false);
                TTCN_Snapshot.channelMap.get().put(channel, this);
                channel.register(TTCN_Snapshot.selector.get(), 4);
            }
        }
        TTCN_Snapshot.set_timer(this, call_interval, true, true, true);
    }

    protected void Uninstall_Handler() throws IOException {
        ArrayList<SelectableChannel> tobeRemoved = new ArrayList<SelectableChannel>();
        for (Map.Entry<SelectableChannel, Event_Handler.Channel_Event_Handler> entry : TTCN_Snapshot.channelMap.get().entrySet()) {
            if (entry.getValue() != this) continue;
            tobeRemoved.add(entry.getKey());
        }
        for (SelectableChannel channel : tobeRemoved) {
            TTCN_Snapshot.channelMap.get().remove(channel);
        }
        TTCN_Snapshot.set_timer(this, 0.0, true, true, true);
    }

    @Override
    public void Handle_Event(SelectableChannel channel, boolean is_readable, boolean is_writeable) {
        throw new TtcnError(MessageFormat.format("There is no Event_Handler implemented in port {0}. Event_Handler has to be implemented in the port if Install_Handler is used to specify the file descriptor and timeout events for which the port waits.", this.get_name()));
    }

    @Override
    public void Handle_Timeout(double time_since_last_call) {
        throw new TtcnError(MessageFormat.format("There is no Handle_Timeout member function implemented in port {0}. This method has to be implemented in the port if the port waits for timeouts unless the port uses Install_Handler to specify the timeout.", this.get_name()));
    }

    protected void user_map(String system_port) {
        this.user_map(system_port, new Map_Params(0));
    }

    protected void user_map(String system_port, Map_Params params) {
    }

    protected void user_unmap(String system_port) {
        this.user_unmap(system_port, new Map_Params(0));
    }

    protected void user_unmap(String system_port, Map_Params params) {
    }

    protected void user_start() {
    }

    protected void user_stop() {
    }

    protected void clear_queue() {
    }

    protected int get_default_destination() {
        int connection_size = this.connection_list.size();
        int mappings_size = this.system_mappings.size();
        if (connection_size == 0) {
            if (mappings_size == 1) {
                return 2;
            }
            if (mappings_size > 1) {
                throw new TtcnError(MessageFormat.format("Port {0} has more than one mappings. Message cannot be sent on it to system.", this.port_name));
            }
            throw new TtcnError(MessageFormat.format("Port {0} has neither connections nor mappings. Message cannot be sent on it.", this.port_name));
        }
        if (mappings_size != 0) {
            throw new TtcnError(MessageFormat.format("Port {0} has both connection(s) and mapping(s). Message can be sent on it only with explicit addressing.", this.port_name));
        }
        if (connection_size > 1) {
            throw new TtcnError(MessageFormat.format("Port {0} has more than one active connections. Message can be sent on it only with explicit addressing.", this.port_name));
        }
        return this.connection_list.peekFirst().remote_component;
    }

    protected void prepare_message(Text_Buf outgoing_buf, byte[] message_type) {
        outgoing_buf.push_int(port_connection.connection_data_type_enum.CONN_DATA_MESSAGE.ordinal());
        outgoing_buf.push_int(message_type.length);
        outgoing_buf.push_raw(message_type);
    }

    protected void prepare_call(Text_Buf outgoing_buf, byte[] signature_name) {
        outgoing_buf.push_int(port_connection.connection_data_type_enum.CONN_DATA_CALL.ordinal());
        outgoing_buf.push_int(signature_name.length);
        outgoing_buf.push_raw(signature_name);
    }

    protected void prepare_reply(Text_Buf outgoing_buf, byte[] signature_name) {
        outgoing_buf.push_int(port_connection.connection_data_type_enum.CONN_DATA_REPLY.ordinal());
        outgoing_buf.push_int(signature_name.length);
        outgoing_buf.push_raw(signature_name);
    }

    protected void prepare_exception(Text_Buf outgoing_buf, byte[] signature_name) {
        outgoing_buf.push_int(port_connection.connection_data_type_enum.CONN_DATA_EXCEPTION.ordinal());
        outgoing_buf.push_int(signature_name.length);
        outgoing_buf.push_raw(signature_name);
    }

    protected void send_data(Text_Buf outgoing_buf, TitanComponent destination_component) {
        if (!destination_component.is_bound()) {
            throw new TtcnError(MessageFormat.format("Internal error: The destination component reference is unbound when sending data on port {0}.", this.port_name));
        }
        int destination_compref = destination_component.componentValue;
        AtomicBoolean is_unique = new AtomicBoolean();
        port_connection connection = this.lookup_connection_to_compref(destination_compref, is_unique);
        if (connection == null) {
            throw new TtcnError(MessageFormat.format("Data cannot be sent on port {0} to component {1} because there is no connection towards component {1}.", this.port_name, destination_compref));
        }
        if (!is_unique.get()) {
            throw new TtcnError(MessageFormat.format("Data cannot be sent on port {0} to component {1} because there are more than one connections towards component {1}.", this.port_name, destination_compref));
        }
        if (connection.connection_state != port_connection.connection_state_enum.CONN_CONNECTED) {
            throw new TtcnError(MessageFormat.format("Data cannot be sent on port {0} to component {1} because the connection is not in active state.", this.port_name, destination_compref));
        }
        switch (connection.transport_type) {
            case TRANSPORT_LOCAL: {
                this.send_data_local(connection, outgoing_buf);
                break;
            }
            case TRANSPORT_INET_STREAM: {
                this.send_data_stream(connection, outgoing_buf, false);
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: Invalid transport type ({0}) in port connection between {1} and {2}:{3}.", new Object[]{connection.transport_type, this.port_name, connection.remote_component, connection.remote_port}));
            }
        }
    }

    protected void process_data(port_connection connection, Text_Buf incoming_buf) {
        block15: {
            block14: {
                int connection_int = incoming_buf.pull_int().get_int();
                port_connection.connection_data_type_enum conn_data_type = port_connection.connection_data_type_enum.values()[connection_int];
                if (conn_data_type == port_connection.connection_data_type_enum.CONN_DATA_LAST) break block14;
                switch (connection.connection_state) {
                    case CONN_CONNECTED: 
                    case CONN_LAST_MSG_SENT: {
                        break;
                    }
                    case CONN_LAST_MSG_RCVD: 
                    case CONN_IDLE: {
                        TtcnError.TtcnWarning(MessageFormat.format("Data arrived after the indication of connection termination on port {0} from {1}:{2}. Data is ignored.", this.port_name, connection.remote_component, connection.remote_port));
                        return;
                    }
                    default: {
                        throw new TtcnError(MessageFormat.format("Internal error: Connection of port {0} with {1}:{2} has invalid state ({3}).", this.port_name, connection.remote_component, connection.remote_port, connection.connection_state.ordinal()));
                    }
                }
                int len = incoming_buf.pull_int().get_int();
                byte[] message_type = new byte[len];
                incoming_buf.pull_raw(len, message_type);
                switch (conn_data_type) {
                    case CONN_DATA_MESSAGE: {
                        if (!this.process_message(message_type, incoming_buf, connection.remote_component, connection.sliding_buffer)) {
                            throw new TtcnError(MessageFormat.format("Port {0} does not support incoming message type {1}, which has arrived on the connection from {2}:{3}.", this.port_name, message_type, connection.remote_component, connection.remote_port));
                        }
                        break block15;
                    }
                    case CONN_DATA_CALL: {
                        if (!this.process_call(message_type, incoming_buf, connection.remote_component)) {
                            throw new TtcnError(MessageFormat.format("Port {0} does not support incoming call of signature {1}, which has arrived on the connection from {2}:{3}.", this.port_name, message_type, connection.remote_component, connection.remote_port));
                        }
                        break block15;
                    }
                    case CONN_DATA_REPLY: {
                        if (!this.process_reply(message_type, incoming_buf, connection.remote_component)) {
                            throw new TtcnError(MessageFormat.format("Port {0} does not support incoming reply of signature {1}, which has arrived on the connection from {2}:{3}.", this.port_name, message_type, connection.remote_component, connection.remote_port));
                        }
                        break block15;
                    }
                    case CONN_DATA_EXCEPTION: {
                        if (!this.process_exception(message_type, incoming_buf, connection.remote_component)) {
                            throw new TtcnError(MessageFormat.format("Port {0} does not support incoming exception of signature {1}, which has arrived on the connection from {2}:{3}.", this.port_name, message_type, connection.remote_component, connection.remote_port));
                        }
                        break block15;
                    }
                    default: {
                        throw new TtcnError(MessageFormat.format("Internal error: Data with invalid selector ({0}) was received on port {1} from {2}:{3}.", conn_data_type.ordinal(), this.port_name, connection.remote_component, connection.remote_port));
                    }
                }
            }
            this.process_last_message(connection);
        }
    }

    protected boolean process_message(byte[] message_type, Text_Buf incoming_buf, int sender_component, TitanOctetString slider) {
        return false;
    }

    protected boolean process_call(byte[] signature_name, Text_Buf incoming_buf, int sender_component) {
        return false;
    }

    protected boolean process_reply(byte[] signature_name, Text_Buf incoming_buf, int sender_component) {
        return false;
    }

    protected boolean process_exception(byte[] signature_name, Text_Buf incoming_buf, int sender_component) {
        return false;
    }

    protected void reset_port_variables() {
    }

    protected void init_port_variables() {
    }

    public void change_port_state(translation_port_state state) {
    }

    private port_connection add_connection(int remote_component, String remote_port, TTCN_Communication.transport_type_enum transport_type) {
        int index = -1;
        int i = -1;
        for (port_connection connection : this.connection_list) {
            ++i;
            if (connection.remote_component == remote_component) {
                int ret_val = connection.remote_port.compareTo(remote_port);
                if (ret_val == 0) {
                    return connection;
                }
                if (ret_val <= 0) continue;
                index = i;
                break;
            }
            if (connection.remote_component <= remote_component) continue;
            index = i;
            break;
        }
        if (!this.system_mappings.isEmpty()) {
            throw new TtcnError(MessageFormat.format("Connect operation cannot be performed on a mapped port ({0}).", this.port_name));
        }
        port_connection new_connection = new port_connection();
        new_connection.owner_port = this;
        new_connection.connection_state = port_connection.connection_state_enum.CONN_IDLE;
        new_connection.remote_component = remote_component;
        new_connection.remote_port = remote_port;
        new_connection.transport_type = transport_type;
        new_connection.local_port = null;
        new_connection.sliding_buffer = new TitanOctetString("");
        new_connection.stream_socket = null;
        new_connection.stream_incoming_buf = null;
        if (index == -1) {
            this.connection_list.addLast(new_connection);
        } else {
            this.connection_list.add(index, new_connection);
        }
        return new_connection;
    }

    private void remove_connection(port_connection connection) {
        switch (connection.transport_type) {
            case TRANSPORT_LOCAL: {
                break;
            }
            case TRANSPORT_INET_STREAM: {
                TTCN_Snapshot.channelMap.get().remove(connection.stream_socket);
                try {
                    connection.stream_socket.close();
                }
                catch (IOException e) {
                    throw new TtcnError(e);
                }
                connection.stream_socket = null;
                break;
            }
            default: {
                throw new TtcnError("Internal error: TitanPort.remove_connection(): invalid transport type.");
            }
        }
        this.connection_list.remove(connection);
    }

    private port_connection lookup_connection_to_compref(int remote_component, AtomicBoolean is_unique) {
        port_connection result = null;
        for (port_connection connection : this.connection_list) {
            if (connection.remote_component == remote_component) {
                if (is_unique != null) {
                    if (result == null) {
                        is_unique.set(true);
                    } else {
                        is_unique.set(false);
                        return result;
                    }
                }
                result = connection;
                continue;
            }
            if (connection.remote_component <= remote_component) continue;
            break;
        }
        return result;
    }

    private port_connection lookup_connection(int remote_component, String remote_port) {
        for (port_connection connection : this.connection_list) {
            if (connection.remote_component == remote_component) {
                int ret_val = connection.remote_port.compareTo(remote_port);
                if (ret_val == 0) {
                    return connection;
                }
                if (ret_val <= 0) continue;
                break;
            }
            if (connection.remote_component <= remote_component) continue;
            break;
        }
        return null;
    }

    private void add_local_connection(TitanPort other_endpoint) {
        port_connection connection = this.add_connection(TitanComponent.self.get().componentValue, other_endpoint.port_name, TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL);
        connection.connection_state = port_connection.connection_state_enum.CONN_CONNECTED;
        connection.local_port = other_endpoint;
        TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.local__connection__established, this.port_name, 0, other_endpoint.port_name, null, -1, 0);
    }

    private void remove_local_connection(port_connection connection) {
        if (connection.transport_type != TTCN_Communication.transport_type_enum.TRANSPORT_LOCAL) {
            throw new TtcnError(MessageFormat.format("Internal error: The transport type used by the connection between port {0} and {1}:{2} is not LOCAL.", this.port_name, connection.remote_component, connection.remote_port));
        }
        TitanPort other_endpoint = connection.local_port;
        this.remove_connection(connection);
        TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.local__connection__terminated, this.port_name, 0, other_endpoint.port_name, null, -1, 0);
    }

    private void connect_listen_inet_stream(int remote_component, String remote_port) {
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            ServerSocket serverSocket = serverSocketChannel.socket();
            InetSocketAddress local_addr = new InetSocketAddress(serverSocket.getInetAddress(), 0);
            serverSocket.bind(local_addr);
            int local_port = serverSocketChannel.socket().getLocalPort();
            port_connection new_connection = this.add_connection(remote_component, remote_port, TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM);
            new_connection.connection_state = port_connection.connection_state_enum.CONN_LISTENING;
            new_connection.stream_socket = serverSocketChannel;
            serverSocketChannel.configureBlocking(false);
            TTCN_Snapshot.channelMap.get().put(serverSocketChannel, new_connection);
            serverSocketChannel.register(TTCN_Snapshot.selector.get(), 16);
            TTCN_Communication.send_connect_listen_ack_inet_stream(this.port_name, local_port, remote_component, remote_port, Inet4Address.getLocalHost());
            TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.port__is__waiting__for__connection__tcp, this.port_name, remote_component, remote_port, "TCP", -1, 0);
        }
        catch (IOException e) {
            throw new TtcnError(e);
        }
    }

    private void connect_local(int remote_component, String remote_port) {
        if (TitanComponent.self.get().componentValue != remote_component) {
            TTCN_Communication.send_connect_error(this.port_name, remote_component, remote_port, MessageFormat.format("Message CONNECT with transport type LOCAL refers to a port of another component ({0}).", remote_component));
            return;
        }
        TitanPort remotePort = TitanPort.lookup_by_name(remote_port, false);
        if (remotePort == null) {
            TTCN_Communication.send_connect_error(this.port_name, remote_component, remote_port, MessageFormat.format("Port {0} does not exist.", remote_port));
            return;
        }
        if (!remotePort.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to connect it to local port {1}.", remote_port, this.port_name));
        }
        this.add_local_connection(remotePort);
        if (this != remotePort) {
            remotePort.add_local_connection(this);
        }
        TTCN_Communication.send_connected(this.port_name, remote_component, remote_port);
    }

    private void connect_stream(int remote_component, String remote_port, TTCN_Communication.transport_type_enum transport_type, Text_Buf text_buf) {
        byte[] addr;
        byte[] port;
        if (transport_type != TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM) {
            throw new TtcnError(MessageFormat.format("Internal error: TitanPort.connect_stream(): invalid transport type ({0}).", new Object[]{transport_type}));
        }
        byte[] family = new byte[2];
        text_buf.pull_raw(2, family);
        if (Arrays.equals(family, new byte[]{2, 0})) {
            port = new byte[2];
            text_buf.pull_raw(2, port);
            addr = new byte[4];
            text_buf.pull_raw(4, addr);
            byte[] zero = new byte[8];
            text_buf.pull_raw(8, zero);
        } else if (Arrays.equals(family, new byte[]{2, 3})) {
            port = new byte[2];
            text_buf.pull_raw(2, port);
            addr = new byte[16];
            text_buf.pull_raw(16, addr);
            int scopeid = text_buf.pull_int().get_int();
        } else {
            return;
        }
        try {
            InetAddress temp_addr = Inet4Address.getByAddress(addr);
            int temp_port = (port[0] & 0xFF) * 256;
            InetSocketAddress remote_address = new InetSocketAddress(temp_addr, temp_port += port[1] & 0xFF);
            SocketChannel socketChannel = SocketChannel.open();
            socketChannel.connect(remote_address);
            if (!TTCN_Communication.set_non_blocking_mode(socketChannel, true)) {
                socketChannel.close();
                TTCN_Communication.send_connect_error(this.port_name, remote_component, remote_port, "Setting the non-blocking mode failed on the %s client socket.");
                return;
            }
            if (transport_type == TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM && !TTCN_Communication.set_tcp_nodelay(socketChannel, Boolean.TRUE)) {
                socketChannel.close();
                TTCN_Communication.send_connect_error(this.port_name, remote_component, remote_port, "Setting the TCP_NODELAY flag failed on the TCP client socket.");
                return;
            }
            port_connection new_connection = this.add_connection(remote_component, remote_port, transport_type);
            new_connection.connection_state = port_connection.connection_state_enum.CONN_CONNECTED;
            new_connection.stream_socket = socketChannel;
            TTCN_Snapshot.channelMap.get().put(socketChannel, new_connection);
            socketChannel.register(TTCN_Snapshot.selector.get(), 1);
        }
        catch (IOException e) {
            throw new TtcnError(e);
        }
        TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.connection__established, this.port_name, remote_component, remote_port, "TCP", -1, 0);
    }

    private void disconnect_local(port_connection connection) {
        TitanPort remotePort = connection.local_port;
        this.remove_local_connection(connection);
        if (this != remotePort) {
            port_connection connection2 = remotePort.lookup_connection(TitanComponent.self.get().componentValue, this.port_name);
            if (connection2 == null) {
                throw new TtcnError(MessageFormat.format("Internal error: Port {0} is connected with local port {1}, but port {1} does not have a connection to {0}.", this.port_name, remotePort.port_name));
            }
            remotePort.remove_local_connection(connection2);
        }
        TTCN_Communication.send_disconnected(this.port_name, TitanComponent.self.get().componentValue, remotePort.port_name);
    }

    private void disconnect_stream(port_connection connection) {
        switch (connection.connection_state) {
            case CONN_LISTENING: {
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.destroying__unestablished__connection, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                this.remove_connection(connection);
                break;
            }
            case CONN_CONNECTED: {
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.terminating__connection, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                Text_Buf outgoing_buf = new Text_Buf();
                outgoing_buf.push_int(port_connection.connection_data_type_enum.CONN_DATA_LAST.ordinal());
                if (this.send_data_stream(connection, outgoing_buf, true)) {
                    connection.connection_state = port_connection.connection_state_enum.CONN_LAST_MSG_SENT;
                    break;
                }
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.sending__termination__request__failed, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                TTCN_Communication.send_disconnected(this.port_name, connection.remote_component, connection.remote_port);
                TtcnError.TtcnWarning(MessageFormat.format("The last outgoing messages on port {0} may be lost.", this.port_name));
                this.remove_connection(connection);
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("The connection of port {0} to {1}:{2} is in unexpected state when trying to terminate it.", this.port_name, connection.remote_component, connection.remote_port));
            }
        }
    }

    private void send_data_local(port_connection connection, Text_Buf outgoing_data) {
        outgoing_data.rewind();
        TitanPort destination_port = connection.local_port;
        if (this != destination_port) {
            port_connection connection2 = destination_port.lookup_connection(TitanComponent.self.get().componentValue, this.port_name);
            if (connection2 == null) {
                throw new TtcnError(MessageFormat.format("Internal error: Port {0} is connected with local port {1}, but port {1} does not have a connection to {0}.", this.port_name, destination_port.port_name));
            }
            destination_port.process_data(connection2, outgoing_data);
        } else {
            this.process_data(connection, outgoing_data);
        }
    }

    private boolean send_data_stream(port_connection connection, Text_Buf outgoing_data, boolean ignore_peer_disconnect) {
        boolean would_block_warning = false;
        outgoing_data.calculate_length();
        byte[] msg_ptr = outgoing_data.get_data();
        int msg_len = outgoing_data.get_len();
        if (this.outgoing_buffer == null || this.outgoing_buffer.capacity() < msg_len) {
            this.outgoing_buffer = ByteBuffer.allocateDirect(msg_len);
        }
        this.outgoing_buffer.clear();
        this.outgoing_buffer.put(msg_ptr, outgoing_data.get_begin(), msg_len);
        this.outgoing_buffer.limit(msg_len);
        this.outgoing_buffer.rewind();
        while (this.outgoing_buffer.hasRemaining()) {
            try {
                ((SocketChannel)connection.stream_socket).write(this.outgoing_buffer);
            }
            catch (IOException e) {
                throw new TtcnError(e);
            }
        }
        this.outgoing_buffer.clear();
        if (would_block_warning) {
            TtcnError.TtcnWarningBegin(MessageFormat.format("The message finally was sent on port {0} to ", this.port_name));
            TitanComponent.log_component_reference(connection.remote_component);
            TTCN_Logger.log_event(":%s.", connection.remote_port);
            TtcnError.TtcnWarningEnd();
        }
        return true;
    }

    private void handle_incoming_connection(port_connection connection) {
        SocketChannel com_channel;
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)connection.stream_socket;
        try {
            com_channel = serverSocketChannel.accept();
        }
        catch (IOException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            TTCN_Communication.send_connect_error(this.port_name, connection.remote_component, connection.remote_port, "Accepting of incoming TCP connection failed." + sw.toString());
            this.remove_connection(connection);
            return;
        }
        try {
            TTCN_Snapshot.channelMap.get().remove(serverSocketChannel);
            connection.connection_state = port_connection.connection_state_enum.CONN_CONNECTED;
            connection.stream_socket = com_channel;
            if (!TTCN_Communication.set_non_blocking_mode(com_channel, true)) {
                com_channel.close();
                TTCN_Communication.send_connect_error(this.port_name, connection.remote_component, connection.remote_port, "Setting the non-blocking mode failed on the server-side TCP socket.");
                this.remove_connection(connection);
                return;
            }
            if (connection.transport_type == TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM && !TTCN_Communication.set_tcp_nodelay(com_channel, Boolean.TRUE)) {
                com_channel.close();
                TTCN_Communication.send_connect_error(this.port_name, connection.remote_component, connection.remote_port, "Setting the TCP_NODELAY flag failed on the server-side TCP socket.");
                this.remove_connection(connection);
                return;
            }
            TTCN_Snapshot.channelMap.get().put(com_channel, connection);
            com_channel.register(TTCN_Snapshot.selector.get(), 1);
            serverSocketChannel.close();
            TTCN_Communication.send_connected(this.port_name, connection.remote_component, connection.remote_port);
            TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.connection__accepted, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
        }
        catch (IOException e) {
            throw new TtcnError(e);
        }
    }

    private void handle_incoming_data(port_connection connection) {
        if (connection.stream_incoming_buf == null) {
            connection.stream_incoming_buf = new Text_Buf();
        }
        Text_Buf incoming_buffer = connection.stream_incoming_buf;
        if (this.incoming_ByteBuffer == null) {
            this.incoming_ByteBuffer = ByteBuffer.allocateDirect(1024);
        }
        this.incoming_ByteBuffer.clear();
        try {
            int recv_len = ((SocketChannel)connection.stream_socket).read(this.incoming_ByteBuffer);
            if (recv_len < 0) {
                TTCN_Communication.send_disconnected(this.port_name, connection.remote_component, connection.remote_port);
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.connection__reset__by__peer, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                TtcnError.TtcnWarning(MessageFormat.format("The last outgoing messages on port {0} may be lost.", this.port_name));
                connection.connection_state = port_connection.connection_state_enum.CONN_IDLE;
            } else if (recv_len > 0) {
                AtomicInteger end_index = new AtomicInteger();
                AtomicInteger end_len = new AtomicInteger();
                incoming_buffer.get_end(end_index, end_len);
                incoming_buffer.increase_length(recv_len);
                this.incoming_ByteBuffer.flip();
                this.incoming_ByteBuffer.get(incoming_buffer.get_data(), end_index.get(), recv_len);
                while (incoming_buffer.is_message()) {
                    incoming_buffer.pull_int();
                    this.process_data(connection, incoming_buffer);
                    incoming_buffer.cut_message();
                }
            } else {
                TTCN_Communication.send_disconnected(this.port_name, connection.remote_component, connection.remote_port);
                if (connection.connection_state == port_connection.connection_state_enum.CONN_LAST_MSG_RCVD) {
                    TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.connection__closed__by__peer, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                }
                connection.connection_state = port_connection.connection_state_enum.CONN_IDLE;
            }
        }
        catch (IOException e) {
            if ("Connection reset by peer".equals(e.getMessage())) {
                TTCN_Communication.send_disconnected(this.port_name, connection.remote_component, connection.remote_port);
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.connection__reset__by__peer, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                TtcnError.TtcnWarning(MessageFormat.format("The last outgoing messages on port {0} may be lost.", this.port_name));
                connection.connection_state = port_connection.connection_state_enum.CONN_IDLE;
            }
            throw new TtcnError(e);
        }
        if (connection.connection_state == port_connection.connection_state_enum.CONN_IDLE) {
            int msg_len = incoming_buffer.get_len();
            if (msg_len > 0) {
                TtcnError.TtcnWarningBegin(MessageFormat.format("Message fragment remained in the buffer of port connection between {0} and ", this.port_name));
                TitanComponent.log_component_reference(connection.remote_component);
                TTCN_Logger.log_event_str(MessageFormat.format(":{0}: ", connection.remote_port));
                byte[] msg = incoming_buffer.get_data();
                for (int i = 0; i < msg_len; ++i) {
                    TTCN_Logger.log_octet(msg[i]);
                }
                TtcnError.TtcnWarningEnd();
            }
            TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.port__disconnected, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
            this.remove_connection(connection);
        }
    }

    private void process_last_message(port_connection connection) {
        switch (connection.transport_type) {
            case TRANSPORT_INET_STREAM: {
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: Connection termination request was received on the connection of port {0} with {1}:{2}, which has an invalid transport type ({3}).", new Object[]{this.port_name, connection.remote_component, connection.remote_port, connection.transport_type}));
            }
        }
        switch (connection.connection_state) {
            case CONN_CONNECTED: {
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.termination__request__received, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                Text_Buf outgoing_buf = new Text_Buf();
                outgoing_buf.push_int(port_connection.connection_data_type_enum.CONN_DATA_LAST.ordinal());
                if (this.send_data_stream(connection, outgoing_buf, true)) {
                    connection.connection_state = port_connection.connection_state_enum.CONN_LAST_MSG_RCVD;
                    break;
                }
                TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.acknowledging__termination__request__failed, this.port_name, connection.remote_component, connection.remote_port, null, -1, 0);
                TTCN_Communication.send_disconnected(this.port_name, connection.remote_component, connection.remote_port);
                TtcnError.TtcnWarning(MessageFormat.format("The last outgoing messages on port {0} may be lost.", this.port_name));
                connection.connection_state = port_connection.connection_state_enum.CONN_IDLE;
                break;
            }
            case CONN_LAST_MSG_SENT: {
                connection.connection_state = port_connection.connection_state_enum.CONN_IDLE;
                break;
            }
            case CONN_LAST_MSG_RCVD: 
            case CONN_IDLE: {
                TtcnError.TtcnWarning(MessageFormat.format("Unexpected data arrived after the indication of connection termination on port {0} from {1}:{2}.", this.port_name, connection.remote_component, connection.remote_port));
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: Connection of port {0} with {1}:{2} has invalid state ({3}).", this.port_name, connection.remote_component, connection.remote_port, connection.connection_state.ordinal()));
            }
        }
    }

    private final void map(String system_port, Map_Params params, boolean translation) {
        if (!this.is_active) {
            throw new TtcnError(MessageFormat.format("Inactive port {0} cannot be mapped.", this.port_name));
        }
        for (int i = 0; i < this.system_mappings.size(); ++i) {
            if (!system_port.equals(this.system_mappings.get(i))) continue;
            TtcnError.TtcnWarning(MessageFormat.format("Port {0} is already mapped to system:{1}.\n Map operation was ignored.", this.port_name, system_port));
            return;
        }
        if (translation) {
            this.set_system_parameters(this.port_name);
        } else {
            this.set_system_parameters(system_port);
        }
        if (params.get_nof_params() == 0) {
            this.user_map(system_port);
        } else {
            this.user_map(system_port, params);
        }
        if (translation) {
            TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.port__was__mapped__to__system, system_port, 2, this.port_name, null, -1, 0);
        } else {
            TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.port__was__mapped__to__system, this.port_name, 2, system_port, null, -1, 0);
        }
        this.system_mappings.add(system_port);
        if (this.system_mappings.size() > 1) {
            TtcnError.TtcnWarning(MessageFormat.format("Port {0} has now more than one mappings. Message cannot be sent on it to system even with explicit addressing.", this.port_name));
        }
    }

    private final void unmap(String system_port, Map_Params params, boolean translation) {
        int deletion_position;
        for (deletion_position = 0; deletion_position < this.system_mappings.size() && !system_port.equals(this.system_mappings.get(deletion_position)); ++deletion_position) {
        }
        if (deletion_position >= this.system_mappings.size()) {
            TtcnError.TtcnWarning(MessageFormat.format("Port {0} is not mapped to system:{1}. Unmap operation was ignored.", this.port_name, system_port));
            return;
        }
        this.system_mappings.remove(deletion_position);
        if (params.get_nof_params() == 0) {
            this.user_unmap(system_port);
        } else {
            this.user_unmap(system_port, params);
        }
        if (this.system_mappings.isEmpty()) {
            this.reset_port_variables();
        }
        TTCN_Logger.log_port_misc(TitanLoggerApi.Port__Misc_reason.enum_type.port__was__unmapped__from__system, this.port_name, 2, system_port, null, -1, 0);
    }

    public static void process_connect_listen(String local_port, int remote_component, String remote_port, TTCN_Communication.transport_type_enum transport_type) {
        TitanPort port = TitanPort.lookup_by_name(local_port, false);
        if (port == null) {
            TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, MessageFormat.format("Port {0} does not exist.", local_port));
            return;
        }
        if (!port.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to connect it to {1}:{2}.", local_port, remote_component, remote_port));
        }
        if (port.lookup_connection(remote_component, remote_port) != null) {
            TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, MessageFormat.format("Port {0} already has a connection towards {1}:{2}.", local_port, remote_component, remote_port));
            return;
        }
        if (port.lookup_connection_to_compref(remote_component, null) != null) {
            TtcnError.TtcnWarningBegin(MessageFormat.format("Port {0} will have more than one connections with ports of test component ", local_port));
            TitanComponent.log_component_reference(remote_component);
            TTCN_Logger.log_event_str(". These connections cannot be used for sending even with explicit addressing.");
            TtcnError.TtcnWarningEnd();
        }
        switch (transport_type) {
            case TRANSPORT_LOCAL: {
                TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, "Message CONNECT_LISTEN cannot refer to transport type LOCAL.");
                break;
            }
            case TRANSPORT_INET_STREAM: {
                port.connect_listen_inet_stream(remote_component, remote_port);
                break;
            }
            default: {
                TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, MessageFormat.format("Message CONNECT_LISTEN refers to invalid transport type ({0})", transport_type.ordinal()));
            }
        }
    }

    public static void process_connect(String local_port, int remote_component, String remote_port, TTCN_Communication.transport_type_enum transport_type, Text_Buf text_buf) {
        TitanPort port = TitanPort.lookup_by_name(local_port, false);
        if (port == null) {
            TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, MessageFormat.format("Port {0} does not exist.", local_port));
            return;
        }
        if (!port.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to connect it to {1}:{2}.", local_port, remote_component, remote_port));
        }
        if (port.lookup_connection(remote_component, remote_port) != null) {
            TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, MessageFormat.format("Port {0} already has a connection towards {1}:{2}.", local_port, remote_component, remote_port));
            return;
        }
        if (port.lookup_connection_to_compref(remote_component, null) != null) {
            TtcnError.TtcnWarningBegin(MessageFormat.format("Port {0} will have more than one connections with ports of test component ", local_port));
            TitanComponent.log_component_reference(remote_component);
            TTCN_Logger.log_event_str(". These connections cannot be used for sending even with explicit addressing.");
            TtcnError.TtcnWarningEnd();
        }
        switch (transport_type) {
            case TRANSPORT_LOCAL: {
                port.connect_local(remote_component, remote_port);
                break;
            }
            case TRANSPORT_INET_STREAM: {
                port.connect_stream(remote_component, remote_port, transport_type, text_buf);
                break;
            }
            default: {
                TTCN_Communication.send_connect_error(local_port, remote_component, remote_port, MessageFormat.format("Message CONNECT refers to invalid transport type ({0})", transport_type.ordinal()));
            }
        }
    }

    public static void process_disconnect(String local_port, int remote_component, String remote_port) {
        TitanPort port = TitanPort.lookup_by_name(local_port, false);
        if (port == null) {
            TTCN_Communication.send_error(MessageFormat.format("Message DISCONNECT refers to non-existent local port {0}.", local_port));
            return;
        }
        if (!port.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to disconnect it from {1}:{2}.", local_port, remote_component, remote_port));
        }
        port_connection connection = port.lookup_connection(remote_component, remote_port);
        if (connection == null) {
            if (TitanComponent.self.get().componentValue == remote_component && TitanPort.lookup_by_name(remote_port, false) == null) {
                TTCN_Communication.send_error(MessageFormat.format("Message DISCONNECT refers to non-existent port {0}.", remote_port));
            } else {
                TTCN_Communication.send_disconnected(local_port, remote_component, remote_port);
            }
            return;
        }
        switch (connection.transport_type) {
            case TRANSPORT_LOCAL: {
                port.disconnect_local(connection);
                break;
            }
            case TRANSPORT_INET_STREAM: {
                port.disconnect_stream(connection);
                break;
            }
            default: {
                throw new TtcnError(MessageFormat.format("Internal error: The connection of port {0} to {1}:{2} has invalid transport type ({3}) when trying to terminate the connection.", local_port, remote_component, remote_port, connection.transport_type.ordinal()));
            }
        }
    }

    public static void make_local_connection(String source_port, String destination_port) {
        TitanPort destinationPort;
        TitanPort sourcePort = TitanPort.lookup_by_name(source_port, false);
        if (sourcePort == null) {
            throw new TtcnError(MessageFormat.format("Connect operation refers to non-existent port {0}.", source_port));
        }
        if (!sourcePort.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to connect it with local port {1}.", source_port, destination_port));
        }
        if (sourcePort.lookup_connection(1, destination_port) != null) {
            TtcnError.TtcnWarning(MessageFormat.format("Port {0} is already connected with local port {1}. Connect operation had no effect.", source_port, destination_port));
            return;
        }
        if (sourcePort.lookup_connection_to_compref(1, null) != null) {
            TtcnError.TtcnWarning(MessageFormat.format("Port {0} will have more than one connections with local ports. These connections cannot be used for communication even with explicit addressing.", source_port));
        }
        if ((destinationPort = TitanPort.lookup_by_name(destination_port, false)) == null) {
            throw new TtcnError(MessageFormat.format("Connect operation refers to non-existent port {0}.", destination_port));
        }
        if (!destinationPort.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to connect it with local port {1}.", destination_port, source_port));
        }
        sourcePort.add_local_connection(destinationPort);
        if (sourcePort != destinationPort) {
            destinationPort.add_local_connection(sourcePort);
        }
    }

    public static void terminate_local_connection(String source_port, String destination_port) {
        TitanPort sourcePort = TitanPort.lookup_by_name(source_port, false);
        if (sourcePort == null) {
            throw new TtcnError(MessageFormat.format("Disconnect operation refers to non-existent port {0}.", source_port));
        }
        if (!sourcePort.is_active) {
            throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to disconnect it with local port {1}.", source_port, destination_port));
        }
        port_connection connection = sourcePort.lookup_connection(1, destination_port);
        if (connection == null) {
            TitanPort destinationPort = TitanPort.lookup_by_name(destination_port, false);
            if (destinationPort == null) {
                throw new TtcnError(MessageFormat.format("Disconnect operation refers to non-existent port {0}.", destination_port));
            }
            if (sourcePort != destinationPort) {
                if (!destinationPort.is_active) {
                    throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to disconnect it with local port {1}.", destination_port, source_port));
                }
                if (destinationPort.lookup_connection(1, source_port) != null) {
                    throw new TtcnError(MessageFormat.format("Internal error: Port {0} is connected with local port {1}, but port {1} does not have a connection to {0}.", destination_port, source_port));
                }
            }
            TtcnError.TtcnWarning(MessageFormat.format("Port {0} does not have connection with local port {1}. Disconnect operation had no effect.", source_port, destination_port));
        } else {
            TitanPort destinationPort = TitanPort.lookup_by_name(destination_port, false);
            sourcePort.remove_local_connection(connection);
            if (sourcePort != destinationPort) {
                if (!destinationPort.is_active) {
                    throw new TtcnError(MessageFormat.format("Internal error: Port {0} is inactive when trying to disconnect it with local port {1}.", destination_port, source_port));
                }
                port_connection connection2 = destinationPort.lookup_connection(1, source_port);
                if (connection2 == null) {
                    throw new TtcnError(MessageFormat.format("Internal error: Port {0} is connected with local port {1}, but port {1} does not have a connection to {0}.", source_port, destination_port));
                }
                destinationPort.remove_local_connection(connection2);
            }
        }
    }

    public static void map_port(String component_port, String system_port, Map_Params params, boolean translation) {
        String port_name;
        TitanPort port;
        if (translation) {
            TTCN_Runtime.initialize_system_port(system_port);
        }
        if ((port = TitanPort.lookup_by_name(port_name = translation ? system_port : component_port, translation)) == null) {
            throw new TtcnError(MessageFormat.format("Map operation refers to non-existent port {0}.", component_port));
        }
        if (!port.connection_list.isEmpty()) {
            throw new TtcnError(MessageFormat.format("Map operation is not allowed on a connected port ({0}).", port_name));
        }
        if (translation) {
            port.map(component_port, params, translation);
        } else {
            port.map(system_port, params, translation);
        }
        if (translation) {
            TitanPort otherPort = TitanPort.lookup_by_name(component_port, false);
            if (otherPort == null) {
                throw new TtcnError(MessageFormat.format("Map operation refers to non-existent port {0}.", port_name));
            }
            otherPort.add_port(port);
            port.add_port(otherPort);
        }
    }

    public static void unmap_port(String component_port, String system_port, Map_Params params, boolean translation) {
        String port_name;
        TitanPort port;
        if (translation) {
            TTCN_Runtime.initialize_system_port(system_port);
        }
        if ((port = TitanPort.lookup_by_name(port_name = translation ? system_port : component_port, translation)) == null) {
            throw new TtcnError(MessageFormat.format("Unmap operation refers to non-existent port {0}.", component_port));
        }
        if (translation) {
            port.unmap(component_port, params, translation);
        } else {
            port.unmap(system_port, params, translation);
        }
        if (translation) {
            TitanPort otherPort = TitanPort.lookup_by_name(component_port, false);
            if (otherPort == null) {
                throw new TtcnError(MessageFormat.format("Unmap operation refers to non-existent port {0}.", port_name));
            }
            otherPort.remove_port(port);
            port.remove_port(otherPort);
        }
    }

    public void set_name(String name) {
        if (name == null) {
            throw new TtcnError("Internal error: Setting an invalid name for a single element of a port array.");
        }
        this.port_name = name;
    }

    @Override
    public void log() {
        TTCN_Logger.log_event("port %s", this.port_name);
    }

    private static class Port_Parameter {
        public TTCN_Logger.component_id_t component_id = new TTCN_Logger.component_id_t();
        public String port_name;
        public String parameter_name;
        public String parameter_value;

        private Port_Parameter() {
        }
    }

    public static final class Map_Params {
        private int nof_params;
        private ArrayList<TitanCharString> params;

        public Map_Params(int nof_params) {
            this.init(nof_params);
        }

        public Map_Params(Map_Params other) {
            this.copy(other);
        }

        private void init(int nof_params) {
            this.nof_params = nof_params;
            this.params = new ArrayList(nof_params);
            TitanCharString tmp = new TitanCharString("");
            for (int i = 0; i < nof_params; ++i) {
                this.params.add(i, tmp);
            }
        }

        private void clear() {
            this.nof_params = 0;
            this.params = new ArrayList(this.nof_params);
        }

        private void copy(Map_Params other) {
            this.init(other.nof_params);
            for (int i = 0; i < this.nof_params; ++i) {
                this.params.set(i, other.params.get(i));
            }
        }

        public Map_Params operator_assign(Map_Params other) {
            this.clear();
            this.copy(other);
            return this;
        }

        public void reset(int nof_params) {
            this.init(nof_params);
        }

        public void set_param(int index, TitanCharString param) {
            if (index >= this.nof_params) {
                throw new TtcnError("Map/unmap parameter index out of bounds");
            }
            this.params.set(index, param);
        }

        public int get_nof_params() {
            return this.nof_params;
        }

        public TitanCharString get_param(int index) {
            if (index >= this.nof_params) {
                throw new TtcnError("Map/unmap parameter index out of bounds");
            }
            return this.params.get(index);
        }
    }

    protected static final class port_connection
    extends Event_Handler.Channel_Event_Handler {
        private TitanPort owner_port;
        connection_state_enum connection_state;
        int remote_component;
        String remote_port;
        TTCN_Communication.transport_type_enum transport_type;
        TitanPort local_port;
        SelectableChannel stream_socket;
        Text_Buf stream_incoming_buf;
        TitanOctetString sliding_buffer;

        protected port_connection() {
        }

        @Override
        public void Handle_Event(SelectableChannel channel, boolean is_readable, boolean is_writeable) {
            if (this.transport_type == TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM) {
                if (is_readable) {
                    if (this.connection_state == connection_state_enum.CONN_LISTENING) {
                        this.owner_port.handle_incoming_connection(this);
                    } else {
                        this.owner_port.handle_incoming_data(this);
                    }
                }
            } else {
                throw new TtcnError(MessageFormat.format("Internal error: Invalid transport type ({0}) in port connection between {1} and {2}:{3}.", new Object[]{this.transport_type, this.owner_port.get_name(), this.remote_component, this.remote_port}));
            }
        }

        @Override
        public void log() {
            TTCN_Logger.log_event("port connection between ", new Object[0]);
            this.owner_port.log();
            TTCN_Logger.log_event(" and ", new Object[0]);
            TTCN_Logger.log_event("%d", this.remote_component);
            TTCN_Logger.log_event(":", new Object[0]);
            TTCN_Logger.log_event("%s", this.remote_port);
        }

        public void clean_up() {
            if (this.transport_type == TTCN_Communication.transport_type_enum.TRANSPORT_INET_STREAM) {
                this.sliding_buffer.clean_up();
            }
        }

        static enum connection_state_enum {
            CONN_IDLE,
            CONN_LISTENING,
            CONN_CONNECTED,
            CONN_LAST_MSG_SENT,
            CONN_LAST_MSG_RCVD;

        }

        static enum connection_data_type_enum {
            CONN_DATA_LAST,
            CONN_DATA_MESSAGE,
            CONN_DATA_CALL,
            CONN_DATA_REPLY,
            CONN_DATA_EXCEPTION;

        }
    }

    public static enum translation_port_state {
        UNSET(-1),
        TRANSLATED(0),
        NOT_TRANSLATED(1),
        FRAGMENTED(2),
        PARTIALLY_TRANSLATED(3),
        DISCARDED(4);

        private int code;

        private translation_port_state(int code) {
            this.code = code;
        }

        public static translation_port_state getByCode(int code) {
            switch (code) {
                case 0: {
                    return TRANSLATED;
                }
                case 1: {
                    return NOT_TRANSLATED;
                }
                case 2: {
                    return FRAGMENTED;
                }
                case 3: {
                    return PARTIALLY_TRANSLATED;
                }
                case 4: {
                    return DISCARDED;
                }
            }
            return UNSET;
        }
    }
}

