/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titanium.refactoring.movefunction.DataLabelProvider;
import org.eclipse.titanium.refactoring.movefunction.FunctionData;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionMethod;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionRefactoring;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionType;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionWizardDestinationsPage;

public class MoveFunctionWizardFunctionsPage
extends UserInputWizardPage {
    private final MoveFunctionRefactoring refactoring;
    private StyledText functionBody;
    private CheckboxTreeViewer tree;

    MoveFunctionWizardFunctionsPage(String name, MoveFunctionRefactoring refactoring) {
        super(name);
        this.refactoring = refactoring;
        refactoring.getSettings().setType(MoveFunctionType.MODULE);
        refactoring.getSettings().setMethod(MoveFunctionMethod.LENGTH);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        this.initializeDialogUnits((Control)top);
        top.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        top.setLayout((Layout)new GridLayout(1, false));
        Label title = new Label(top, 0);
        title.setText("Select the functions you want to move.");
        Composite comp1 = new Composite(top, 0);
        this.initializeDialogUnits((Control)comp1);
        comp1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        comp1.setLayout((Layout)new FillLayout());
        Composite comp2 = new Composite(top, 0);
        this.initializeDialogUnits((Control)comp2);
        comp2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        comp2.setLayout((Layout)new FillLayout());
        this.tree = new CheckboxTreeViewer(comp1, 770);
        this.tree.setContentProvider((IContentProvider)new DataProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new DataLabelProvider());
        this.tree.setInput(this.refactoring.getModules());
        this.tree.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(final CheckStateChangedEvent event) {
                if (event.getElement() instanceof Module && event.getChecked() && MoveFunctionWizardFunctionsPage.this.refactoring.getFunctions().get(event.getElement()).isEmpty()) {
                    WorkspaceJob wj = new WorkspaceJob("Find functions in module: " + event.getElement()){

                        public IStatus runInWorkspace(IProgressMonitor monitor) {
                            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)((TTCN3Module)event.getElement()).getDefinitions().getNofAssignments());
                            progress.setTaskName("Analysis of module: " + event.getElement());
                            final Object[] children = MoveFunctionWizardFunctionsPage.this.refactoring.selectMovableFunctions((TTCN3Module)event.getElement(), progress).toArray();
                            progress.done();
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    if (children != null) {
                                        MoveFunctionWizardFunctionsPage.this.tree.add(event.getElement(), children);
                                        MoveFunctionWizardFunctionsPage.this.tree.setSubtreeChecked(event.getElement(), event.getChecked());
                                    }
                                    MoveFunctionWizardFunctionsPage.this.tree.expandToLevel(event.getElement(), 2);
                                    MoveFunctionWizardFunctionsPage.this.setCheckedFunctions();
                                }
                            });
                            return Status.OK_STATUS;
                        }
                    };
                    wj.setSystem(false);
                    wj.setUser(true);
                    wj.schedule();
                } else {
                    MoveFunctionWizardFunctionsPage.this.tree.setSubtreeChecked(event.getElement(), event.getChecked());
                    MoveFunctionWizardFunctionsPage.this.setCheckedFunctions();
                }
            }
        });
        this.functionBody = new StyledText(comp2, 768);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                for (Map.Entry<Module, List<FunctionData>> entry : MoveFunctionWizardFunctionsPage.this.refactoring.getFunctions().entrySet()) {
                    for (FunctionData fd : entry.getValue()) {
                        if (!event.getSelection().toString().substring(1, event.getSelection().toString().length() - 1).equals(fd.toString())) continue;
                        MoveFunctionWizardFunctionsPage.this.functionBody.setText(fd.getFunctionBody());
                    }
                }
            }
        });
        this.setCheckedFunctions();
        if (this.refactoring.getStatus().hasEntries()) {
            this.setErrorMessage(this.refactoring.getStatus().getEntryAt(0).getMessage() + "\nThis feature is work in progress.");
        } else {
            this.setErrorMessage("This feature is work in progress.");
        }
    }

    public MoveFunctionRefactoring getRefactoring() {
        return this.refactoring;
    }

    public void refreshTree() {
        this.tree.refresh();
        for (List<FunctionData> list : this.refactoring.getFunctions().values()) {
            for (FunctionData fd : list) {
                if (fd.isToBeMoved()) {
                    this.tree.setSubtreeChecked((Object)fd, true);
                    continue;
                }
                this.tree.setSubtreeChecked((Object)fd, false);
            }
        }
        if (this.refactoring.getStatus().hasEntries()) {
            this.setErrorMessage(this.refactoring.getStatus().getEntryAt(0).getMessage() + "\nThis feature is work in progress.");
        } else {
            this.setErrorMessage("This feature is work in progress.");
        }
    }

    public void setCheckedFunctions() {
        List<Object> checked = Arrays.asList(this.tree.getCheckedElements());
        boolean isChecked = false;
        for (Map.Entry<Module, List<FunctionData>> entry : this.refactoring.getFunctions().entrySet()) {
            for (FunctionData fd : entry.getValue()) {
                if (checked.contains(fd)) {
                    isChecked = true;
                    fd.setToBeMoved(true);
                    continue;
                }
                fd.setToBeMoved(false);
            }
        }
        if (this.tree.getCheckedElements().length == 0 || !isChecked) {
            this.setPageComplete(false);
        } else if (isChecked && !this.isPageComplete()) {
            this.setPageComplete(true);
        }
    }

    public IWizardPage getNextPage() {
        IWizardPage page2 = super.getNextPage();
        if (page2.getControl() != null && page2 instanceof MoveFunctionWizardDestinationsPage) {
            ((MoveFunctionWizardDestinationsPage)page2).refreshTree();
        }
        return page2;
    }

    class DataProvider
    implements ITreeContentProvider {
        DataProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Object[] modules = new Module[((Map)inputElement).keySet().size()];
                ((Map)inputElement).keySet().toArray(modules);
                Arrays.sort(modules, new Comparator<Module>(){

                    @Override
                    public int compare(Module m1, Module m2) {
                        return m1.getIdentifier().getDisplayName().compareToIgnoreCase(m2.getIdentifier().getDisplayName());
                    }
                });
                if (modules.length == 0) {
                    return new Object[]{"There are no functions to be moved."};
                }
                return modules;
            }
            return new Object[]{"There are no functions to be moved."};
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Module && !MoveFunctionWizardFunctionsPage.this.refactoring.getFunctions().get(parentElement).isEmpty()) {
                Collections.sort(MoveFunctionWizardFunctionsPage.this.refactoring.getFunctions().get(parentElement));
                return MoveFunctionWizardFunctionsPage.this.refactoring.getFunctions().get(parentElement).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Module;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

