/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.applications;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titanium.utils.ProjectAnalyzerJob;

public abstract class InformationExporter
implements IApplication {
    protected abstract boolean checkParameters(String[] var1);

    protected abstract void exportInformationForProject(String[] var1, IProject var2, IProgressMonitor var3);

    public Object start(IApplicationContext context) throws Exception {
        File path;
        Platform.getBundle((String)"org.eclipse.titan.designer").start();
        final String[] args = (String[])context.getArguments().get("application.args");
        if (!this.checkParameters(args)) {
            return -1;
        }
        if (args.length >= 1 && !(path = new File(args[0].substring(0, args[0].lastIndexOf(File.separator)))).exists() && !path.mkdirs()) {
            System.err.println("Couldn't create output directory!");
            return -1;
        }
        List<IProject> existingProjects = this.getProjectsToHandle();
        for (IProject project : existingProjects) {
            ProjectAnalyzerJob job = new ProjectAnalyzerJob("Exporting information for project " + project.getName()){

                @Override
                public IStatus doPostWork(IProgressMonitor monitor) {
                    System.out.println("Exporting information for " + this.getProject().getName());
                    InformationExporter.this.exportInformationForProject(args, this.getProject(), monitor);
                    return Status.OK_STATUS;
                }
            }.quickSchedule(project);
            job.join();
        }
        boolean result = true;
        try {
            ResourcesPlugin.getWorkspace().save(true, null);
        }
        catch (Exception e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while closing workspace", (Throwable)e);
            result = false;
        }
        if (result) {
            if (args.length >= 1) {
                System.out.println("All informations are successfully exported to " + args[0].substring(0, args[0].lastIndexOf(File.separator)));
            } else {
                System.out.println("All information is succesfully exported.");
            }
            return EXIT_OK;
        }
        System.err.println("The export wasn't successfull, see zour workspace1s errorlog for details");
        return -1;
    }

    protected List<IProject> getProjectsToHandle() {
        return this.getAllAccessibleProjects();
    }

    protected List<IProject> getAllAccessibleProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> existingProjects = new ArrayList<IProject>();
        for (IProject project : projects) {
            if (!project.isAccessible()) continue;
            existingProjects.add(project);
        }
        return existingProjects;
    }

    public void stop() {
    }
}

