/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.extractors;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.extractors.Extractor;
import org.eclipse.titan.log.viewer.extractors.TestCaseEvent;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.utils.Constants;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;

public class TestCaseExtractor
extends Extractor {
    private IFile logFile;
    private List<LogRecordIndex> logRecordIndexVector;
    private List<TestCase> testCaseVector = new ArrayList<TestCase>();
    private TestCase currentTestCase;
    private int currentProgress;
    private boolean withinTestCase = false;
    private int currentTestCaseNumber = 0;
    private int endRecordNumber = 0;
    private LogRecordIndex lastRecordIndex;
    private boolean optionSet = false;
    private boolean crashed = false;
    private int currentControlPartNumber = 1;
    private boolean firstActivation = true;

    public TestCaseExtractor() {
        this.logRecordIndexVector = new ArrayList<LogRecordIndex>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractTestCasesFromIndexedLogFile(IFile logFile) throws IOException, ClassNotFoundException {
        this.logFile = logFile;
        File indexFile = LogFileCacheHandler.getIndexFileForLogFile(logFile);
        if (indexFile.length() == 0L) {
            throw new IOException();
        }
        ObjectInputStream indexFileInputStream = null;
        try {
            indexFileInputStream = new ObjectInputStream(new FileInputStream(indexFile));
            Object o = indexFileInputStream.readObject();
            if (o instanceof List) {
                List testCases = (List)o;
                double sizeFactor = 100.0 / (double)testCases.size();
                int i = 0;
                for (Object testCase : testCases) {
                    ++i;
                    if (testCase instanceof TestCase) {
                        this.currentTestCase = (TestCase)testCase;
                        this.currentProgress = (int)(sizeFactor * (double)i);
                        this.addTestCase();
                        continue;
                    }
                    throw new ClassNotFoundException("Class not found!");
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(indexFileInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)indexFileInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TestCase getTestCaseFromIndexFile(File indexFile, int testCaseNumber) throws IOException, TechnicalException, ClassNotFoundException {
        ObjectInputStream indexFileInputStream;
        block3: {
            TestCase testCase;
            indexFileInputStream = null;
            try {
                indexFileInputStream = new ObjectInputStream(new FileInputStream(indexFile));
                Object o = indexFileInputStream.readObject();
                if (!(o instanceof List)) break block3;
                List testCases = (List)o;
                int testCasePosition = testCaseNumber - 1;
                if (testCases.size() < testCasePosition) {
                    throw new TechnicalException(Messages.getString("TestCaseExtractor.4"));
                }
                testCase = (TestCase)testCases.get(testCasePosition);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(indexFileInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)indexFileInputStream);
            return testCase;
        }
        IOUtils.closeQuietly((Closeable)indexFileInputStream);
        return null;
    }

    public void extractTestCasesFromLogFile(LogFileMetaData logFileMetaData, IProgressMonitor pMonitor) throws IOException {
        IProgressMonitor monitor = pMonitor == null ? new NullProgressMonitor() : pMonitor;
        this.logFile = logFileMetaData.getLogfile();
        if (this.logFile == null) {
            throw new IOException("Log file not found.");
        }
        this.extractFromLogFile(logFileMetaData, monitor);
        if (monitor.isCanceled()) {
            this.testCaseVector = null;
            this.logRecordIndexVector = null;
            this.crashed = true;
            return;
        }
        if (this.crashed) {
            if (!this.testCaseVector.isEmpty()) {
                this.testCaseVector.get(this.testCaseVector.size() - 1).setEndRecordNumber(this.endRecordNumber);
            }
        } else if (this.withinTestCase) {
            this.crashed = true;
            this.testCaseVector.add(new TestCase(this.logFile, -1, Messages.getString("TestCaseExtractor.3"), this.filePointer, 5, this.currentTestCase.getStartRecordNumber(), this.endRecordNumber));
        }
    }

    public List<TestCase> getTestCases() {
        return this.testCaseVector;
    }

    public List<LogRecordIndex> getLogRecordIndexes() {
        return this.logRecordIndexVector;
    }

    public boolean failedDuringExtraction() {
        return this.crashed;
    }

    @Override
    protected void processRow(int offsetStart, int offsetEnd, int recordNumber) throws IOException {
        this.addLogRecordIndex(this.filePointer, offsetStart, offsetEnd, recordNumber);
        if (!this.optionSet && this.contains(Constants.LOG_FORMAT, offsetStart, offsetEnd)) {
            int startPos = this.findPos(Constants.LOG_FORMAT_OPTION, offsetStart, offsetEnd);
            startPos = startPos + Constants.LOG_FORMAT_OPTION.length + 1;
            String option = new String(this.buffer, startPos, offsetEnd - startPos);
            this.logFileMetaData.setOption(option);
            this.logFileMetaData.setFileFormat(2);
            this.optionSet = true;
        }
        if (this.firstActivation) {
            this.firstActivation = false;
            this.createTestcase(this.logFile, "controlpart 1", recordNumber);
            ++this.currentControlPartNumber;
            this.withinTestCase = false;
        }
        if (this.crashed) {
            int newProgress = (int)((double)this.filePointer * (100.0 / (double)this.fileSize));
            if (newProgress > this.currentProgress) {
                this.currentProgress = newProgress;
                this.setChanged();
                this.notifyObservers(new TestCaseEvent("", this.currentProgress));
            }
            return;
        }
        int tcPos = this.findPos(Constants.TEST_CASE, offsetStart, offsetEnd);
        if (tcPos == -1) {
            return;
        }
        if (this.contains(Constants.TEST_CASE_FINISHED, offsetStart, offsetEnd)) {
            if (!this.withinTestCase) {
                this.currentTestCase = null;
                this.addCrashedTestCase();
                return;
            }
            int testCaseEndPos = this.findPos(Constants.TEST_CASE_FINISHED, offsetStart, offsetEnd);
            if (this.currentTestCase == null || !this.currentTestCase.getTestCaseName().contentEquals(new String(this.buffer, tcPos + Constants.TEST_CASE.length + 2, testCaseEndPos - tcPos - Constants.TEST_CASE.length - 2))) {
                this.addCrashedTestCase();
                return;
            }
            this.withinTestCase = false;
            int verdictPos = this.findPos(Constants.VERDICT, offsetStart, offsetEnd);
            if (verdictPos != -1) {
                int off = verdictPos + Constants.VERDICT.length + 2;
                String verdict = new String(this.buffer, off, offsetEnd - off);
                int spacePos = verdict.indexOf(32);
                if (spacePos > 0) {
                    verdict = verdict.substring(0, spacePos);
                }
                this.currentTestCase.setVerdict(this.getVerdict(verdict));
            }
            this.currentTestCase.setEndRecordNumber(recordNumber);
            this.addTestCase();
            this.createTestcase(this.logFile, "controlpart " + this.currentControlPartNumber, recordNumber + 1);
            ++this.currentControlPartNumber;
            this.withinTestCase = false;
            return;
        }
        int tcPosEnd = this.findPos(Constants.TEST_CASE_STARTED, offsetStart, offsetEnd);
        if (tcPosEnd != -1) {
            if (this.withinTestCase) {
                this.addCrashedTestCase();
                return;
            }
            if (this.currentTestCase.getStartRecordNumber() >= recordNumber - 1 && !this.withinTestCase) {
                --this.currentControlPartNumber;
                --this.currentTestCaseNumber;
            } else {
                this.currentTestCase.setEndRecordNumber(recordNumber - 1);
                this.addTestCase();
            }
            this.withinTestCase = true;
            this.createTestcase(this.logFile, new String(this.buffer, (tcPos += 2) + Constants.TEST_CASE_STARTED.length + 2, tcPosEnd - tcPos - Constants.TEST_CASE.length), recordNumber);
            return;
        }
    }

    @Override
    protected void processRowsFinished(int offsetStart, int offsetEnd, int recordNumber) throws IOException {
        if (this.currentTestCase != null) {
            this.currentTestCase.setEndRecordNumber(recordNumber - 1);
            this.addTestCase();
        }
    }

    private void createTestcase(IFile logFile, String name, int recordNumber) {
        ++this.currentTestCaseNumber;
        this.currentTestCase = new TestCase(logFile);
        this.currentTestCase.setTestCaseNumber(this.currentTestCaseNumber);
        this.currentProgress = (int)((double)this.filePointer * (100.0 / (double)this.fileSize));
        this.currentTestCase.setTestCaseName(name);
        this.currentTestCase.setFilePointer(this.filePointer);
        this.currentTestCase.setStartRecordNumber(recordNumber);
    }

    private void addTestCase() {
        String message = "";
        if (!this.crashed) {
            this.testCaseVector.add(this.currentTestCase);
            message = this.currentTestCase.getTestCaseName();
        }
        this.setChanged();
        final String fMessage = message;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TestCaseExtractor.this.notifyObservers(new TestCaseEvent(fMessage, TestCaseExtractor.this.currentProgress));
            }
        });
    }

    private void addCrashedTestCase() {
        if (!this.crashed) {
            this.crashed = true;
            TestCase temp = new TestCase(this.logFile, -1, Messages.getString("TestCaseExtractor.3"), this.filePointer, 5, this.recordNumber, this.recordNumber);
            this.testCaseVector.add(temp);
        }
    }

    private void addLogRecordIndex(long filePointer, int offsetStart, int offsetEnd, int recordNumber) {
        int recordLength = offsetEnd - offsetStart + 1;
        this.endRecordNumber = recordNumber;
        if (this.hasValidTimeStamp(offsetStart, recordLength)) {
            LogRecordIndex currentLogRecordIndex = new LogRecordIndex(filePointer, recordLength, recordNumber);
            this.logRecordIndexVector.add(currentLogRecordIndex);
            this.lastRecordIndex = currentLogRecordIndex;
        } else if (this.lastRecordIndex != null) {
            this.lastRecordIndex.addRecordLen(recordLength);
            --this.recordNumber;
        }
    }

    private int getVerdict(String verdict) {
        Integer verdictConstant = Constants.TEST_CASE_VERDICTS.get(verdict.trim());
        if (verdictConstant != null) {
            return verdictConstant;
        }
        return 1;
    }
}

