/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.preferences.pages;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.log.viewer.Activator;
import org.eclipse.titan.log.viewer.preferences.DecipheringPreferenceHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.MutableComboFieldEditor;
import org.eclipse.titan.log.viewer.preferences.fieldeditors.StringListEditor;
import org.eclipse.titan.log.viewer.preferences.pages.LogViewerPreferenceRootPage;
import org.eclipse.titan.log.viewer.utils.ImportExportUtils;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class DecipheringPreferencePage
extends LogViewerPreferenceRootPage {
    private static final String XML_EXTENSION_MASK = "*.xml";
    private static final String XML_EXTENSION = ".xml";
    private MutableComboFieldEditor comboFieldEditor;
    private StringListEditor messageTypeEditor;
    private StringListEditor ruleEditor;
    private String selectedRuleSet;
    private final List<String> deletedRuleSets = new ArrayList<String>();
    private final Map<String, String> deletedMsgTypes = new HashMap<String, String>();

    public DecipheringPreferencePage() {
        super(1, false);
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.setDescription("Message name deciphering options");
    }

    @Override
    public void createFieldEditors() {
        this.comboFieldEditor = new MutableComboFieldEditor(DecipheringPreferenceHandler.getPreferenceKeyForRulesets(), "rulesets", this.getFieldEditorParent());
        this.comboFieldEditor.setPreferenceStore(this.getPreferenceStore());
        this.addField(this.comboFieldEditor);
        this.comboFieldEditor.setInputValidator(new IInputValidator(){

            public String isValid(String newText) {
                String[] items;
                if (newText == null || newText.length() == 0) {
                    return "The name should contain at least one character.";
                }
                for (String str : items = DecipheringPreferencePage.this.comboFieldEditor.getItems()) {
                    if (!str.equals(newText)) continue;
                    return "Ruleset with the given name already exists.";
                }
                return null;
            }
        });
        this.comboFieldEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecipheringPreferencePage.this.updateMsgTypeEditor();
            }
        });
        this.comboFieldEditor.addItemListener(new MutableComboFieldEditor.IItemListener(){

            @Override
            public void itemRemoved(String item) {
                DecipheringPreferencePage.this.deletedRuleSets.add(item);
                DecipheringPreferencePage.this.updateMsgTypeEditor();
            }

            @Override
            public void itemAdded(String item) {
                DecipheringPreferencePage.this.comboFieldEditor.select(DecipheringPreferencePage.this.comboFieldEditor.getItemCount() - 1);
                DecipheringPreferencePage.this.updateMsgTypeEditor();
            }
        });
        this.messageTypeEditor = new StringListEditor("", "Message types", this.getFieldEditorParent(), false);
        this.messageTypeEditor.setPreferenceStore(this.getPreferenceStore());
        this.messageTypeEditor.setInputValidator(new IInputValidator(){

            public String isValid(String newText) {
                return DecipheringPreferenceHandler.MSGTPYE_PATTERN.matcher(newText).matches() ? null : "Invalid message type.";
            }
        });
        this.messageTypeEditor.setEnabled(false, this.getFieldEditorParent());
        this.messageTypeEditor.addSelectionChangedListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DecipheringPreferencePage.this.updateRuleEditor();
            }
        });
        this.addField(this.messageTypeEditor);
        this.ruleEditor = new StringListEditor("", "Deciphering rules", this.getFieldEditorParent(), true);
        this.ruleEditor.setPreferenceStore(this.getPreferenceStore());
        this.ruleEditor.setInputValidator(new IInputValidator(){

            public String isValid(String newText) {
                return DecipheringPreferenceHandler.RULE_PATTERN.matcher(newText).matches() ? null : "Invalid rule type.";
            }
        });
        this.ruleEditor.setEnabled(false, this.getFieldEditorParent());
        this.addField(this.ruleEditor);
        this.updatePage();
    }

    @Override
    protected String getPageId() {
        return "org.eclipse.titan.log.viewer.properties.MessageDecipheringPreferencePage";
    }

    @Override
    protected void exportPreferences() {
        Shell shell = new Shell(PlatformUI.getWorkbench().getDisplay());
        FileDialog dialog = new FileDialog(shell, 8192);
        String exportLastDir = PreferencesHandler.getInstance().getExportLastDir();
        boolean pathValid = new Path(exportLastDir).isValidPath(exportLastDir);
        if (exportLastDir.compareTo("") != 0 && pathValid) {
            dialog.setFilterPath(exportLastDir);
        }
        dialog.setFilterExtensions(new String[]{XML_EXTENSION_MASK});
        dialog.setText(Messages.getString("ImportExportUtils.0"));
        String dialogResult = dialog.open();
        if (dialogResult == null) {
            return;
        }
        String resultFile = dialog.getFilterPath() + File.separator + dialog.getFileName();
        if (resultFile.compareTo(File.separator) != 0) {
            if (!resultFile.endsWith(XML_EXTENSION)) {
                resultFile = resultFile.concat(XML_EXTENSION);
            }
            File file = new File(resultFile);
            PreferencesHandler.getInstance().setExportLastDir(file.getParentFile().getPath());
            DecipheringPreferenceHandler.exportToFile(file);
        }
    }

    @Override
    protected void importPreferences() {
        String fileName = ImportExportUtils.getImportSourceFileWithDialog();
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        if (!file.exists() || file.length() == 0L) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)"Invalid file", (String)"The file can not be found");
                }
            });
            return;
        }
        try {
            DecipheringPreferenceHandler.importFromFile(file);
        }
        catch (DecipheringPreferenceHandler.ImportFailedException e) {
            Display display = Display.getDefault();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)"Error while importing the rulesets", (String)e.getMessage());
                }
            });
        }
        this.updatePage();
    }

    @Override
    protected void updatePage() {
        this.updateRulesetEditor();
    }

    private void updateRulesetEditor() {
        this.comboFieldEditor.load();
        this.updateMsgTypeEditor();
    }

    private void updateMsgTypeEditor() {
        if (this.comboFieldEditor.getItemCount() == 0 || this.comboFieldEditor.getSelectionIndex() == -1) {
            this.messageTypeEditor.setPreferenceName("");
            this.messageTypeEditor.load();
            this.messageTypeEditor.setEnabled(false, this.getFieldEditorParent());
            this.ruleEditor.setPreferenceName("");
            this.ruleEditor.load();
            this.ruleEditor.setEnabled(false, this.getFieldEditorParent());
            return;
        }
        this.selectedRuleSet = this.comboFieldEditor.getItem(this.comboFieldEditor.getSelectionIndex());
        this.messageTypeEditor.setPreferenceName(DecipheringPreferenceHandler.getPreferenceKeyForMessageTypeList(this.selectedRuleSet));
        this.messageTypeEditor.load();
        this.messageTypeEditor.setEnabled(true, this.getFieldEditorParent());
        this.updateRuleEditor();
    }

    private void updateRuleEditor() {
        String[] msgTypes = this.messageTypeEditor.getElements();
        String[] selection = this.messageTypeEditor.getSelection();
        if (msgTypes.length == 0 || selection.length == 0) {
            this.ruleEditor.setPreferenceName("");
            this.ruleEditor.load();
            this.ruleEditor.setEnabled(false, this.getFieldEditorParent());
            return;
        }
        this.ruleEditor.setPreferenceName(DecipheringPreferenceHandler.getPreferenceKeyForRuleList(this.selectedRuleSet, selection[0]));
        this.ruleEditor.load();
        this.ruleEditor.setEnabled(true, this.getFieldEditorParent());
    }

    @Override
    protected void performApply() {
        for (String string : this.deletedRuleSets) {
            DecipheringPreferenceHandler.deleteRuleset(string);
        }
        for (Map.Entry entry : this.deletedMsgTypes.entrySet()) {
            DecipheringPreferenceHandler.deleteMsgType((String)entry.getKey(), (String)entry.getValue());
        }
        super.performApply();
    }

    public void init(IWorkbench workbench) {
    }
}

