/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.views;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.search.SearchLabelProvider;
import org.eclipse.titan.log.viewer.search.TreeContentProvider;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.text.table.TextTableView;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LogSearchResultPage
extends AbstractTextSearchViewPage {
    private TreeViewer treeViewer;
    private TreeContentProvider contentProvider;

    public LogSearchResultPage() {
        super(2);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.contentProvider != null) {
            this.treeViewer.refresh();
        }
    }

    protected void clear() {
        this.treeViewer.refresh();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        this.treeViewer = viewer;
        this.contentProvider = new TreeContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new SearchLabelProvider());
        viewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    Object selectedElement = ((TreeSelection)event.getSelection()).getFirstElement();
                    if (selectedElement instanceof Match) {
                        LogSearchResultPage.this.showMatch((Match)selectedElement, 0, 0, true);
                        return;
                    }
                }
                catch (PartInitException e) {
                    ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    TitanLogExceptionHandler.handleException(new TechnicalException("Could not show the selected match. Reason: " + e.getMessage()));
                }
            }
        });
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    public StructuredViewer getViewer() {
        return this.treeViewer;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (!selection.toList().contains(match)) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)match));
        }
        IFile logFile = (IFile)match.getElement();
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference viewReference = activePage.findViewReference("org.eclipse.titan.log.viewer.views.text.table.TextTableView", logFile.getFullPath().toOSString());
        if (viewReference == null) {
            this.openTextTableView(logFile, match.getOffset());
            return;
        }
        TextTableView view = (TextTableView)viewReference.getView(false);
        if (view != null && view.isFiltered() && !view.contains(match.getOffset())) {
            MessageBox mb = new MessageBox(this.getSite().getShell(), 196);
            mb.setText("Filtered match");
            mb.setMessage("The selected record can not be displayed in the opened TextTableView. Would you like to open a new view? (The old one will be closed)");
            switch (mb.open()) {
                case 64: {
                    activePage.hideView(viewReference);
                    this.openTextTableView(logFile, match.getOffset());
                    break;
                }
                case 128: {
                    break;
                }
                default: {
                    return;
                }
            }
            return;
        }
        TextTableView openedView = (TextTableView)activePage.showView("org.eclipse.titan.log.viewer.views.text.table.TextTableView", logFile.getFullPath().toOSString(), 2);
        openedView.setSelectedRecord(match.getOffset());
    }

    private TextTableView openTextTableView(IFile logFile, int recordToSelect) {
        try {
            TextTableView part = (TextTableView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.titan.log.viewer.views.text.table.TextTableView", logFile.getFullPath().toOSString(), 2);
            part.setInput(logFile, recordToSelect);
            return part;
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableProjectsViewMenuAction.5") + e.getMessage()));
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableProjectsViewMenuAction.6") + e.getMessage()));
        }
        catch (ClassNotFoundException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenTextTableProjectsViewMenuAction.7") + e.getMessage()));
        }
        return null;
    }
}

