/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.archiveutils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.rse.internal.services.clientserver.archiveutils.SystemArchiveUtil;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.SystemReentrantMutex;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.TarEntry;
import org.eclipse.rse.services.clientserver.archiveutils.TarFile;
import org.eclipse.rse.services.clientserver.archiveutils.TarOutputStream;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.java.BasicClassFileParser;
import org.eclipse.rse.services.clientserver.messages.SystemLockTimeoutException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.clientserver.messages.SystemUnexpectedErrorException;
import org.eclipse.rse.services.clientserver.messages.SystemUnsupportedOperationException;
import org.eclipse.rse.services.clientserver.search.SystemSearchLineMatch;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatchLocator;
import org.eclipse.rse.services.clientserver.search.SystemSearchStringMatcher;

public class SystemTarHandler
implements ISystemArchiveHandler {
    protected File file;
    protected long modTimeDuringCache;
    protected VirtualFileSystem vfs;
    protected SystemReentrantMutex _mutex;

    public SystemTarHandler(File file) throws IOException {
        this.init(file);
        this.createCache();
        this.modTimeDuringCache = file.lastModified();
        this._mutex = new SystemReentrantMutex();
    }

    protected void init(File file) throws IOException {
        this.file = file;
    }

    protected void createCache() {
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        VirtualChild root = new VirtualChild(this);
        root.isDirectory = true;
        this.vfs = new VirtualFileSystem(root);
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            VirtualChild child = this.getVirtualChild(entry);
            this.vfs.addEntry(child);
        }
    }

    protected void updateTree(HashMap newOldNames) {
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            String searchName = null;
            String entryName = entry.getName();
            VirtualChild child = null;
            searchName = newOldNames != null && newOldNames.containsKey(entryName) ? (String)newOldNames.get(entryName) : entryName;
            child = this.vfs.getEntry(searchName);
            if (child == null) {
                child = this.getVirtualChild(entry);
            } else {
                this.vfs.removeEntry(searchName);
                child = this.updateVirtualChild(entry, child);
            }
            this.vfs.addEntry(child);
        }
    }

    protected TarFile getTarFile() {
        TarFile tarFile = null;
        try {
            tarFile = new TarFile(this.file);
        }
        catch (IOException iOException) {}
        return tarFile;
    }

    protected void updateCache() throws IOException {
        File newFile = new File(this.file.getAbsolutePath());
        long modTime = newFile.lastModified();
        if (modTime != this.modTimeDuringCache) {
            this.init(newFile);
            this.updateTree(null);
            this.modTimeDuringCache = newFile.lastModified();
        }
    }

    public VirtualChild[] getVirtualChildrenList(ISystemOperationMonitor archiveOperationMonitor) {
        Vector<VirtualChild> v = new Vector<VirtualChild>();
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        while (entries.hasMoreElements()) {
            TarEntry entry = (TarEntry)entries.nextElement();
            VirtualChild child = new VirtualChild(this, entry.getName());
            child.isDirectory = entry.isDirectory();
            v.add(child);
        }
        int numOfChildren = v.size();
        VirtualChild[] children = new VirtualChild[numOfChildren];
        int i = 0;
        while (i < numOfChildren) {
            children[i] = (VirtualChild)v.get(i);
            ++i;
        }
        return children;
    }

    public VirtualChild[] getVirtualChildrenList(String parent, ISystemOperationMonitor archiveOperationMonitor) {
        parent = ArchiveHandlerManager.cleanUpVirtualPath(parent);
        Vector<VirtualChild> v = new Vector<VirtualChild>();
        TarFile tarFile = this.getTarFile();
        Enumeration entries = tarFile.entries();
        while (entries.hasMoreElements()) {
            String parentNameEndWithSlash;
            TarEntry entry = (TarEntry)entries.nextElement();
            String entryName = entry.getName();
            if (!entryName.startsWith(parentNameEndWithSlash = String.valueOf(parent) + "/") || entryName.equals(parentNameEndWithSlash)) continue;
            VirtualChild child = new VirtualChild(this, entryName);
            child.isDirectory = entry.isDirectory();
            v.add(child);
        }
        int numOfChildren = v.size();
        VirtualChild[] children = new VirtualChild[numOfChildren];
        int i = 0;
        while (i < numOfChildren) {
            children[i] = (VirtualChild)v.get(i);
            ++i;
        }
        return children;
    }

    public VirtualChild[] getVirtualChildren(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return new VirtualChild[0];
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        return this.vfs.getChildren(fullVirtualName);
    }

    public VirtualChild[] getVirtualChildFolders(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return new VirtualChild[0];
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        return this.vfs.getChildrenFolders(fullVirtualName);
    }

    public VirtualChild getVirtualFile(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == null || fullVirtualName.equals("")) {
            return new VirtualChild(this);
        }
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return new VirtualChild(this, fullVirtualName);
        }
        VirtualChild entry = this.vfs.getEntry(fullVirtualName);
        if (entry == null) {
            entry = new VirtualChild(this, fullVirtualName);
        }
        return entry;
    }

    public boolean exists(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) {
        if ((fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)) == null || fullVirtualName.equals("")) {
            return false;
        }
        try {
            this.updateCache();
        }
        catch (IOException iOException) {
            return false;
        }
        VirtualChild child = this.vfs.getEntry(fullVirtualName);
        return child != null;
    }

    public File getArchive() {
        return this.file;
    }

    public long getTimeStampFor(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        TarEntry entry = this.getTarFile().getEntry(fullVirtualName);
        if (entry != null) {
            return entry.getModificationTime();
        }
        return this.file.lastModified();
    }

    public long getSizeFor(String fullVirtualName) {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        TarEntry entry = this.getTarFile().getEntry(fullVirtualName);
        if (entry != null) {
            return entry.getSize();
        }
        return 0L;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractVirtualFile(String fullVirtualName, File destination, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        block28: {
            block24: {
                block27: {
                    block25: {
                        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
                        entry = null;
                        inStream = null;
                        outStream = null;
                        mutexLockStatus = 0;
                        try {
                            try {
                                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, 0x7FFFFFFFFFFFFFFFL);
                                if (mutexLockStatus == 0) break block24;
                                entry = this.getTarFile().getEntry(fullVirtualName);
                                this.updateCache();
                                if (entry.isDirectory()) {
                                    if (destination.exists()) {
                                        destination.delete();
                                    }
                                    destination.mkdirs();
                                    destination.setLastModified(entry.getModificationTime());
                                    var10_8 = null;
                                    break block25;
                                }
                                inStream = this.getTarFile().getInputStream(entry);
                                if (inStream == null) {
                                    destination.setLastModified(entry.getModificationTime());
                                    throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
                                }
                                if (!destination.exists()) {
                                    parentFile = destination.getParentFile();
                                    if (!parentFile.exists()) {
                                        parentFile.mkdirs();
                                    }
                                    destination.createNewFile();
                                }
                                outStream = new FileOutputStream(destination);
                                buf = new byte[512];
                                numRead = inStream.read(buf);
                                while (numRead > 0) {
                                    outStream.write(buf, 0, numRead);
                                    numRead = inStream.read(buf);
                                }
                                break block24;
                            }
                            catch (IOException e) {
                                throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
                            }
                        }
                        catch (Throwable var11_17) {
                            var10_9 = null;
                            try {
                                if (outStream != null) {
                                    outStream.close();
                                }
                                if (inStream != null) {
                                    inStream.close();
                                }
                                if (entry != null) {
                                    destination.setLastModified(entry.getModificationTime());
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            this.releaseMutex(mutexLockStatus);
                            throw var11_17;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 238->276)] { 
lbl64:
                    // 1 sources

                    if (outStream != null) {
                        outStream.close();
                    }
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (entry != null) {
                        destination.setLastModified(entry.getModificationTime());
                    }
                    break block27;
lbl72:
                    // 1 sources

                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.releaseMutex(mutexLockStatus);
                return;
            }
            var10_10 = null;
            ** try [egrp 2[TRYBLOCK] [5 : 238->276)] { 
lbl80:
            // 1 sources

            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (entry != null) {
                destination.setLastModified(entry.getModificationTime());
            }
            break block28;
lbl88:
            // 1 sources

            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.releaseMutex(mutexLockStatus);
    }

    public void extractVirtualDirectory(String fullVirtualName, File destinationParent, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualDirectory(fullVirtualName, destinationParent, null, archiveOperationMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractVirtualDirectory(String fullVirtualName, File destinationParent, File destination, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (!destinationParent.exists()) {
            if (!destinationParent.mkdirs()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Create folder " + destinationParent);
            }
        } else if (!destinationParent.isDirectory()) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "No folder: " + destinationParent);
        }
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        int mutexLockStatus = 0;
        try {
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus != 0) {
                    this.updateCache();
                    VirtualChild dir = this.vfs.getEntry(fullVirtualName);
                    if (dir == null) throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
                    if (!dir.isDirectory) {
                        throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
                    }
                    if (destination == null) {
                        destination = fullVirtualName.equals("") ? destinationParent : new File(destinationParent, dir.name);
                    }
                    File topDir = destination;
                    String topDirPath = topDir.getAbsolutePath();
                    if (!destination.equals(destinationParent)) {
                        if (destination.isFile() && destination.exists()) {
                            SystemArchiveUtil.delete(destination);
                        }
                        destination.mkdirs();
                    }
                    if (!topDir.exists() && !topDir.mkdirs()) {
                        throw new SystemOperationFailedException("org.eclipse.rse.services", "Create folder " + topDir);
                    }
                    this.extractVirtualFile(fullVirtualName, topDir, archiveOperationMonitor);
                    VirtualChild[] children = this.vfs.getChildren(fullVirtualName);
                    int i = 0;
                    while (i < children.length) {
                        VirtualChild tempChild = children[i];
                        String childPath = topDirPath;
                        if (!tempChild.isDirectory) {
                            childPath = String.valueOf(topDirPath) + File.separator + tempChild.name;
                        }
                        File childFile = new File(childPath);
                        if (tempChild.isDirectory) {
                            this.extractVirtualDirectory(tempChild.fullName, childFile, null, archiveOperationMonitor);
                        } else {
                            this.extractVirtualFile(tempChild.fullName, childFile, archiveOperationMonitor);
                        }
                        ++i;
                    }
                }
            }
            catch (IOException e) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.releaseMutex(mutexLockStatus);
            throw throwable;
        }
        {
            Object var14_17 = null;
            this.releaseMutex(mutexLockStatus);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(File file, String virtualPath, String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        int mutexLockStatus;
        block11: {
            block13: {
                block12: {
                    virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
                    mutexLockStatus = 0;
                    try {
                        try {
                            mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                            if (mutexLockStatus == 0) break block11;
                            if (!file.isDirectory()) {
                                String fullVirtualName = SystemTarHandler.getFullVirtualName(virtualPath, name);
                                if (this.exists(fullVirtualName, archiveOperationMonitor)) {
                                    this.replace(fullVirtualName, file, name, archiveOperationMonitor);
                                    this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                                    Object var12_9 = null;
                                    this.releaseMutex(mutexLockStatus);
                                    return;
                                }
                                File[] files = new File[]{file};
                                String[] names = new String[]{name};
                                this.add(files, virtualPath, names, archiveOperationMonitor);
                                this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                                break block12;
                            }
                            Vector children = new Vector();
                            this.listAllFiles(file, children);
                            int numOfChildren = children.size();
                            File[] sources = new File[numOfChildren + 1];
                            String[] newNames = new String[numOfChildren + 1];
                            int charsToTrim = file.getParentFile().getAbsolutePath().length() + 1;
                            int i = 0;
                            while (true) {
                                if (i >= numOfChildren) {
                                    sources[numOfChildren] = file;
                                    newNames[numOfChildren] = name;
                                    if (!newNames[numOfChildren].endsWith("/")) {
                                        newNames[numOfChildren] = String.valueOf(newNames[numOfChildren]) + "/";
                                    }
                                    this.add(sources, virtualPath, newNames, archiveOperationMonitor);
                                    this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                                    break block13;
                                }
                                sources[i] = (File)children.get(i);
                                newNames[i] = sources[i].getAbsolutePath().substring(charsToTrim);
                                newNames[i] = newNames[i].replace('\\', '/');
                                if (sources[i].isDirectory() && !newNames[i].endsWith("/")) {
                                    newNames[i] = String.valueOf(newNames[i]) + "/";
                                }
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            throw new SystemOperationFailedException("org.eclipse.rse.services", e);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        this.releaseMutex(mutexLockStatus);
                        throw throwable;
                    }
                }
                Object var12_10 = null;
                this.releaseMutex(mutexLockStatus);
                return;
            }
            Object var12_11 = null;
            this.releaseMutex(mutexLockStatus);
            return;
        }
        Object var12_13 = null;
        this.releaseMutex(mutexLockStatus);
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        throw new SystemUnexpectedErrorException("org.eclipse.rse.services");
    }

    public void listAllFiles(File parent, List found) {
        File[] children = parent.listFiles();
        int i = 0;
        while (i < children.length) {
            if (children[i].isDirectory()) {
                this.listAllFiles(children[i], found);
            }
            found.add(children[i]);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void add(File[] files, String virtualPath, String[] names, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        int mutexLockStatus = 0;
        File outputTempFile = null;
        TarOutputStream outStream = null;
        try {
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus != 0) {
                    this.updateCache();
                    virtualPath = ArchiveHandlerManager.cleanUpVirtualPath(virtualPath);
                    int numFiles = files.length;
                    int i = 0;
                    while (true) {
                        if (i >= numFiles) {
                            boolean ok;
                            outputTempFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
                            outStream = this.getTarOutputStream(outputTempFile);
                            VirtualChild[] children = this.getVirtualChildrenList(archiveOperationMonitor);
                            if (children.length == 0 || (ok = this.createTar(children, outStream, (HashSet)null, archiveOperationMonitor))) break;
                            outStream.close();
                            if (outputTempFile != null) {
                                outputTempFile.delete();
                            }
                            throw new SystemOperationCancelledException();
                        }
                        if (!files[i].exists() || !files[i].canRead()) {
                            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                            throw new SystemOperationFailedException("org.eclipse.rse.services", "Cannot read: " + files[i]);
                        }
                        String fullVirtualName = SystemTarHandler.getFullVirtualName(virtualPath, names[i]);
                        if (this.exists(fullVirtualName, archiveOperationMonitor)) {
                            this.replace(fullVirtualName, files[i], names[i], archiveOperationMonitor);
                            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                            Object var15_15 = null;
                            this.releaseMutex(mutexLockStatus);
                            return;
                        }
                        ++i;
                    }
                    VirtualChild[] newEntriesAdded = new VirtualChild[numFiles];
                    int i2 = 0;
                    while (true) {
                        VirtualChild temp;
                        if (i2 >= numFiles) {
                            outStream.close();
                            this.replaceFile(outputTempFile, false);
                            i2 = 0;
                            break;
                        }
                        if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                            outStream.close();
                            if (outputTempFile != null) {
                                outputTempFile.delete();
                            }
                            throw new SystemOperationCancelledException();
                        }
                        String childVirtualPath = String.valueOf(virtualPath) + "/" + names[i2];
                        TarEntry newEntry = this.createTarEntry(files[i2], childVirtualPath);
                        this.appendFile(files[i2], newEntry, outStream);
                        newEntriesAdded[i2] = temp = this.getVirtualChild(newEntry);
                        ++i2;
                    }
                    while (i2 < numFiles) {
                        this.vfs.addEntry(newEntriesAdded[i2]);
                        ++i2;
                    }
                }
            }
            catch (IOException e) {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
                throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.releaseMutex(mutexLockStatus);
            throw throwable;
        }
        {
            Object var15_17 = null;
            this.releaseMutex(mutexLockStatus);
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
            return;
        }
    }

    protected boolean createTar(VirtualChild[] children, TarOutputStream outStream, HashSet omitChildren, ISystemOperationMonitor archiveOperationMonitor) throws IOException {
        if (omitChildren != null && children.length == omitChildren.size()) {
            return true;
        }
        TarFile tarFile = this.getTarFile();
        int i = 0;
        while (i < children.length) {
            if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                return false;
            }
            if (omitChildren == null || !omitChildren.contains(children[i].fullName)) {
                TarEntry nextEntry;
                if (children[i].isDirectory) {
                    nextEntry = tarFile.getEntry(String.valueOf(children[i].fullName) + "/");
                    outStream.putNextEntry(nextEntry);
                    outStream.closeEntry();
                } else {
                    nextEntry = tarFile.getEntry(children[i].fullName);
                    InputStream inStream = tarFile.getInputStream(nextEntry);
                    outStream.putNextEntry(nextEntry);
                    byte[] buf = new byte[512];
                    int numRead = inStream.read(buf);
                    while (numRead > 0) {
                        outStream.write(buf, 0, numRead);
                        numRead = inStream.read(buf);
                    }
                    inStream.close();
                    outStream.closeEntry();
                }
            }
            ++i;
        }
        return true;
    }

    protected void appendFile(File file, TarEntry entry, TarOutputStream outStream) throws IOException {
        outStream.putNextEntry(entry);
        if (!file.isDirectory()) {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            byte[] buf = new byte[512];
            int numRead = inStream.read(buf);
            while (numRead > 0) {
                outStream.write(buf, 0, numRead);
                numRead = inStream.read(buf);
            }
            inStream.close();
        }
        outStream.closeEntry();
    }

    protected TarEntry createTarEntry(File file, String virtualPath) {
        String fullName = virtualPath;
        if (file.isDirectory() && !fullName.endsWith("/")) {
            fullName = String.valueOf(fullName) + "/";
        }
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        TarEntry entry = new TarEntry(fullName);
        if (!file.isDirectory()) {
            long size = file.length();
            entry.setSize(size);
        } else {
            entry.setSize(0L);
        }
        long lastModified = file.lastModified();
        entry.setModificationTime(lastModified);
        String userName = System.getProperty("user.name");
        if (userName != null) {
            entry.setUserName(userName);
        }
        boolean canRead = file.canRead();
        boolean canWrite = file.canWrite();
        boolean canExecute = false;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            sm = new SecurityManager();
        }
        try {
            FilePermission permission = new FilePermission(file.getAbsolutePath(), "execute");
            sm.checkPermission(permission);
            canExecute = true;
        }
        catch (SecurityException securityException) {
            canExecute = false;
        }
        entry.setUserMode(canRead, canWrite, canExecute);
        entry.calculateChecksum();
        return entry;
    }

    protected TarEntry changeTarEntry(TarEntry entry, File file, String virtualPath) {
        String fullName = virtualPath;
        if (file.isDirectory() && !fullName.endsWith("/")) {
            fullName = String.valueOf(fullName) + "/";
        }
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        entry.setName(fullName);
        if (!file.isDirectory()) {
            long size = file.length();
            entry.setSize(size);
        } else {
            entry.setSize(0L);
        }
        long lastModified = file.lastModified();
        entry.setModificationTime(lastModified);
        entry.calculateChecksum();
        return entry;
    }

    protected VirtualChild getVirtualChild(TarEntry entry) {
        VirtualChild child = new VirtualChild(this, entry.getName());
        child.isDirectory = entry.isDirectory();
        child.setComment("");
        child.setCompressedSize(entry.getSize());
        child.setCompressionMethod("");
        child.setSize(entry.getSize());
        child.setTimeStamp(entry.getModificationTime());
        return child;
    }

    protected VirtualChild updateVirtualChild(TarEntry entry, VirtualChild child) {
        child.renameTo(entry.getName());
        child.isDirectory = entry.isDirectory();
        child.setComment("");
        child.setCompressedSize(entry.getSize());
        child.setCompressionMethod("");
        child.setSize(entry.getSize());
        child.setTimeStamp(entry.getModificationTime());
        return child;
    }

    protected void replaceFile(File newFile, boolean updateCache) throws IOException {
        String name = this.file.getAbsolutePath();
        File tempFile = new File(String.valueOf(name) + ".old");
        this.file.renameTo(tempFile);
        newFile.renameTo(this.file);
        this.init(this.file);
        if (!updateCache) {
            this.modTimeDuringCache = this.file.lastModified();
        }
        this.updateCache();
        tempFile.delete();
    }

    public void replace(String fullVirtualName, File file, String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        try {
            this.updateCache();
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
        if (!file.exists() && !file.canRead()) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", "Cannot read " + file);
        }
        if (!this.exists(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName), archiveOperationMonitor)) {
            this.add(file, fullVirtualName, name, archiveOperationMonitor);
            return;
        }
        try {
            File outputTempFile = new File(String.valueOf(this.getArchive().getAbsolutePath()) + "temp");
            TarOutputStream outStream = this.getTarOutputStream(outputTempFile);
            VirtualChild[] children = this.getVirtualChildrenList(archiveOperationMonitor);
            HashSet<String> omissions = new HashSet<String>();
            omissions.add(fullVirtualName);
            boolean ok = this.createTar(children, outStream, omissions, archiveOperationMonitor);
            if (!ok) {
                outStream.close();
                if (outputTempFile != null) {
                    outputTempFile.delete();
                }
                throw new SystemOperationCancelledException();
            }
            String parentVirtualPath = null;
            int i = fullVirtualName.lastIndexOf("/");
            parentVirtualPath = i == -1 ? "" : fullVirtualName.substring(0, i);
            String virtualPath = String.valueOf(parentVirtualPath) + "/" + name;
            TarFile tarFile = this.getTarFile();
            TarEntry entry = tarFile.getEntry(fullVirtualName);
            entry = this.changeTarEntry(entry, file, virtualPath);
            this.appendFile(file, entry, outStream);
            this.updateVirtualChild(entry, this.vfs.getEntry(fullVirtualName));
            outStream.close();
            this.replaceFile(outputTempFile, false);
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
    }

    public boolean delete(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        boolean returnCode = this.doDelete(fullVirtualName, archiveOperationMonitor);
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
        return returnCode;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean doDelete(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        File outputTempFile = null;
        int mutexLockStatus = 0;
        try {
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus == 0) throw new SystemLockTimeoutException("org.eclipse.rse.services");
                this.updateCache();
                fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
                VirtualChild child = this.getVirtualFile(fullVirtualName, archiveOperationMonitor);
                VirtualChild[] omitArray = new VirtualChild[]{};
                if (!child.exists()) {
                    Object var11_8 = null;
                    this.releaseMutex(mutexLockStatus);
                    return false;
                }
                if (child.isDirectory) {
                    omitArray = this.getVirtualChildrenList(fullVirtualName, archiveOperationMonitor);
                }
                outputTempFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
                TarOutputStream outStream = this.getTarOutputStream(outputTempFile);
                VirtualChild[] children = this.getVirtualChildrenList(archiveOperationMonitor);
                HashSet<String> omissions = new HashSet<String>();
                omissions.add(child.fullName);
                int i = 0;
                while (true) {
                    if (i >= omitArray.length) {
                        boolean ok = this.createTar(children, outStream, omissions, archiveOperationMonitor);
                        if (ok) break;
                        outStream.close();
                        if (outputTempFile == null) throw new SystemOperationCancelledException();
                        outputTempFile.delete();
                        throw new SystemOperationCancelledException();
                    }
                    omissions.add(omitArray[i].fullName);
                    ++i;
                }
                this.vfs.removeEntry(child);
                outStream.close();
                this.replaceFile(outputTempFile, false);
            }
            catch (IOException e) {
                if (outputTempFile == null) throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not delete " + fullVirtualName, e);
                outputTempFile.delete();
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not delete " + fullVirtualName, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.releaseMutex(mutexLockStatus);
            throw throwable;
        }
        {
            Object var11_10 = null;
            this.releaseMutex(mutexLockStatus);
            return true;
        }
    }

    public void rename(String fullVirtualName, String newName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        int i = (fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName)).lastIndexOf("/");
        if (i == -1) {
            this.fullRename(fullVirtualName, newName, archiveOperationMonitor);
        } else {
            String fullNewName = String.valueOf(fullVirtualName.substring(0, i + 1)) + newName;
            this.fullRename(fullVirtualName, fullNewName, archiveOperationMonitor);
        }
        this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
    }

    public void move(String fullVirtualName, String destinationVirtualPath, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        destinationVirtualPath = ArchiveHandlerManager.cleanUpVirtualPath(destinationVirtualPath);
        int i = fullVirtualName.lastIndexOf("/");
        if (i == -1) {
            this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + "/" + fullVirtualName, archiveOperationMonitor);
        } else {
            String name = fullVirtualName.substring(i);
            this.fullRename(fullVirtualName, String.valueOf(destinationVirtualPath) + name, archiveOperationMonitor);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void fullRename(String fullVirtualName, String newFullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        int mutexLockStatus = 0;
        File outputTempFile = null;
        try {
            try {
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus == 0) throw new SystemLockTimeoutException("org.eclipse.rse.services");
                fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
                newFullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(newFullVirtualName);
                VirtualChild child = this.getVirtualFile(fullVirtualName, archiveOperationMonitor);
                if (!child.exists()) {
                    throw new SystemOperationFailedException("org.eclipse.rse.services", "Not exists: " + child);
                }
                outputTempFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
                TarOutputStream outStream = this.getTarOutputStream(outputTempFile);
                VirtualChild[] children = this.getVirtualChildrenList(archiveOperationMonitor);
                HashMap<String, String> oldNewNames = new HashMap<String, String>();
                HashMap<String, String> newOldNames = new HashMap<String, String>();
                if (child.isDirectory) {
                    oldNewNames.put(String.valueOf(fullVirtualName) + "/", String.valueOf(newFullVirtualName) + "/");
                    newOldNames.put(String.valueOf(newFullVirtualName) + "/", String.valueOf(fullVirtualName) + "/");
                    VirtualChild[] childrenArray = this.getVirtualChildrenList(fullVirtualName, archiveOperationMonitor);
                    int i = 0;
                    while (i < childrenArray.length) {
                        int j = fullVirtualName.length();
                        String suffix = childrenArray[i].fullName.substring(j);
                        String newName = String.valueOf(newFullVirtualName) + suffix;
                        if (childrenArray[i].isDirectory) {
                            oldNewNames.put(String.valueOf(childrenArray[i].fullName) + "/", String.valueOf(newName) + "/");
                            newOldNames.put(String.valueOf(newName) + "/", String.valueOf(childrenArray[i].fullName) + "/");
                        } else {
                            oldNewNames.put(childrenArray[i].fullName, newName);
                            newOldNames.put(newName, childrenArray[i].fullName);
                        }
                        ++i;
                    }
                } else {
                    oldNewNames.put(fullVirtualName, newFullVirtualName);
                    newOldNames.put(newFullVirtualName, fullVirtualName);
                }
                boolean ok = this.createTar(children, outStream, oldNewNames, archiveOperationMonitor);
                if (!ok) {
                    outStream.close();
                    if (outputTempFile == null) throw new SystemOperationCancelledException();
                    outputTempFile.delete();
                    throw new SystemOperationCancelledException();
                }
                outStream.close();
                this.replaceFile(outputTempFile, true);
                this.updateTree(newOldNames);
            }
            catch (IOException e) {
                if (outputTempFile == null) throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not rename " + fullVirtualName, e);
                outputTempFile.delete();
                throw new SystemOperationFailedException("org.eclipse.rse.services", "Could not rename " + fullVirtualName, e);
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            this.releaseMutex(mutexLockStatus);
            throw throwable;
        }
        {
            Object var16_20 = null;
            this.releaseMutex(mutexLockStatus);
            return;
        }
    }

    protected boolean createTar(VirtualChild[] children, TarOutputStream outStream, HashMap renameMap, ISystemOperationMonitor archiveOperationMonitor) throws IOException {
        TarFile tarFile = this.getTarFile();
        int i = 0;
        while (i < children.length) {
            String oldPath;
            if (archiveOperationMonitor != null && archiveOperationMonitor.isCancelled()) {
                return false;
            }
            VirtualChild child = children[i];
            String newPath = oldPath = child.getArchiveStandardName();
            boolean needToRename = false;
            if (renameMap.containsKey(oldPath)) {
                newPath = (String)renameMap.get(oldPath);
                child.renameTo(newPath);
                needToRename = true;
            }
            TarEntry nextEntry = tarFile.getEntry(oldPath);
            if (children[i].isDirectory) {
                if (needToRename) {
                    nextEntry = this.changeTarEntryName(nextEntry, newPath);
                }
                outStream.putNextEntry(nextEntry);
                outStream.closeEntry();
            } else {
                InputStream inStream = tarFile.getInputStream(nextEntry);
                if (needToRename) {
                    nextEntry = this.changeTarEntryName(nextEntry, newPath);
                }
                outStream.putNextEntry(nextEntry);
                byte[] buf = new byte[512];
                int numRead = inStream.read(buf);
                while (numRead > 0) {
                    outStream.write(buf, 0, numRead);
                    numRead = inStream.read(buf);
                }
                inStream.close();
                outStream.closeEntry();
            }
            ++i;
        }
        return true;
    }

    protected TarEntry changeTarEntryName(TarEntry entry, String newName) {
        entry.setName(newName);
        entry.calculateChecksum();
        return entry;
    }

    public File[] getFiles(String[] fullNames, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        File[] files = new File[fullNames.length];
        int i = 0;
        while (i < fullNames.length) {
            String fullName = fullNames[i];
            int j = (fullName = ArchiveHandlerManager.cleanUpVirtualPath(fullName)).lastIndexOf("/");
            String name = j == -1 ? fullName : fullName.substring(j + 1);
            try {
                files[i] = File.createTempFile(name, "virtual");
                files[i].deleteOnExit();
                this.extractVirtualFile(fullNames[i], files[i], archiveOperationMonitor);
            }
            catch (IOException e) {
                throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
            }
            ++i;
        }
        return files;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createFolder(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        fullVirtualName = String.valueOf(fullVirtualName) + "/";
        try {
            this.createVirtualObject(fullVirtualName, archiveOperationMonitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createFile(String fullVirtualName, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        try {
            this.createVirtualObject(fullVirtualName, archiveOperationMonitor);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.setArchiveOperationMonitorStatusDone(archiveOperationMonitor);
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean createVirtualObject(String name, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        File outputTempFile = null;
        TarOutputStream outStream = null;
        int mutexLockStatus = 0;
        try {
            try {
                boolean ok;
                mutexLockStatus = this._mutex.waitForLock(archiveOperationMonitor, Long.MAX_VALUE);
                if (mutexLockStatus == 0) throw new SystemLockTimeoutException("org.eclipse.rse.services");
                this.updateCache();
                if (this.exists(name, archiveOperationMonitor)) {
                    Object var9_6 = null;
                    this.releaseMutex(mutexLockStatus);
                    return false;
                }
                outputTempFile = new File(String.valueOf(this.file.getAbsolutePath()) + "temp");
                outStream = this.getTarOutputStream(outputTempFile);
                VirtualChild[] children = this.getVirtualChildrenList(archiveOperationMonitor);
                if (children.length != 0 && !(ok = this.createTar(children, outStream, (HashSet)null, archiveOperationMonitor))) {
                    outStream.close();
                    if (outputTempFile == null) throw new SystemOperationCancelledException();
                    outputTempFile.delete();
                    throw new SystemOperationCancelledException();
                }
                TarEntry newEntry = this.appendEmptyFile(outStream, name);
                VirtualChild temp = this.getVirtualChild(newEntry);
                this.vfs.addEntry(temp);
                outStream.close();
                this.replaceFile(outputTempFile, false);
            }
            catch (IOException e) {
                if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception exp) {
                        exp.printStackTrace();
                    }
                }
                if (outputTempFile == null) throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
                outputTempFile.delete();
                throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.releaseMutex(mutexLockStatus);
            throw throwable;
        }
        {
            Object var9_8 = null;
            this.releaseMutex(mutexLockStatus);
            return true;
        }
    }

    protected TarEntry appendEmptyFile(TarOutputStream outStream, String name) throws IOException {
        TarEntry newEntry = new TarEntry(name);
        newEntry.setSize(0L);
        newEntry.setModificationTime(System.currentTimeMillis());
        String userName = System.getProperty("user.name");
        if (userName != null) {
            newEntry.setUserName(userName);
        }
        boolean canRead = this.file.canRead();
        boolean canWrite = this.file.canWrite();
        boolean canExecute = false;
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            sm = new SecurityManager();
        }
        try {
            FilePermission permission = new FilePermission(this.file.getAbsolutePath(), "execute");
            sm.checkPermission(permission);
            canExecute = true;
        }
        catch (SecurityException securityException) {
            canExecute = false;
        }
        newEntry.setUserMode(canRead, canWrite, canExecute);
        newEntry.calculateChecksum();
        outStream.putNextEntry(newEntry);
        outStream.closeEntry();
        return newEntry;
    }

    public String getStandardName(VirtualChild vc) {
        if (vc.isDirectory) {
            return String.valueOf(vc.fullName) + "/";
        }
        return vc.fullName;
    }

    public void create() throws SystemMessageException {
        try {
            TarOutputStream outStream = this.getTarOutputStream(this.file);
            outStream.close();
            this.createCache();
            this.modTimeDuringCache = this.file.lastModified();
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
    }

    public SystemSearchLineMatch[] search(String fullVirtualName, SystemSearchStringMatcher matcher, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        if (matcher.isSearchStringEmpty() || matcher.isSearchStringAsterisk()) {
            return new SystemSearchLineMatch[0];
        }
        VirtualChild vc = this.getVirtualFile(fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName), archiveOperationMonitor);
        if (!vc.exists() || vc.isDirectory) {
            return new SystemSearchLineMatch[0];
        }
        TarFile tarFile = this.getTarFile();
        TarEntry entry = tarFile.getEntry(fullVirtualName);
        InputStream is = null;
        try {
            is = tarFile.getInputStream(entry);
            if (is == null) {
                return new SystemSearchLineMatch[0];
            }
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader bufReader = new BufferedReader(isr);
            SystemSearchStringMatchLocator locator = new SystemSearchStringMatchLocator(bufReader, matcher);
            SystemSearchLineMatch[] matches = locator.locateMatches();
            if (matches == null) {
                return new SystemSearchLineMatch[0];
            }
            return matches;
        }
        catch (IOException e) {
            throw new SystemOperationFailedException("org.eclipse.rse.services", (Exception)e);
        }
    }

    public boolean exists() {
        return true;
    }

    public String getCommentFor(String fullVirtualName) {
        return "";
    }

    public long getCompressedSizeFor(String fullVirtualName) {
        return this.getSizeFor(fullVirtualName);
    }

    public String getCompressionMethodFor(String fullVirtualName) {
        return "";
    }

    public String getArchiveComment() {
        return "";
    }

    public void add(File file, String virtualPath, String name, String encoding, ISystemFileTypes registry, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.add(file, virtualPath, name, archiveOperationMonitor);
    }

    public void add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.add(file, virtualPath, name, archiveOperationMonitor);
    }

    public void add(File[] files, String virtualPath, String[] names, String[] sourceEncodings, String[] targetEncodings, boolean[] isTexts, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.add(files, virtualPath, names, archiveOperationMonitor);
    }

    public void extractVirtualDirectory(String dir, File destinationParent, File destination, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualDirectory(dir, destinationParent, destination, archiveOperationMonitor);
    }

    public void extractVirtualDirectory(String dir, File destinationParent, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualDirectory(dir, destinationParent, archiveOperationMonitor);
    }

    public void extractVirtualFile(String fullVirtualName, File destination, String sourceEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.extractVirtualFile(fullVirtualName, destination, archiveOperationMonitor);
    }

    public String getClassification(String fullVirtualName) throws SystemMessageException {
        fullVirtualName = ArchiveHandlerManager.cleanUpVirtualPath(fullVirtualName);
        String type = "file";
        if (!fullVirtualName.endsWith(".class")) {
            return type;
        }
        TarEntry entry = this.getTarFile().getEntry(fullVirtualName);
        InputStream stream = null;
        BasicClassFileParser parser = null;
        boolean isExecutable = false;
        try {
            stream = this.getTarFile().getInputStream(entry);
            parser = new BasicClassFileParser(stream);
            parser.parse();
            isExecutable = parser.isExecutable();
        }
        catch (IOException iOException) {
            isExecutable = false;
        }
        if (isExecutable && parser != null) {
            type = "executable(java";
            String qualifiedClassName = parser.getQualifiedClassName();
            if (qualifiedClassName != null) {
                type = String.valueOf(type) + ":" + qualifiedClassName;
            }
            type = String.valueOf(type) + ")";
        }
        return type;
    }

    public void add(InputStream stream, String virtualPath, String name, String sourceEncoding, String targetEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        throw new SystemUnsupportedOperationException("org.eclipse.rse.services", "add");
    }

    public void add(File file, String virtualPath, String name, String sourceEncoding, String targetEncoding, ISystemFileTypes typeRegistery, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        this.add(file, virtualPath, name, archiveOperationMonitor);
    }

    public void replace(String fullVirtualName, InputStream stream, String name, String sourceEncoding, String targetEncoding, boolean isText, ISystemOperationMonitor archiveOperationMonitor) throws SystemMessageException {
        throw new SystemUnsupportedOperationException("org.eclipse.rse.services", "replace");
    }

    private static String getFullVirtualName(String virtualPath, String name) {
        String fullVirtualName = null;
        fullVirtualName = virtualPath == null || virtualPath.length() == 0 ? name : String.valueOf(virtualPath) + "/" + name;
        return fullVirtualName;
    }

    private void releaseMutex(int mutexLockStatus) {
        if (1 == mutexLockStatus) {
            this._mutex.release();
        }
    }

    private void setArchiveOperationMonitorStatusDone(ISystemOperationMonitor archiveOperationMonitor) {
        if (archiveOperationMonitor != null && !archiveOperationMonitor.isCancelled()) {
            archiveOperationMonitor.setDone(true);
        }
    }

    protected TarOutputStream getTarOutputStream(File outputFile) throws FileNotFoundException {
        TarOutputStream outStream = new TarOutputStream(new FileOutputStream(outputFile));
        return outStream;
    }

    private class VirtualFileNode {
        private static final int MODE_ALL = 1;
        private static final int MODE_FILES_ONLY = 2;
        private static final int MODE_FOLDERS_ONLY = 3;
        private VirtualChild entry;
        private HashMap map;
        private boolean isDir;

        public VirtualFileNode(VirtualChild entry) {
            this.entry = entry;
            this.isDir = entry.isDirectory;
            this.map = new HashMap();
        }

        public VirtualChild getEntry() {
            return this.entry;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public void addChild(String childName, VirtualFileNode child, boolean replace) {
            if (this.isDir) {
                if (replace) {
                    VirtualFileNode oldChild = this.getChild(childName);
                    if (oldChild != null && oldChild.isDir() && child.isDir()) {
                        Iterator iter = oldChild.getChildrenNames();
                        while (iter.hasNext()) {
                            String name = (String)iter.next();
                            VirtualFileNode grandChild = oldChild.getChild(name);
                            child.addChild(name, grandChild, true);
                        }
                    }
                    this.map.put(childName, child);
                } else {
                    boolean exists = this.childExists(childName);
                    if (!exists) {
                        this.map.put(childName, child);
                    }
                }
            }
        }

        public VirtualFileNode removeChild(String childName) {
            if (this.isDir) {
                return (VirtualFileNode)this.map.remove(childName);
            }
            return null;
        }

        public VirtualFileNode getChild(String childName) {
            if (this.isDir) {
                return (VirtualFileNode)this.map.get(childName);
            }
            return null;
        }

        public VirtualFileNode[] getChildren() {
            return this.getChildren(1);
        }

        public VirtualFileNode[] getChildrenFolders() {
            return this.getChildren(3);
        }

        public VirtualFileNode[] getChildren(int mode) {
            if (this.isDir) {
                if (mode == 1) {
                    int num = this.map.size();
                    VirtualFileNode[] children = new VirtualFileNode[num];
                    this.map.values().toArray(children);
                    return children;
                }
                Vector<VirtualFileNode> v = new Vector<VirtualFileNode>();
                Iterator iter = this.map.values().iterator();
                while (iter.hasNext()) {
                    VirtualFileNode node = (VirtualFileNode)iter.next();
                    boolean isDir = node.isDir();
                    if (mode == 2 && !isDir) {
                        v.add(node);
                        continue;
                    }
                    if (mode != 3 || !isDir) continue;
                    v.add(node);
                }
                VirtualFileNode[] children = new VirtualFileNode[v.size()];
                v.toArray(children);
                return children;
            }
            return new VirtualFileNode[0];
        }

        public boolean childExists(String childName) {
            if (this.isDir) {
                return this.map.containsKey(childName);
            }
            return false;
        }

        public Iterator getChildrenNames() {
            if (this.isDir) {
                return this.map.keySet().iterator();
            }
            return null;
        }
    }

    private class VirtualFileSystem {
        private VirtualFileNode rootNode;

        public VirtualFileSystem(VirtualChild root) {
            this.rootNode = new VirtualFileNode(root);
        }

        public void addEntry(VirtualChild entry) {
            this.addEntry(entry, true);
        }

        public void addEntry(VirtualChild entry, boolean replace) {
            String path = entry.fullName;
            VirtualFileNode parentNode = this.rootNode;
            int idx = path.indexOf("/");
            String name = path;
            String segPath = "";
            while (idx > 0) {
                name = path.substring(0, idx);
                path = path.substring(idx + 1);
                segPath = String.valueOf(segPath) + name + "/";
                boolean exists = parentNode.childExists(name);
                if (!exists) {
                    VirtualChild child = new VirtualChild(SystemTarHandler.this, segPath);
                    child.isDirectory = true;
                    parentNode.addChild(name, new VirtualFileNode(child), true);
                }
                parentNode = parentNode.getChild(name);
                idx = path.indexOf("/");
            }
            parentNode.addChild(path, new VirtualFileNode(entry), replace);
        }

        public VirtualChild removeEntry(VirtualChild entry) {
            return this.removeEntry(entry.fullName);
        }

        public VirtualChild removeEntry(String path) {
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            VirtualFileNode parent = this.getParentNode(path);
            String name = null;
            int idx = path.lastIndexOf(47);
            name = idx == -1 ? path : path.substring(idx + 1);
            VirtualFileNode removedChild = parent.removeChild(name);
            if (removedChild == null) {
                return null;
            }
            return removedChild.getEntry();
        }

        public VirtualChild getEntry(String path) {
            VirtualFileNode node = this.getNode(path);
            if (node == null) {
                return null;
            }
            return node.getEntry();
        }

        public VirtualChild[] getChildren(VirtualChild entry) {
            return this.getChildren(entry.fullName);
        }

        public VirtualChild[] getChildrenFolders(VirtualChild entry) {
            return this.getChildrenFolders(entry.fullName);
        }

        public VirtualChild[] getChildren(String path) {
            VirtualFileNode node = this.getNode(path);
            if (node == null) {
                return new VirtualChild[0];
            }
            VirtualFileNode[] childNodes = node.getChildren();
            VirtualChild[] children = new VirtualChild[childNodes.length];
            int i = 0;
            while (i < children.length) {
                children[i] = childNodes[i].getEntry();
                ++i;
            }
            return children;
        }

        public VirtualChild[] getChildrenFolders(String path) {
            VirtualFileNode node = this.getNode(path);
            VirtualFileNode[] childNodes = node.getChildrenFolders();
            VirtualChild[] children = new VirtualChild[childNodes.length];
            int i = 0;
            while (i < children.length) {
                children[i] = childNodes[i].getEntry();
                ++i;
            }
            return children;
        }

        public VirtualChild getParent(VirtualChild entry) {
            VirtualFileNode node = this.getParentNode(entry.fullName);
            if (node == null) {
                return null;
            }
            return node.getEntry();
        }

        private VirtualFileNode getParentNode(String path) {
            int idx;
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            if ((idx = path.lastIndexOf(47)) == -1) {
                return this.rootNode;
            }
            return this.getNode(path.substring(0, idx));
        }

        private VirtualFileNode getNode(String path) {
            if (path.equals("")) {
                return this.rootNode;
            }
            if (path.charAt(path.length() - 1) == '/') {
                path = path.substring(0, path.length() - 1);
            }
            int idx = 0;
            int jdx = 0;
            VirtualFileNode tempNode = this.rootNode;
            boolean done = false;
            while (true) {
                String tempName;
                if ((jdx = path.indexOf(47, idx)) == -1) {
                    jdx = path.length();
                    done = true;
                }
                if ((tempNode = tempNode.getChild(tempName = path.substring(idx, jdx))) == null) {
                    return null;
                }
                if (done) break;
                idx = jdx + 1;
            }
            return tempNode;
        }
    }
}

