/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import com.google.common.collect.ImmutableList;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public final class Attribute {
    private final Attribute fParent;
    private final @NonNull String fName;
    private final int fQuark;
    private final Map<String, Attribute> fSubAttributes = new LinkedHashMap<String, Attribute>();
    private int curDepth;

    public Attribute(Attribute parent, @NonNull String name, int quark) {
        this.fParent = parent;
        this.fQuark = quark;
        this.fName = name;
    }

    public int getQuark() {
        return this.fQuark;
    }

    public @NonNull String getName() {
        return this.fName;
    }

    public Iterable<Attribute> getSubAttributes() {
        return ImmutableList.copyOf(this.fSubAttributes.values());
    }

    public int getSubAttributeQuark(String ... path) {
        return this.getSubAttributeQuark(path, 0);
    }

    public Attribute getSubAttributeNode(String ... path) {
        return this.getSubAttributeNode(path, 0);
    }

    private int getSubAttributeQuark(String[] path, int index) {
        Attribute targetNode = this.getSubAttributeNode(path, index);
        return targetNode != null ? targetNode.getQuark() : -2;
    }

    public Attribute getParentAttribute() {
        return this.fParent;
    }

    public int getParentAttributeQuark() {
        return this.fParent.getQuark();
    }

    public void addSubAttribute(Attribute newSubAttribute) {
        if (newSubAttribute == null) {
            throw new IllegalArgumentException();
        }
        this.fSubAttributes.put(newSubAttribute.getName(), newSubAttribute);
    }

    private Attribute getSubAttributeNode(String[] path, int index) {
        Attribute nextNode = this.fSubAttributes.get(path[index]);
        if (nextNode == null) {
            return null;
        }
        if (index == path.length - 1) {
            return nextNode;
        }
        return nextNode.getSubAttributeNode(path, index + 1);
    }

    public @NonNull String @NonNull [] getFullAttribute() {
        LinkedList<String> list = new LinkedList<String>();
        Attribute curNode = this;
        while (curNode.fParent != null) {
            list.addFirst(curNode.getName());
            curNode = curNode.fParent;
        }
        return list.toArray(new String[list.size()]);
    }

    public @NonNull String getFullAttributeName() {
        return Objects.requireNonNull(String.join((CharSequence)"/", this.getFullAttribute()));
    }

    public String toString() {
        return String.valueOf(this.getFullAttributeName()) + " (" + this.fQuark + ')';
    }

    private void attributeNodeToString(PrintWriter writer, Attribute currentNode) {
        writer.println(String.valueOf(currentNode.getName()) + " (" + currentNode.fQuark + ')');
        ++this.curDepth;
        for (Attribute nextNode : currentNode.getSubAttributes()) {
            if (nextNode == null) continue;
            int j = 0;
            while (j < this.curDepth - 1) {
                writer.print("  ");
                ++j;
            }
            writer.print("  ");
            this.attributeNodeToString(writer, nextNode);
        }
        --this.curDepth;
    }

    public void debugPrint(PrintWriter writer) {
        writer.println("------------------------------");
        writer.println("Attribute tree: (quark)\n");
        this.curDepth = 0;
        this.attributeNodeToString(writer, this);
        writer.print('\n');
    }
}

