/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.scripting.ui.tracemarker;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.tracecompass.incubator.internal.scripting.ui.tracemarker.TraceMarker;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.signal.TmfMarkerEventSourceUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.trace.AbstractTmfTraceAdapterFactory;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.IMarkerEventSource;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.MarkerEvent;

@NonNullByDefault
public class ScriptingMarkerSource
implements IMarkerEventSource,
AbstractTmfTraceAdapterFactory.IDisposableAdapter {
    private static final int ALPHA = 70;
    private Multimap<String, IMarkerEvent> fTraceMarkerEventMap = HashMultimap.create();
    private final ITmfTrace fTrace;

    public ScriptingMarkerSource(ITmfTrace trace) {
        this.fTrace = trace;
        TmfSignalManager.register((Object)this);
    }

    public void initializeAdapterMarkersLists() {
        this.fTraceMarkerEventMap.clear();
    }

    public void configureMarker(TraceMarker traceMarker) {
        RGBAColor traceMarkerColor = traceMarker.getRGBAColor();
        RGBA markerEventColor = new RGBA((int)traceMarkerColor.getRed(), (int)traceMarkerColor.getGreen(), (int)traceMarkerColor.getBlue(), 70);
        String category = traceMarker.getCategory();
        String label = traceMarker.getLabel();
        long start = traceMarker.getStartTime();
        long duration = traceMarker.getDuration();
        MarkerEvent traceMarkerEvent = new MarkerEvent(null, start, duration, category, markerEventColor, label, true);
        if (category != null) {
            this.fTraceMarkerEventMap.put((Object)category, (Object)traceMarkerEvent);
        }
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfMarkerEventSourceUpdatedSignal((Object)this));
    }

    public Multimap<String, IMarkerEvent> getMarkerEventMap() {
        return this.fTraceMarkerEventMap;
    }

    public List<String> getMarkerCategories() {
        ArrayList<String> markerCategories = new ArrayList<String>();
        markerCategories.addAll(this.fTraceMarkerEventMap.keySet());
        return markerCategories;
    }

    public List<IMarkerEvent> getMarkerEvents() {
        ArrayList<IMarkerEvent> markerEvents = new ArrayList<IMarkerEvent>();
        markerEvents.addAll(this.fTraceMarkerEventMap.values());
        return markerEvents;
    }

    public @NonNull List<@NonNull IMarkerEvent> getMarkerList(@NonNull String category, long startTime, long endTime, long resolution, @NonNull IProgressMonitor monitor) {
        ArrayList<IMarkerEvent> markerEventsInCategory = new ArrayList<IMarkerEvent>();
        markerEventsInCategory.addAll(this.fTraceMarkerEventMap.get((Object)category));
        if (markerEventsInCategory.isEmpty()) {
            return markerEventsInCategory;
        }
        ArrayList<IMarkerEvent> markerEvents = new ArrayList<IMarkerEvent>();
        long distanceFromStart = Long.MAX_VALUE;
        long distanceFromEnd = Long.MAX_VALUE;
        IMarkerEvent nearestNextMarkerEvent = null;
        IMarkerEvent nearestPreviousMarkerEvent = null;
        for (IMarkerEvent markerEvent : markerEventsInCategory) {
            long distance;
            long markerEndTime = markerEvent.getTime() + markerEvent.getDuration();
            if (markerEvent.getTime() >= startTime && markerEndTime <= endTime) {
                markerEvents.add(markerEvent);
            }
            if (markerEvent.getTime() > endTime && (distance = markerEvent.getTime() - endTime) < distanceFromEnd) {
                distanceFromEnd = distance;
                nearestNextMarkerEvent = markerEvent;
            }
            if (markerEndTime >= startTime || (distance = startTime - markerEndTime) >= distanceFromStart) continue;
            distanceFromStart = distance;
            nearestPreviousMarkerEvent = markerEvent;
        }
        if (nearestNextMarkerEvent != null) {
            markerEvents.add(nearestNextMarkerEvent);
        }
        if (nearestPreviousMarkerEvent != null) {
            markerEvents.add(nearestPreviousMarkerEvent);
        }
        return markerEvents;
    }

    public void dispose() {
        TmfSignalManager.deregister((Object)this);
    }

    public ITmfTrace getTrace() {
        return this.fTrace;
    }
}

