/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.settings.model.extension.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CFolderData;
import org.eclipse.cdt.core.settings.model.extension.CLanguageData;
import org.eclipse.cdt.core.settings.model.extension.impl.CDataFactory;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.core.runtime.IPath;

public class CDefaultFolderData
extends CFolderData {
    protected IPath fPath;
    protected List<CLanguageData> fLanguageDatas = new ArrayList<CLanguageData>();
    protected String fName;
    protected String fId;
    protected CConfigurationData fCfg;
    private CDataFactory fFactory;
    protected boolean fIsModified;

    public CDefaultFolderData(CConfigurationData cfg, CDataFactory factory) {
        this.fCfg = cfg;
        if (factory == null) {
            factory = new CDataFactory();
        }
        this.fFactory = factory;
    }

    public CDefaultFolderData(String id, IPath path, CConfigurationData cfg, CDataFactory factory) {
        this(cfg, factory);
        this.fId = id;
        this.fName = path.toString();
        this.fPath = path;
    }

    public CDefaultFolderData(String id, IPath path, CFolderData base, CConfigurationData cfg, CDataFactory factory, boolean clone) {
        this(id, path, cfg, factory);
        this.copyDataFrom(base, clone);
    }

    protected void copyDataFrom(CFolderData base, boolean clone) {
        if (base != null) {
            CLanguageData[] lDatas;
            CLanguageData[] cLanguageDataArray = lDatas = base.getLanguageDatas();
            int n = lDatas.length;
            int n2 = 0;
            while (n2 < n) {
                CLanguageData lData = cLanguageDataArray[n2];
                this.fLanguageDatas.add(this.copyLanguageData(lData, clone));
                ++n2;
            }
        }
    }

    protected CLanguageData copyLanguageData(CLanguageData base, boolean clone) {
        return this.fFactory.createLanguageData(this.fCfg, this, base, null, clone);
    }

    @Override
    public CLanguageData[] getLanguageDatas() {
        return this.fLanguageDatas.toArray(new CLanguageData[this.fLanguageDatas.size()]);
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public void setPath(IPath path) {
        if (CDataUtil.objectsEqual(path, this.fPath)) {
            return;
        }
        this.fPath = path;
        this.setModified(true);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public boolean isValid() {
        return this.getId() != null;
    }

    @Override
    public CLanguageData createLanguageDataForContentTypes(String languageId, String[] typesIds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CLanguageData createLanguageDataForExtensions(String languageId, String[] extensions) {
        throw new UnsupportedOperationException();
    }

    public boolean isModified() {
        CLanguageData[] lDatas;
        if (this.fIsModified) {
            return true;
        }
        CLanguageData[] cLanguageDataArray = lDatas = this.getLanguageDatas();
        int n = lDatas.length;
        int n2 = 0;
        while (n2 < n) {
            CLanguageData lData = cLanguageDataArray[n2];
            if (this.fFactory.isModified(lData)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setModified(boolean modified) {
        this.fIsModified = modified;
        if (!modified) {
            CLanguageData[] lDatas;
            CLanguageData[] cLanguageDataArray = lDatas = this.getLanguageDatas();
            int n = lDatas.length;
            int n2 = 0;
            while (n2 < n) {
                CLanguageData lData = cLanguageDataArray[n2];
                this.fFactory.setModified(lData, false);
                ++n2;
            }
        }
    }

    @Override
    public boolean hasCustomSettings() {
        return false;
    }
}

