/*
 * Copyright (c) 2015 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Collections;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedIntCollection;
import org.eclipse.collections.impl.factory.primitive.IntLists;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseIntIterable;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;

/**
 * A synchronized view of a {@link MutableIntList}. It is imperative that the user manually synchronize on the collection when iterating over it using the
 * {@link IntIterator}, as per {@link Collections#synchronizedCollection(Collection)}.
 * <p>
 * This file was automatically generated from template file synchronizedPrimitiveList.stg.
 *
 * @see MutableIntList#asSynchronized()
 * @see MutableList#asSynchronized()
 * @since 3.1.
 */
@ThreadSafe
public final class SynchronizedIntList
        extends AbstractSynchronizedIntCollection
        implements MutableIntList
{
    private static final long serialVersionUID = 1L;

    SynchronizedIntList(MutableIntList list)
    {
        super(list);
    }

    SynchronizedIntList(MutableIntList list, Object newLock)
    {
        super(list, newLock);
    }

    @GuardedBy("getLock()")
    private MutableIntList getMutableIntList()
    {
        return (MutableIntList) this.getIntCollection();
    }

    public int get(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().get(index);
        }
    }

    public int getFirst()
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().getFirst();
        }
    }

    public int getLast()
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().getLast();
        }
    }

    public int indexOf(int value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().indexOf(value);
        }
    }

    public int lastIndexOf(int value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().lastIndexOf(value);
        }
    }

    public void addAtIndex(int index, int element)
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().addAtIndex(index, element);
        }
    }

    public boolean addAllAtIndex(int index, int... source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().addAllAtIndex(index, source);
        }
    }

    public boolean addAllAtIndex(int index, IntIterable source)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().addAllAtIndex(index, source);
        }
    }

    public int removeAtIndex(int index)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().removeAtIndex(index);
        }
    }

    public int set(int index, int element)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().set(index, element);
        }
    }

    @Override
    public SynchronizedIntList with(int element)
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().add(element);
        }
        return this;
    }

    @Override
    public SynchronizedIntList without(int element)
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().remove(element);
        }
        return this;
    }

    @Override
    public SynchronizedIntList withAll(IntIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().addAll(elements.toArray());
        }
        return this;
    }

    @Override
    public SynchronizedIntList withoutAll(IntIterable elements)
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().removeAll(elements);
        }
        return this;
    }

    @Override
    public MutableIntList select(IntPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().select(predicate);
        }
    }

    @Override
    public MutableIntList reject(IntPredicate predicate)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().reject(predicate);
        }
    }

    @Override
    public <V> MutableList<V> collect(IntToObjectFunction<? extends V> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().collect(function);
        }
    }

    public MutableIntList sortThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().sortThis();
        }
        return this;
    }

    public int binarySearch(int value)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().binarySearch(value);
        }
    }

    public long dotProduct(IntList list)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().dotProduct(list);
        }
    }

    @Override
    public boolean equals(Object otherList)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().equals(otherList);
        }
    }

    @Override
    public int hashCode()
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().hashCode();
        }
    }

    @Override
    public LazyIntIterable asLazy()
    {
        synchronized (this.getLock())
        {
            return new LazyIntIterableAdapter(this);
        }
    }

    @Override
    public MutableIntList asUnmodifiable()
    {
        return new UnmodifiableIntList(this);
    }

    @Override
    public MutableIntList asSynchronized()
    {
        return this;
    }

    @Override
    public ImmutableIntList toImmutable()
    {
        synchronized (this.getLock())
        {
            int size = this.size();
            if (size == 0)
            {
                return IntLists.immutable.with();
            }
            if (size == 1)
            {
                return IntLists.immutable.with(this.getFirst());
            }
            return IntLists.immutable.with(this.toArray());
        }
    }

    public MutableIntList reverseThis()
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().reverseThis();
        }
        return this;
    }

    public MutableIntList toReversed()
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().toReversed();
        }
    }

    public LazyIntIterable asReversed()
    {
        return ReverseIntIterable.adapt(this);
    }

    public void forEachWithIndex(IntIntProcedure procedure)
    {
        synchronized (this.getLock())
        {
            this.getMutableIntList().forEachWithIndex(procedure);
        }
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectIntIntToObjectFunction<? super T, ? extends T> function)
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /**
     * @since 6.0.
     */
    public MutableIntList distinct()
    {
        synchronized (this.getLock())
        {
            return this.getMutableIntList().distinct();
        }
    }

    public MutableIntList subList(int fromIndex, int toIndex)
    {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}
