/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.parse.standard;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.virgo.util.osgi.manifest.parse.HeaderDeclaration;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderVisitor;
import org.eclipse.virgo.util.osgi.manifest.parse.standard.StandardHeaderDeclaration;

public class StandardHeaderVisitor
implements HeaderVisitor {
    private List<HeaderDeclaration> headerDeclarations;
    private List<String> names;
    private Map<String, String> directives;
    private Map<String, String> attributes;

    @Override
    public void visitAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    @Override
    public void visitDirective(String name, String value) {
        this.directives.put(name, value);
    }

    @Override
    public void visitSymbolicName(String name) {
        this.names.add(name);
    }

    @Override
    public void visitUniqueName(String name) {
        this.names.add(name);
    }

    @Override
    public void visitWildcardName(String name) {
        this.names.add(name);
    }

    @Override
    public void endvisit() {
    }

    @Override
    public void clauseEnded() {
        this.headerDeclarations.add(new StandardHeaderDeclaration(this.names, this.attributes, this.directives));
        this.names.clear();
        this.directives.clear();
        this.attributes.clear();
    }

    @Override
    public HeaderDeclaration getFirstHeaderDeclaration() {
        if (this.headerDeclarations.size() == 0) {
            return null;
        }
        return this.headerDeclarations.get(0);
    }

    @Override
    public List<HeaderDeclaration> getHeaderDeclarations() {
        return this.headerDeclarations;
    }

    @Override
    public void initialize() {
        this.headerDeclarations = new ArrayList<HeaderDeclaration>();
        this.names = new ArrayList<String>();
        this.directives = new HashMap<String, String>();
        this.attributes = new HashMap<String, String>();
    }
}

