/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import org.apache.felix.eventadmin.impl.handler.BlacklistingHandlerTasks;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class HandlerTaskImpl
implements HandlerTask {
    private final ServiceReference m_eventHandlerRef;
    private final Event m_event;
    private final BlacklistingHandlerTasks m_handlerTasks;

    public HandlerTaskImpl(ServiceReference eventHandlerRef, Event event, BlacklistingHandlerTasks handlerTasks) {
        this.m_eventHandlerRef = eventHandlerRef;
        this.m_event = event;
        this.m_handlerTasks = handlerTasks;
    }

    public void execute() {
        EventHandler handler = this.m_handlerTasks.getEventHandler(this.m_eventHandlerRef);
        try {
            handler.handleEvent(this.m_event);
        }
        catch (Exception e) {
            LogWrapper.getLogger().log(this.m_eventHandlerRef, 2, "Exception during event dispatch [" + this.m_event + " | " + this.m_eventHandlerRef + " | Bundle(" + this.m_eventHandlerRef.getBundle() + ")]", e);
        }
        this.m_handlerTasks.ungetEventHandler(handler, this.m_eventHandlerRef);
    }

    public void blackListHandler() {
        this.m_handlerTasks.blackList(this.m_eventHandlerRef);
    }
}

