/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.impl.config;

import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.impl.config.DictionaryUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationEvent;
import org.osgi.service.cm.ConfigurationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationAdminConfigurationProvider
implements ConfigurationProvider,
ConfigurationListener {
    private static final String CONFIG_ADMIN_PID = "org.eclipse.virgo.medic";
    private static final String CONFIG_ADMIN_SERVICE_NAME = "org.osgi.service.cm.ConfigurationAdmin";
    private static final Dictionary<Object, Object> DEFAULT_CONFIG = ConfigurationAdminConfigurationProvider.createDefaultConfiguration();
    private final BundleContext bundleContext;
    private volatile Dictionary configuration = DEFAULT_CONFIG;

    public ConfigurationAdminConfigurationProvider(BundleContext context) {
        this.bundleContext = context;
        this.initialisePropertiesFromConfigurationAdmin();
    }

    @Override
    public Dictionary<?, ?> getConfiguration() {
        return this.configuration;
    }

    private void initialisePropertiesFromConfigurationAdmin() {
        ServiceReference configAdminReference = this.bundleContext.getServiceReference(CONFIG_ADMIN_SERVICE_NAME);
        if (configAdminReference != null) {
            this.bundleContext.registerService(ConfigurationListener.class.getName(), (Object)new MedicConfigurationListener(), null);
            this.setPropertiesFromConfigurationAdmin(configAdminReference);
        }
    }

    private void setPropertiesFromConfigurationAdmin(ServiceReference configAdminReference) {
        ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.bundleContext.getService(configAdminReference);
        if (configurationAdmin != null) {
            try {
                Configuration configuration = configurationAdmin.getConfiguration(CONFIG_ADMIN_PID, null);
                Dictionary<Object, Object> properties = configuration.getProperties();
                if (properties == null) {
                    properties = DEFAULT_CONFIG;
                } else {
                    DictionaryUtils.merge(properties, DEFAULT_CONFIG);
                }
                this.configuration = properties;
            }
            catch (IOException iOException) {}
        } else {
            this.configuration = DEFAULT_CONFIG;
        }
    }

    private static Dictionary<Object, Object> createDefaultConfiguration() {
        Hashtable<Object, Object> configuration = new Hashtable<Object, Object>();
        ((Dictionary)configuration).put("dump.root.directory", ".");
        ((Dictionary)configuration).put("log.wrapSysOut", Boolean.toString(Boolean.TRUE));
        ((Dictionary)configuration).put("log.wrapSysErr", Boolean.toString(Boolean.TRUE));
        return configuration;
    }

    public void configurationEvent(ConfigurationEvent event) {
        if (event.getType() == 1 && CONFIG_ADMIN_PID.equals(event.getPid())) {
            this.setPropertiesFromConfigurationAdmin(event.getReference());
        }
    }

    private final class MedicConfigurationListener
    implements ConfigurationListener {
        private MedicConfigurationListener() {
        }

        public void configurationEvent(ConfigurationEvent configEvent) {
            if (ConfigurationAdminConfigurationProvider.CONFIG_ADMIN_PID.equals(configEvent.getPid()) && configEvent.getType() == 1) {
                ConfigurationAdminConfigurationProvider.this.setPropertiesFromConfigurationAdmin(configEvent.getReference());
            }
        }
    }
}

