/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgicommand.internal;

import java.io.IOException;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.virgo.kernel.shell.CommandExecutor;
import org.eclipse.virgo.kernel.shell.LinePrinter;

public final class OsgiKernelShellCommand
implements CommandProvider {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    CommandExecutor commandExecutor;

    public OsgiKernelShellCommand(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public void _vsh(CommandInterpreter commandInterpreter) {
        String commandLine = OsgiKernelShellCommand.getCommandLine(commandInterpreter);
        CommandInterpreterLinePrinter linePrinter = new CommandInterpreterLinePrinter(commandInterpreter);
        try {
            boolean continueCommands = this.commandExecutor.execute(commandLine, (LinePrinter)linePrinter);
            if (!continueCommands) {
                commandInterpreter.println((Object)("vsh: command '" + commandLine + "' requested exit"));
            }
        }
        catch (IOException e) {
            commandInterpreter.println((Object)("vsh: command '" + commandLine + "' threw an exception..."));
            commandInterpreter.printStackTrace((Throwable)e);
        }
    }

    private static String getCommandLine(CommandInterpreter commandInterpreter) {
        StringBuilder sb = new StringBuilder();
        String arg = commandInterpreter.nextArgument();
        while (arg != null) {
            sb.append(arg).append(" ");
            arg = commandInterpreter.nextArgument();
        }
        return sb.toString();
    }

    public String getHelp() {
        return "\tvsh - Virgo shell commands; 'vsh help' to list available commands" + LINE_SEPARATOR;
    }

    private static final class CommandInterpreterLinePrinter
    implements LinePrinter {
        private final CommandInterpreter commandInterpreter;

        public CommandInterpreterLinePrinter(CommandInterpreter commandInterpreter) {
            this.commandInterpreter = commandInterpreter;
        }

        public LinePrinter println(String line) throws IOException {
            this.commandInterpreter.println((Object)line);
            return this;
        }

        public LinePrinter println() throws IOException {
            this.commandInterpreter.println();
            return this;
        }
    }
}

