/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CompoundExpression
extends AbstractExpression {
    private boolean hasSpaceAfterIdentifier;
    private String identifier;
    private AbstractExpression leftExpression;
    private AbstractExpression rightExpression;

    protected CompoundExpression(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getLeftExpression().accept(visitor);
        this.getRightExpression().accept(visitor);
    }

    @Override
    protected final void addChildrenTo(Collection<Expression> children) {
        children.add(this.getLeftExpression());
        children.add(this.getRightExpression());
    }

    @Override
    protected final void addOrderedChildrenTo(List<Expression> children) {
        if (this.leftExpression != null) {
            children.add(this.leftExpression);
        }
        if (this.hasLeftExpression()) {
            children.add(this.buildStringExpression(' '));
        }
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpaceAfterIdentifier) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.rightExpression != null) {
            children.add(this.rightExpression);
        }
    }

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final Expression getLeftExpression() {
        if (this.leftExpression == null) {
            this.leftExpression = this.buildNullExpression();
        }
        return this.leftExpression;
    }

    public final Expression getRightExpression() {
        if (this.rightExpression == null) {
            this.rightExpression = this.buildNullExpression();
        }
        return this.rightExpression;
    }

    public final boolean hasLeftExpression() {
        return this.leftExpression != null && !this.leftExpression.isNull();
    }

    public final boolean hasRightExpression() {
        return this.rightExpression != null && !this.rightExpression.isNull();
    }

    public final boolean hasSpaceAfterIdentifier() {
        return this.hasSpaceAfterIdentifier;
    }

    @Override
    protected final void parse(WordParser wordParser, boolean tolerant) {
        String identifier = this.parseIdentifier(wordParser);
        this.identifier = wordParser.moveForward(identifier);
        this.setText(identifier);
        this.hasSpaceAfterIdentifier = wordParser.skipLeadingWhitespace() > 0;
        this.rightExpression = this.parse(wordParser, this.rightExpressionBNF(), tolerant);
        if (!this.hasSpaceAfterIdentifier && this.hasRightExpression()) {
            this.hasSpaceAfterIdentifier = true;
        }
    }

    protected abstract String parseIdentifier(WordParser var1);

    public abstract String rightExpressionBNF();

    protected final void setLeftExpression(AbstractExpression leftExpression) {
        this.leftExpression = leftExpression;
        if (leftExpression != null) {
            this.leftExpression.setParent(this);
        }
    }

    protected final void setRightExpression(AbstractExpression rightExpression) {
        this.rightExpression = rightExpression;
        if (rightExpression != null) {
            this.rightExpression.setParent(this);
        }
    }

    @Override
    protected final void toParsedText(StringBuilder writer, boolean actual) {
        if (this.leftExpression != null) {
            this.leftExpression.toParsedText(writer, actual);
        }
        if (this.hasLeftExpression() && writer.charAt(writer.length() - 1) != ' ') {
            writer.append(' ');
        }
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpaceAfterIdentifier) {
            writer.append(' ');
        }
        if (this.rightExpression != null) {
            this.rightExpression.toParsedText(writer, actual);
        }
    }
}

