/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.AsciiStream;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClobLocatorOutputStream;
import org.apache.derby.client.am.ClobLocatorWriter;
import org.apache.derby.client.am.ClobOutputStream;
import org.apache.derby.client.am.ClobWriter;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorInputStream;
import org.apache.derby.client.am.UpdateSensitiveClobLocatorReader;
import org.apache.derby.client.net.EncodedInputStream;

public class Clob
extends Lob
implements java.sql.Clob {
    protected String string_ = null;
    protected InputStream asciiStream_ = null;
    protected InputStream unicodeStream_ = null;
    protected Reader characterStream_ = null;
    protected byte[] utf8String_;
    protected String encoding_ = "UNICODE";

    public Clob(Agent agent, String string) {
        this(agent, false);
        this.string_ = string;
        this.setSqlLength(this.string_.length());
        this.dataType_ |= 2;
    }

    public Clob(Agent agent, byte[] byArray, String string, int n) throws SqlException {
        this(agent, false);
        try {
            if (string == null) {
                throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.2"));
            }
            this.string_ = new String(byArray, n, byArray.length - n, string);
            this.setSqlLength(this.string_.length());
            this.dataType_ |= 2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"byte[]", (Object)(string + " String"), (Throwable)unsupportedEncodingException);
        }
    }

    public Clob(Agent agent, InputStream inputStream, String string, int n) throws SqlException {
        this(agent, false);
        this.setSqlLength(n);
        if (string.equals("ISO-8859-1")) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else if (string.equals("UTF-8")) {
            this.unicodeStream_ = inputStream;
            this.dataType_ |= 8;
        } else if (string.equals("UnicodeBigUnmarked")) {
            try {
                this.characterStream_ = new InputStreamReader(inputStream, "UnicodeBigUnmarked");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"UnicodeBigUnmarked", (Object)"InputStreamReader", (Throwable)unsupportedEncodingException);
            }
            this.dataType_ |= 0x10;
            this.setSqlLength(n / 2);
        }
    }

    public Clob(Agent agent, InputStream inputStream, String string) throws SqlException {
        this(agent, Clob.isLayerBStreamingPossible(agent));
        if (string.equals("ISO-8859-1")) {
            this.asciiStream_ = inputStream;
            this.dataType_ |= 4;
        } else {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)(string + " InputStream"), "String/Clob");
        }
    }

    public Clob(Agent agent, Reader reader, int n) {
        this(agent, false);
        this.setSqlLength(n);
        this.characterStream_ = reader;
        this.dataType_ |= 0x10;
    }

    public Clob(Agent agent, int n) {
        super(agent, false);
        this.locator_ = n;
        this.dataType_ |= 0x80;
    }

    public Clob(Agent agent, Reader reader) {
        this(agent, Clob.isLayerBStreamingPossible(agent));
        this.unicodeStream_ = EncodedInputStream.createUTF8Stream(reader);
        this.dataType_ |= 8;
    }

    private Clob(Agent agent, boolean bl) {
        super(agent, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long length() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "length");
                }
                long l = super.sqlLength();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "length", l);
                }
                return l;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSubString(long l, int n) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                String string = null;
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getSubString", (int)l, n);
                }
                if (l <= 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                if (n < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer(n));
                }
                if (l > this.sqlLength() + 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(l));
                }
                string = this.getSubStringX(l, n);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getSubString", string);
                }
                return string;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private String getSubStringX(long l, int n) throws SqlException {
        this.checkForClosedConnection();
        long l2 = Math.min(this.sqlLength() - l + 1L, (long)n);
        if (this.isLocator()) {
            return this.agent_.connection_.locatorProcedureCall().clobGetSubString(this.locator_, l, (int)l2);
        }
        return this.string_.substring((int)l - 1, (int)(l - 1L + l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCharacterStream");
                }
                Reader reader = this.getCharacterStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
                }
                return reader;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    Reader getCharacterStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this);
        }
        if (this.isCharacterStream()) {
            return this.characterStream_;
        }
        return new StringReader(this.string_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getAsciiStream() throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getAsciiStream");
                }
                InputStream inputStream = this.getAsciiStreamX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getAsciiStream", inputStream);
                }
                return inputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    InputStream getAsciiStreamX() throws SqlException {
        this.checkForClosedConnection();
        if (this.isAsciiStream()) {
            return this.asciiStream_;
        }
        if (this.isLocator()) {
            return new UpdateSensitiveClobLocatorInputStream(this.agent_.connection_, this);
        }
        return new AsciiStream(this.string_, new StringReader(this.string_));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(String string, long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "position(String, long)", (Object)string, l);
                }
                if (string == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                long l2 = this.positionX(string, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(String, long)", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(String string, long l) throws SqlException {
        this.checkForClosedConnection();
        long l2 = -1L;
        if (l <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Long(l), (Object)"start", "Clob.position()");
        }
        if (this.isLocator()) {
            l2 = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromString(this.locator_, string, l);
        } else {
            l2 = this.string_.indexOf(string, (int)l - 1);
            if (l2 != -1L) {
                ++l2;
            }
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long position(java.sql.Clob clob, long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "position(Clob, long)", (Object)clob, l);
                }
                if (l < 1L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
                }
                if (clob == null) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
                }
                long l2 = this.positionX(clob, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "position(Clob, long)", l2);
                }
                return l2;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    private long positionX(java.sql.Clob clob, long l) throws SqlException {
        long l2;
        this.checkForClosedConnection();
        if (l <= 0L) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Long(l), (Object)"start", "Clob.position()");
        }
        try {
            if (clob.length() > this.sqlLength()) {
                return -1L;
            }
            if (this.isLocator()) {
                l2 = this.agent_.connection_.locatorProcedureCall().clobGetPositionFromLocator(this.locator_, ((Clob)clob).getLocator(), l);
            } else {
                l2 = this.string_.indexOf(clob.getSubString(1L, (int)clob.length()), (int)l - 1);
                if (l2 != -1L) {
                    ++l2;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long l, String string) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setString", (int)l, (Object)string);
                }
                int n = this.setStringX(l, string, 0, string.length());
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", n);
                }
                return n;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setString", (int)l, (Object)string, n, n2);
                }
                int n3 = this.setStringX(l, string, n, n2);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setString", n3);
                }
                return n3;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    public int setStringX(long l, String string, int n, int n2) throws SqlException {
        if ((int)l <= 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ070.S"), new Long(l));
        }
        if (l - 1L > this.sqlLength()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ076.S"), new Long(l));
        }
        if (string == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ072.S"));
        }
        if (string.length() == 0) {
            return 0;
        }
        if (n < 0 || n >= string.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ078.S"), new Integer(n));
        }
        if (n2 < 0) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Integer(n2));
        }
        if (n + n2 > string.length()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22011.S.1"), (Object)new Integer(n), (Object)new Integer(n2), string);
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        n3 = Math.min(string.length() - n, n2);
        if (this.isLocator()) {
            this.agent_.connection_.locatorProcedureCall().clobSetString(this.locator_, l, n3, string.substring(n, n + n3));
            if (l + (long)n3 - 1L > this.sqlLength()) {
                this.setSqlLength(l + (long)n3 - 1L);
            }
            this.incrementUpdateCount();
        } else {
            String string2 = this.string_.substring(0, (int)l - 1);
            this.string_ = string2.concat(string.substring(n, n + n3));
            this.asciiStream_ = new StringBufferInputStream(this.string_);
            this.unicodeStream_ = new StringBufferInputStream(this.string_);
            this.characterStream_ = new StringReader(this.string_);
            this.setSqlLength(this.string_.length());
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream setAsciiStream(long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setAsciiStream", (int)l);
                }
                OutputStream outputStream = null;
                outputStream = this.isLocator() ? new ClobLocatorOutputStream(this.agent_.connection_, this, l) : new ClobOutputStream(this, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setAsciiStream", outputStream);
                }
                return outputStream;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer setCharacterStream(long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setCharacterStream", (int)l);
                }
                Writer writer = null;
                writer = this.isLocator() ? new ClobLocatorWriter(this.agent_.connection_, this, l) : new ClobWriter(this, l);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "setCharacterStream", writer);
                }
                return writer;
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate(long l) throws SQLException {
        this.checkValidity();
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, " truncate", (int)l);
                }
                if (l < 0L) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ071.S"), new Long(l));
                }
                if (l > this.sqlLength()) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ079.S"), new Long(l));
                }
                if (l == this.sqlLength()) {
                    return;
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobTruncate(this.locator_, l);
                    this.incrementUpdateCount();
                    this.setSqlLength(l);
                } else {
                    String string;
                    this.string_ = string = this.string_.substring(0, (int)l);
                    this.asciiStream_ = new StringBufferInputStream(this.string_);
                    this.unicodeStream_ = new StringBufferInputStream(this.string_);
                    this.characterStream_ = new StringReader(this.string_);
                    this.setSqlLength(this.string_.length());
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free() throws SQLException {
        if (!this.isValid_) {
            return;
        }
        this.isValid_ = false;
        try {
            Connection connection = this.agent_.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "free");
                }
                if (this.isLocator()) {
                    this.agent_.connection_.locatorProcedureCall().clobReleaseLocator(this.locator_);
                }
            }
        }
        catch (SqlException sqlException) {
            throw sqlException.getSQLException();
        }
        if (this.isString()) {
            this.string_ = null;
            this.utf8String_ = null;
        }
        if (this.isAsciiStream()) {
            try {
                this.asciiStream_.close();
            }
            catch (IOException iOException) {
                throw new SqlException(null, new ClientMessageId("XJ214.S")).getSQLException();
            }
        }
        if (this.isUnicodeStream()) {
            try {
                this.unicodeStream_.close();
            }
            catch (IOException iOException) {
                throw new SqlException(null, new ClientMessageId("XJ214.S")).getSQLException();
            }
        }
        if (this.isCharacterStream()) {
            try {
                this.characterStream_.close();
            }
            catch (IOException iOException) {
                throw new SqlException(null, new ClientMessageId("XJ214.S")).getSQLException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValidity();
        Connection connection = this.agent_.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry((Object)this, "getCharacterStream", (int)l, l2);
            }
            this.checkPosAndLength(l, l2);
            Reader reader = null;
            if (this.isLocator()) {
                try {
                    reader = new UpdateSensitiveClobLocatorReader(this.agent_.connection_, this, l, l2);
                }
                catch (SqlException sqlException) {
                    throw sqlException.getSQLException();
                }
            }
            String string = null;
            try {
                string = this.getSubStringX(l, (int)l2);
            }
            catch (SqlException sqlException) {
                throw sqlException.getSQLException();
            }
            reader = new StringReader(string);
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getCharacterStream", reader);
            }
            return reader;
        }
    }

    public boolean isString() {
        return (this.dataType_ & 2) == 2;
    }

    public boolean isAsciiStream() {
        return (this.dataType_ & 4) == 4;
    }

    public boolean isCharacterStream() {
        return (this.dataType_ & 0x10) == 16;
    }

    public boolean isUnicodeStream() {
        return (this.dataType_ & 8) == 8;
    }

    public InputStream getUnicodeStream() {
        return this.unicodeStream_;
    }

    public String getString() {
        return this.string_;
    }

    public byte[] getUtf8String() {
        return this.utf8String_;
    }

    public int getUTF8Length() throws SqlException {
        if (this.utf8String_ != null) {
            return this.utf8String_.length;
        }
        try {
            this.utf8String_ = this.string_.getBytes("UTF-8");
            return this.utf8String_.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"String", (Object)"UTF8 byte[]", (Throwable)unsupportedEncodingException);
        }
    }

    protected Clob createClobWrapper(java.sql.Clob clob) throws SqlException {
        Reader reader;
        long l;
        try {
            l = clob.length();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
        if (l > Integer.MAX_VALUE) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ093.S"), (Object)new Long(l), new Integer(Integer.MAX_VALUE));
        }
        try {
            reader = clob.getCharacterStream();
        }
        catch (SQLException sQLException) {
            throw SqlException.javaException(this.agent_.logWriter_, sQLException);
        }
        return new Clob(this.agent_, reader, (int)l);
    }

    public void convertFromAsciiToCharacterStream() throws SqlException {
        try {
            this.characterStream_ = new InputStreamReader(this.asciiStream_, "ISO-8859-1");
            this.dataType_ = 16;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("22005.S.1"), (Object)"ISO-8859-1", (Object)"CharacterStream", (Throwable)unsupportedEncodingException);
        }
    }

    protected void materializeStream() throws SqlException {
        this.unicodeStream_ = super.materializeStream(this.isAsciiStream() ? this.asciiStream_ : this.unicodeStream_, "java.sql.Clob");
        this.dataType_ = 8;
    }

    long getLocatorLength() throws SqlException {
        return this.agent_.connection_.locatorProcedureCall().clobGetLength(this.locator_);
    }
}

