/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.history;

import java.io.Serializable;
import java.util.LinkedList;
import org.jolokia.history.ValueEntry;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

class HistoryEntry
implements Serializable {
    private static final long serialVersionUID = 42L;
    private LinkedList<ValueEntry> values;
    private int maxEntries;

    HistoryEntry(int pMaxEntries) {
        this.maxEntries = pMaxEntries;
        this.values = new LinkedList();
    }

    public JSONArray jsonifyValues() {
        JSONArray jValues = new JSONArray();
        for (ValueEntry vEntry : this.values) {
            JSONObject o = new JSONObject();
            o.put((Object)"value", vEntry.getValue());
            o.put((Object)"timestamp", (Object)vEntry.getTimestamp());
            jValues.add((Object)o);
        }
        return jValues;
    }

    public void setMaxEntries(int pMaxEntries) {
        this.maxEntries = pMaxEntries;
        this.trim();
    }

    public void add(Object pObject, long pTime) {
        this.values.addFirst(new ValueEntry(pObject, pTime));
        this.trim();
    }

    private void trim() {
        while (this.values.size() > this.maxEntries) {
            this.values.removeLast();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HistoryEntry");
        sb.append("{values=").append(this.values);
        sb.append(", maxEntries=").append(this.maxEntries);
        sb.append('}');
        return sb.toString();
    }
}

