/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComponentScanAnnotationParser {
    private final ResourceLoader resourceLoader;
    private final Environment environment;
    private final BeanDefinitionRegistry registry;

    public ComponentScanAnnotationParser(ResourceLoader resourceLoader, Environment environment, BeanDefinitionRegistry registry) {
        this.resourceLoader = resourceLoader;
        this.environment = environment;
        this.registry = registry;
    }

    public Set<BeanDefinitionHolder> parse(Map<String, Object> componentScanAttributes) {
        ComponentScan.Filter filterAnno;
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner(this.registry, (Boolean)componentScanAttributes.get("useDefaultFilters"));
        Assert.notNull((Object)this.environment, (String)"Environment must not be null");
        scanner.setEnvironment(this.environment);
        Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader must not be null");
        scanner.setResourceLoader(this.resourceLoader);
        scanner.setBeanNameGenerator((BeanNameGenerator)BeanUtils.instantiateClass((Class)((Class)componentScanAttributes.get("nameGenerator")), BeanNameGenerator.class));
        ScopedProxyMode scopedProxyMode = (ScopedProxyMode)((Object)componentScanAttributes.get("scopedProxy"));
        if (scopedProxyMode != ScopedProxyMode.DEFAULT) {
            scanner.setScopedProxyMode(scopedProxyMode);
        } else {
            scanner.setScopeMetadataResolver((ScopeMetadataResolver)BeanUtils.instantiateClass((Class)((Class)componentScanAttributes.get("scopeResolver")), ScopeMetadataResolver.class));
        }
        scanner.setResourcePattern((String)componentScanAttributes.get("resourcePattern"));
        ComponentScan.Filter[] filterArray = (ComponentScan.Filter[])componentScanAttributes.get("includeFilters");
        int n = filterArray.length;
        int n2 = 0;
        while (n2 < n) {
            filterAnno = filterArray[n2];
            for (TypeFilter typeFilter : this.typeFiltersFor(filterAnno)) {
                scanner.addIncludeFilter(typeFilter);
            }
            ++n2;
        }
        filterArray = (ComponentScan.Filter[])componentScanAttributes.get("excludeFilters");
        n = filterArray.length;
        n2 = 0;
        while (n2 < n) {
            filterAnno = filterArray[n2];
            for (TypeFilter typeFilter : this.typeFiltersFor(filterAnno)) {
                scanner.addExcludeFilter(typeFilter);
            }
            ++n2;
        }
        ArrayList<String> basePackages = new ArrayList<String>();
        Object[] objectArray = (String[])componentScanAttributes.get("value");
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            String pkg = objectArray[n];
            if (StringUtils.hasText((String)pkg)) {
                basePackages.add(pkg);
            }
            ++n;
        }
        objectArray = (String[])componentScanAttributes.get("basePackages");
        n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            String pkg = objectArray[n];
            if (StringUtils.hasText((String)pkg)) {
                basePackages.add(pkg);
            }
            ++n;
        }
        objectArray = (Class[])componentScanAttributes.get("basePackageClasses");
        n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object clazz = objectArray[n];
            basePackages.add(((Class)clazz).getPackage().getName());
            ++n;
        }
        if (basePackages.isEmpty()) {
            throw new IllegalStateException("At least one base package must be specified");
        }
        return scanner.doScan(basePackages.toArray(new String[0]));
    }

    private List<TypeFilter> typeFiltersFor(ComponentScan.Filter filterAnno) {
        ArrayList<TypeFilter> typeFilters = new ArrayList<TypeFilter>();
        Class<?>[] classArray = filterAnno.value();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> filterClass = classArray[n2];
            switch (filterAnno.type()) {
                case ANNOTATION: {
                    Assert.isAssignable(Annotation.class, filterClass, (String)"An error occured when processing a @ComponentScan ANNOTATION type filter: ");
                    Class<?> annoClass = filterClass;
                    typeFilters.add((TypeFilter)new AnnotationTypeFilter(annoClass));
                    break;
                }
                case ASSIGNABLE_TYPE: {
                    typeFilters.add((TypeFilter)new AssignableTypeFilter(filterClass));
                    break;
                }
                case CUSTOM: {
                    Assert.isAssignable(TypeFilter.class, filterClass, (String)"An error occured when processing a @ComponentScan CUSTOM type filter: ");
                    typeFilters.add((TypeFilter)BeanUtils.instantiateClass(filterClass, TypeFilter.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown filter type " + (Object)((Object)filterAnno.type()));
                }
            }
            ++n2;
        }
        return typeFilters;
    }
}

