/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.repository.function;

import com.google.common.base.Function;
import java.util.List;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelIdFactory;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.api.repository.ModelResource;
import org.eclipse.vorto.repository.model.ModelView;

public class ModelViewToModelResource
implements Function<ModelView, ModelResource> {
    public ModelResource apply(ModelView input) {
        ModelId modelId = ModelIdFactory.newInstance((ModelType)input.getType(), (String)input.getId().getNamespace(), (String)input.getId().getVersion(), (String)input.getId().getName());
        return new ModelResource(modelId, input.getDescription(), input.getDisplayName(), this.transformReferences(input, input.getReferences()), input.getReferencedBy());
    }

    private List<ModelId> transformReferences(ModelView modelView, List<ModelId> references) {
        for (ModelId modelId : references) {
            modelId.setModelType(this.getReferenceModelType(modelView.getType()));
        }
        return references;
    }

    private ModelType getReferenceModelType(ModelType parentModelType) {
        if (parentModelType == ModelType.InformationModel) {
            return ModelType.Functionblock;
        }
        if (parentModelType == ModelType.Functionblock) {
            return ModelType.Datatype;
        }
        return ModelType.Datatype;
    }
}

