/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.editor.functionblock.tests.validator;

import com.google.inject.Injector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.vorto.core.api.model.datatype.Constraint;
import org.eclipse.vorto.core.api.model.datatype.ConstraintIntervalType;
import org.eclipse.vorto.core.api.model.datatype.ConstraintRule;
import org.eclipse.vorto.core.api.model.datatype.DatatypeFactory;
import org.eclipse.vorto.core.api.model.datatype.PrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.FunctionblockFactory;
import org.eclipse.vorto.core.api.model.functionblock.Operation;
import org.eclipse.vorto.core.api.model.functionblock.PrimitiveParam;
import org.eclipse.vorto.core.api.model.functionblock.ReturnPrimitiveType;
import org.eclipse.vorto.core.api.model.functionblock.ReturnType;
import org.eclipse.vorto.editor.functionblock.FunctionblockStandaloneSetup;
import org.eclipse.vorto.editor.functionblock.validation.FunctionblockValidator;
import org.eclipse.xtext.junit4.AbstractXtextTests;
import org.eclipse.xtext.junit4.validation.AssertableDiagnostics;
import org.eclipse.xtext.junit4.validation.ValidatorTester;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.junit.Test;

public class FbConstraintParametersValidationTest
extends AbstractXtextTests {
    private ValidatorTester<FunctionblockValidator> tester;

    public void setUp() throws Exception {
        ValidatorTester _validatorTester;
        super.setUp();
        this.with(FunctionblockStandaloneSetup.class);
        FunctionblockValidator validator = (FunctionblockValidator)this.get(FunctionblockValidator.class);
        Injector _injector = this.getInjector();
        this.tester = _validatorTester = new ValidatorTester((AbstractDeclarativeValidator)validator, _injector);
    }

    @Test
    public void test_Operation_NoParameter_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("on");
        operation.setDescription("Turn on switch");
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkParametersConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Operation_String_ReturnType_Valid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        ReturnPrimitiveType returnPrimitiveType = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
        returnPrimitiveType.setReturnType(PrimitiveType.STRING);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint constraint1 = DatatypeFactory.eINSTANCE.createConstraint();
        constraint1.setType(ConstraintIntervalType.STRLEN);
        constraint1.setConstraintValues("20");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)constraint1);
        returnPrimitiveType.setConstraintRule(constraintRule);
        operation.setReturnType((ReturnType)returnPrimitiveType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkReturnTypeConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Operation_String_ReturnType_Invalid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        ReturnPrimitiveType returnPrimitiveType = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
        returnPrimitiveType.setReturnType(PrimitiveType.INT);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint invalidTypeConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        invalidTypeConstraint.setType(ConstraintIntervalType.STRLEN);
        invalidTypeConstraint.setConstraintValues("20");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)invalidTypeConstraint);
        returnPrimitiveType.setConstraintRule(constraintRule);
        operation.setReturnType((ReturnType)returnPrimitiveType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkReturnTypeConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Operation_Int_ReturnType_Valid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        ReturnPrimitiveType returnPrimitiveType = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
        returnPrimitiveType.setReturnType(PrimitiveType.INT);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint minConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        minConstraint.setType(ConstraintIntervalType.MIN);
        minConstraint.setConstraintValues("20");
        Constraint maxConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        maxConstraint.setType(ConstraintIntervalType.MAX);
        maxConstraint.setConstraintValues("40");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)minConstraint);
        EList _constraints_1 = constraintRule.getConstraints();
        _constraints_1.add((Object)maxConstraint);
        returnPrimitiveType.setConstraintRule(constraintRule);
        operation.setReturnType((ReturnType)returnPrimitiveType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkReturnTypeConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Operation_Int_ReturnType_Invalid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        ReturnPrimitiveType returnPrimitiveType = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
        returnPrimitiveType.setReturnType(PrimitiveType.STRING);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint minConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        minConstraint.setType(ConstraintIntervalType.MIN);
        minConstraint.setConstraintValues("20");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)minConstraint);
        returnPrimitiveType.setConstraintRule(constraintRule);
        operation.setReturnType((ReturnType)returnPrimitiveType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkReturnTypeConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }

    @Test
    public void test_Operation_Mime_ReturnType_Valid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        ReturnPrimitiveType returnPrimitiveType = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
        returnPrimitiveType.setReturnType(PrimitiveType.BYTE);
        returnPrimitiveType.setMultiplicity(true);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint mimeConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        mimeConstraint.setType(ConstraintIntervalType.MIMETYPE);
        mimeConstraint.setConstraintValues("gif");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)mimeConstraint);
        returnPrimitiveType.setConstraintRule(constraintRule);
        operation.setReturnType((ReturnType)returnPrimitiveType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkReturnTypeConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Operation_Mime_ReturnType_Invalid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        ReturnPrimitiveType returnPrimitiveType = FunctionblockFactory.eINSTANCE.createReturnPrimitiveType();
        returnPrimitiveType.setReturnType(PrimitiveType.BYTE);
        returnPrimitiveType.setMultiplicity(false);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint mimeConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        mimeConstraint.setType(ConstraintIntervalType.MIMETYPE);
        mimeConstraint.setConstraintValues("gif");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)mimeConstraint);
        returnPrimitiveType.setConstraintRule(constraintRule);
        operation.setReturnType((ReturnType)returnPrimitiveType);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkReturnTypeConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("MIMEType only applies to byte array, have you forgotten to add 'multiple' ?");
    }

    @Test
    public void test_Operation_Int_Parameters_Valid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        PrimitiveParam param1 = FunctionblockFactory.eINSTANCE.createPrimitiveParam();
        param1.setType(PrimitiveType.INT);
        EList _params = operation.getParams();
        _params.add((Object)param1);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint maxConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        maxConstraint.setType(ConstraintIntervalType.MAX);
        maxConstraint.setConstraintValues("20");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)maxConstraint);
        param1.setConstraintRule(constraintRule);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkParametersConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertOK();
    }

    @Test
    public void test_Operation_Int_Parameters_InValid_Constraint() {
        Operation operation = FunctionblockFactory.eINSTANCE.createOperation();
        operation.setName("off");
        operation.setDescription("Turn off switch");
        PrimitiveParam param1 = FunctionblockFactory.eINSTANCE.createPrimitiveParam();
        param1.setType(PrimitiveType.STRING);
        EList _params = operation.getParams();
        _params.add((Object)param1);
        ConstraintRule constraintRule = DatatypeFactory.eINSTANCE.createConstraintRule();
        Constraint maxConstraint = DatatypeFactory.eINSTANCE.createConstraint();
        maxConstraint.setType(ConstraintIntervalType.MAX);
        maxConstraint.setConstraintValues("20");
        EList _constraints = constraintRule.getConstraints();
        _constraints.add((Object)maxConstraint);
        param1.setConstraintRule(constraintRule);
        FunctionblockValidator _validator = (FunctionblockValidator)this.tester.validator();
        _validator.checkParametersConstraint(operation);
        AssertableDiagnostics _diagnose = this.tester.diagnose();
        _diagnose.assertErrorContains("Constraint cannot apply on this property's datatype");
    }
}

