/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.vorto.codegen.ui.context.IProjectContext;

public abstract class AbstractVortoWizardPage
extends WizardPage
implements IProjectContext {
    private String workspaceLocation;

    protected AbstractVortoWizardPage(String pageName) {
        super(pageName);
    }

    protected void dialogChanged() {
        if (this.validateProject()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
        }
    }

    protected abstract boolean validateProject();

    protected abstract void updateWorkspaceLocationField(String var1);

    protected void handleBrowse(SelectionEvent e) {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setFilterPath(this.workspaceLocation);
        directoryDialog.setText("Workspace folder selection");
        directoryDialog.setMessage("Select a directory for this project");
        String selectedDirectory = directoryDialog.open();
        selectedDirectory = StringUtils.replace((String)selectedDirectory, (String)"\\", (String)"/");
        if (selectedDirectory != null) {
            this.workspaceLocation = selectedDirectory;
            this.updateWorkspaceLocationField(this.workspaceLocation);
            this.dialogChanged();
        }
    }

    public String getWorkspaceLocation() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (this.workspaceLocation == null) {
            this.workspaceLocation = workspace.getRoot().getLocation().toString();
        }
        return this.workspaceLocation;
    }

    protected boolean validateStrExist(String string, String errorMsgToBeShown) {
        if (Strings.isNullOrEmpty((String)string)) {
            this.setErrorMessage(errorMsgToBeShown);
            return false;
        }
        return true;
    }

    protected boolean validateLocation(String input, String errorMsg, String type) {
        if (input.lastIndexOf(".") < 0 || !input.substring(input.lastIndexOf(".") + 1, input.length()).equalsIgnoreCase(type)) {
            this.setErrorMessage("Invalid file location for " + errorMsg);
            return false;
        }
        File file = new File(input);
        if (file != null && file.exists() && !file.isDirectory()) {
            return true;
        }
        this.setErrorMessage(String.valueOf(errorMsg) + " file does not exist");
        return false;
    }

    protected boolean validateExistingSameProjectName() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String projectName = this.getProjectName();
        if (workspace.getRoot().getProject(this.getProjectName()).exists()) {
            this.setErrorMessage("Project " + this.getProjectName() + " already exists.");
            return false;
        }
        IPath projectLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(projectName);
        if (projectLocation.toFile().exists()) {
            try {
                String canonicalPath = projectLocation.toFile().getCanonicalPath();
                projectLocation = new Path(canonicalPath);
                String existingName = projectLocation.lastSegment();
                if (!existingName.equals(projectName)) {
                    this.setErrorMessage("Project " + this.getProjectName() + " already exists.");
                    return false;
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }

    protected boolean validateNoSpaceForLocation(String location) {
        return location.contains(" ");
    }

    protected boolean checkForRegexPattern(String input, String regexPattern) {
        return Pattern.compile(regexPattern).matcher(input).find();
    }
}

