/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.wizard.mapping;

import com.google.common.base.Strings;
import java.util.Collection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vorto.core.api.model.model.ModelId;
import org.eclipse.vorto.core.api.model.model.ModelType;
import org.eclipse.vorto.core.ui.model.IModelProject;
import org.eclipse.vorto.wizard.ModelBaseWizardPage;

public class MappingModellWizardPage
extends ModelBaseWizardPage {
    private static final String DEFAULT_VERSION = "1.0.0";
    private static final String DEFAULT_DESCRIPTION = "Mapping model for ";
    private static final String DEFAULT_MAPPINGMODEL_NAME = "NewMapping";
    private Text txtPlatform;

    protected MappingModellWizardPage(String pageName, IModelProject modelProject) {
        super(pageName, modelProject);
    }

    protected void decorate(Composite parent) {
        this.txtPlatform = this.newLabeledText(parent, "Platform:", 2048, this.newTxtGridData(400, null), this.modificationListener);
    }

    protected void initialize() {
        super.initialize();
        this.txtPlatform.setText(this.getDefaultTargetPlatform());
    }

    protected Collection<ModelBaseWizardPage.Validator> getValidators(ModelId id) {
        Collection validators = super.getValidators(id);
        validators.add(new ModelBaseWizardPage.Validator(){

            public ModelBaseWizardPage.ValidationResult validate() {
                String platform = MappingModellWizardPage.this.txtPlatform.getText();
                if (Strings.isNullOrEmpty((String)platform)) {
                    return MappingModellWizardPage.this.invalid("Target Platform must be provided.");
                }
                return MappingModellWizardPage.this.valid();
            }
        });
        return validators;
    }

    protected String getTargetPlatform() {
        return this.txtPlatform.getText();
    }

    protected String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    protected String getDefaultDescription() {
        return DEFAULT_DESCRIPTION;
    }

    protected String getDefaultModelName() {
        return DEFAULT_MAPPINGMODEL_NAME;
    }

    protected String getDefaultNamespace() {
        return "com.mycompany.mapping";
    }

    protected String getGroupTitle() {
        return "Mapping Model Details";
    }

    protected String getModelLabel() {
        return "Mapping Model Name:";
    }

    protected String getDefaultTargetPlatform() {
        return "myplatform";
    }

    protected ModelType getModelType() {
        return ModelType.Mapping;
    }
}

