/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui;

import org.eclipse.vorto.codegen.api.ChainedCodeGeneratorTask;
import org.eclipse.vorto.codegen.api.GenerationResultZip;
import org.eclipse.vorto.codegen.api.GeneratorTaskFromFileTemplate;
import org.eclipse.vorto.codegen.api.ICodeGeneratorTask;
import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.IGeneratedWriter;
import org.eclipse.vorto.codegen.api.IGenerationResult;
import org.eclipse.vorto.codegen.api.IVortoCodeGenProgressMonitor;
import org.eclipse.vorto.codegen.api.IVortoCodeGenerator;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.utils.Utils;
import org.eclipse.vorto.codegen.webui.templates.PomTemplate;
import org.eclipse.vorto.codegen.webui.templates.ThingApplicationTemplate;
import org.eclipse.vorto.codegen.webui.templates.config.LocalConfigurationTemplate;
import org.eclipse.vorto.codegen.webui.templates.config.SwaggerConfigurationTemplate;
import org.eclipse.vorto.codegen.webui.templates.config.WebSecurityConfigTemplate;
import org.eclipse.vorto.codegen.webui.templates.config.WebSocketConfigTemplate;
import org.eclipse.vorto.codegen.webui.templates.dao.CrudRepositoryTemplate;
import org.eclipse.vorto.codegen.webui.templates.model.FeatureStatusPropertyTemplate;
import org.eclipse.vorto.codegen.webui.templates.model.JavaClassGeneratorTask;
import org.eclipse.vorto.codegen.webui.templates.model.JavaEnumGeneratorTask;
import org.eclipse.vorto.codegen.webui.templates.resources.AngularGageTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.ApplicationConfigTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.IndexHtmlTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.css.StyleTemplace;
import org.eclipse.vorto.codegen.webui.templates.resources.js.ApiControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.js.AppTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.js.BrowserControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.js.DetailsControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.js.LocationControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.js.LoginControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.partials.ApiTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.partials.BrowserTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.partials.DetailsTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.partials.LocatorTemplate;
import org.eclipse.vorto.codegen.webui.templates.resources.partials.LoginTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.DataServiceTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.QueryTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.BoschThingsDataServiceTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.ThingBuilderTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.ThingClientBuilderTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.ThingClientTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.ThingsQueryTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.auth.IM3AuthenticationProviderTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.auth.IMUserInfoTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.internal.AsyncInvocationTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.internal.DefaultThingClient;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.internal.ThingsInvocationTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.internal.model.FeatureImplTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.internal.model.ThingImplTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.internal.model.ThingSearchResultImplTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.model.AclEntryTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.model.FeatureTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.model.ThingSearchResultTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.model.ThingTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.bosch.model.ThingTypeAwareTemplate;
import org.eclipse.vorto.codegen.webui.templates.service.sample.SampleDataServiceTemplate;
import org.eclipse.vorto.codegen.webui.templates.web.HistoryDataControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.web.IdentityControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.web.ThingControllerTemplate;
import org.eclipse.vorto.codegen.webui.templates.web.ThingMessageControllerTemplate;
import org.eclipse.vorto.core.api.model.datatype.Entity;
import org.eclipse.vorto.core.api.model.datatype.Enum;
import org.eclipse.vorto.core.api.model.functionblock.FunctionBlock;
import org.eclipse.vorto.core.api.model.informationmodel.FunctionblockProperty;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;

public class WebUIGenerator
implements IVortoCodeGenerator {
    public IGenerationResult generate(InformationModel model, InvocationContext context, IVortoCodeGenProgressMonitor monitor) {
        GenerationResultZip output = new GenerationResultZip(model, this.getServiceKey());
        ChainedCodeGeneratorTask generator = new ChainedCodeGeneratorTask();
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new LocalConfigurationTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new WebSecurityConfigTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new WebSocketConfigTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new org.eclipse.vorto.codegen.webui.templates.model.ThingTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new IdentityControllerTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingControllerTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingMessageControllerTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new PomTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingApplicationTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new AppTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new BrowserControllerTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new DetailsControllerTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new LoginControllerTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new StyleTemplace()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new IndexHtmlTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new BrowserTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new LocatorTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new LoginTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new DetailsTemplate()));
        if (context.getConfigurationProperties().getOrDefault("swagger", "true").equalsIgnoreCase("true")) {
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new SwaggerConfigurationTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ApiControllerTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ApiTemplate()));
        }
        if (context.getConfigurationProperties().getOrDefault("persistence", "true").equalsIgnoreCase("true")) {
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new CrudRepositoryTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new HistoryDataControllerTemplate()));
        }
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ApplicationConfigTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new AngularGageTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new QueryTemplate()));
        generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new DataServiceTemplate()));
        if (context.getConfigurationProperties().getOrDefault("boschcloud", "false").equalsIgnoreCase("true")) {
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingsQueryTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingClientTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingClientBuilderTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingBuilderTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new IM3AuthenticationProviderTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new IMUserInfoTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new AclEntryTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new FeatureTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingSearchResultTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingTypeAwareTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new FeatureImplTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingImplTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingSearchResultImplTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new AsyncInvocationTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new DefaultThingClient()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new ThingsInvocationTemplate()));
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new BoschThingsDataServiceTemplate()));
        } else {
            generator.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new SampleDataServiceTemplate()));
        }
        generator.generate((Object)model, context, (IGeneratedWriter)output);
        ChainedCodeGeneratorTask fbPropertyGenerators = new ChainedCodeGeneratorTask();
        for (FunctionblockProperty property : model.getProperties()) {
            fbPropertyGenerators.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new FeatureStatusPropertyTemplate()));
            fbPropertyGenerators.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new org.eclipse.vorto.codegen.webui.templates.model.FeatureTemplate()));
            fbPropertyGenerators.addTask((ICodeGeneratorTask)new GeneratorTaskFromFileTemplate((IFileTemplate)new LocationControllerTemplate()));
            fbPropertyGenerators.generate((Object)property, context, (IGeneratedWriter)output);
            FunctionBlock fb = property.getType().getFunctionblock();
            for (Entity entity : Utils.getReferencedEntities((FunctionBlock)fb)) {
                this.generateForEntity(model, entity, (IGeneratedWriter)output);
            }
            for (Enum en : Utils.getReferencedEnums((FunctionBlock)fb)) {
                this.generateForEnum(model, en, (IGeneratedWriter)output);
            }
        }
        return output;
    }

    private void generateForEntity(InformationModel infomodel, Entity entity, IGeneratedWriter outputter) {
        new JavaClassGeneratorTask(infomodel).generate(entity, null, outputter);
    }

    private void generateForEnum(InformationModel infomodel, Enum en, IGeneratedWriter outputter) {
        new JavaEnumGeneratorTask(infomodel).generate(en, null, outputter);
    }

    public String getServiceKey() {
        return "webui";
    }
}

