/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.service.bosch.internal;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class AsyncInvocationTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"AsyncInvocationTemplate.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/service/bosch/internal");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".service.bosch.internal;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.io.IOException;");
        _builder.newLine();
        _builder.append((Object)"import java.lang.reflect.Type;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.CompletableFuture;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.HttpHeaders;");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.client.HttpClient;");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.client.methods.HttpUriRequest;");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.impl.client.HttpClients;");
        _builder.newLine();
        _builder.append((Object)"import org.apache.http.util.EntityUtils;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.Gson;");
        _builder.newLine();
        _builder.append((Object)"import com.google.gson.reflect.TypeToken;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"public class AsyncInvocationTemplate {");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Gson gson;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public AsyncInvocationTemplate(Gson gson) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"this.gson = gson;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public <Result> CompletableFuture<Result> execute(final HttpUriRequest request, Type type) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"preSend(request);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return CompletableFuture.supplyAsync(() -> {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"try {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"final HttpClient httpClient = HttpClients.createDefault();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"return httpClient.execute(request, response -> {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"int statusCode = response.getStatusLine().getStatusCode();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"if (statusCode >= 200 && statusCode <= 299) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"if (type.equals(Void.class)) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"String json = EntityUtils.toString(response.getEntity(), \"UTF-8\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"return gson.fromJson(json, type);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"} else if (statusCode == 400) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"throw new IllegalArgumentException(\"Error executing async call, bad request.\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"} else if (statusCode == 401) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"Error executing async call, not able to authenticate with the server\");");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"} else if (statusCode == 403) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"Error executing async call, not able to autorize with the server\");\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"} else if (statusCode == 404) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"Error while executing async call, server respond with a status of:  \" + response.getStatusLine().getStatusCode());");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"} catch (IOException e) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"throw new RuntimeException(\"Error executing async call to remote REST endpoint\", e);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"});");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public <Result> CompletableFuture<Result> execute(HttpUriRequest request) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return execute(request,new TypeToken<Result>(){}.getType());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"protected void preSend(HttpUriRequest request) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"request.addHeader(HttpHeaders.CONTENT_TYPE, \"application/json\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"request.addHeader(HttpHeaders.ACCEPT, \"application/json\");");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder.toString();
    }
}

