/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.codegen.webui.templates.web;

import org.eclipse.vorto.codegen.api.IFileTemplate;
import org.eclipse.vorto.codegen.api.InvocationContext;
import org.eclipse.vorto.codegen.webui.templates.TemplateUtils;
import org.eclipse.vorto.core.api.model.informationmodel.InformationModel;
import org.eclipse.xtend2.lib.StringConcatenation;

public class ThingControllerTemplate
implements IFileTemplate<InformationModel> {
    public String getFileName(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = context.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"Controller.java");
        return _builder.toString();
    }

    public String getPath(InformationModel context) {
        StringConcatenation _builder = new StringConcatenation();
        String _baseApplicationPath = TemplateUtils.getBaseApplicationPath(context);
        _builder.append((Object)_baseApplicationPath, "");
        _builder.append((Object)"/web");
        return _builder.toString();
    }

    public String getContent(InformationModel element, InvocationContext context) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package com.example.iot.");
        String _name = element.getName();
        String _lowerCase = _name.toLowerCase();
        _builder.append((Object)_lowerCase, "");
        _builder.append((Object)".web;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.List;");
        _builder.newLine();
        _builder.append((Object)"import java.util.concurrent.ExecutionException;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.springframework.beans.factory.annotation.Autowired;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.http.HttpStatus;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.http.MediaType;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.bind.annotation.ExceptionHandler;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.bind.annotation.PathVariable;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.bind.annotation.RequestMapping;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.bind.annotation.RequestMethod;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.bind.annotation.ResponseStatus;");
        _builder.newLine();
        _builder.append((Object)"import org.springframework.web.bind.annotation.RestController;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import com.example.iot.");
        String _name_1 = element.getName();
        String _lowerCase_1 = _name_1.toLowerCase();
        _builder.append((Object)_lowerCase_1, "");
        _builder.append((Object)".model.");
        String _name_2 = element.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_3 = element.getName();
        String _lowerCase_2 = _name_3.toLowerCase();
        _builder.append((Object)_lowerCase_2, "");
        _builder.append((Object)".service.DataService;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import com.example.iot.");
        String _name_4 = element.getName();
        String _lowerCase_3 = _name_4.toLowerCase();
        _builder.append((Object)_lowerCase_3, "");
        _builder.append((Object)".service.Query;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"@RestController");
        _builder.newLine();
        _builder.append((Object)"@RequestMapping(\"/rest/devices\")");
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name_5 = element.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)"Controller {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Autowired");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"private DataService dataService;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@RequestMapping(produces = { MediaType.APPLICATION_JSON_VALUE }, method = RequestMethod.GET)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public List<");
        String _name_6 = element.getName();
        _builder.append((Object)_name_6, "\t");
        _builder.append((Object)"> search");
        String _name_7 = element.getName();
        _builder.append((Object)_name_7, "\t");
        _builder.append((Object)"Things() throws ExecutionException, InterruptedException  {\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Query query = dataService.newQuery();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return dataService.queryThings(query);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@RequestMapping(value = \"/{thingId:.+}\", produces = {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"MediaType.APPLICATION_JSON_VALUE }, method = RequestMethod.GET)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _name_8 = element.getName();
        _builder.append((Object)_name_8, "\t");
        _builder.append((Object)" get");
        String _name_9 = element.getName();
        _builder.append((Object)_name_9, "\t");
        _builder.append((Object)"Thing(@PathVariable(\"thingId\") final String thingId) throws ExecutionException, InterruptedException {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return dataService.getThing(thingId);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR, reason = \"Problem accessing Backend IoT Cloud\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@ExceptionHandler(ExecutionException.class)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void executionError(final ExecutionException ex){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// handle this error ");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR, reason = \"Problem accessing Backend IoT Cloud\")");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@ExceptionHandler(InterruptedException.class)");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void interruptedError(final InterruptedException ex){");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// handle this error");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }
}

