/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vorto.perspective.command;

import com.google.common.io.ByteStreams;
import java.io.InputStream;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.vorto.core.api.repository.IModelRepository;
import org.eclipse.vorto.core.api.repository.ModelRepositoryFactory;
import org.eclipse.vorto.core.api.repository.UploadResult;
import org.eclipse.vorto.core.ui.MessageDisplayFactory;
import org.eclipse.vorto.core.ui.exception.ExceptionHandlerFactory;
import org.eclipse.vorto.core.ui.model.IModelElement;
import org.eclipse.vorto.perspective.util.ImageUtil;
import org.eclipse.vorto.perspective.view.ModelUploadDialog;

public abstract class ShareModelAction
extends Action {
    private IModelRepository modelRepo = ModelRepositoryFactory.getModelRepository();

    public ShareModelAction() {
        super("Share", ImageDescriptor.createFromImage((Image)ImageUtil.getImage("share.gif")));
    }

    public static Action newInstance(final TreeViewer viewer, final IModelElement model) {
        return new ShareModelAction(){

            @Override
            protected TreeViewer getViewer() {
                return viewer;
            }

            @Override
            protected IModelElement getSelectedElement() {
                return model;
            }
        };
    }

    public void run() {
        IModelElement modelElement = this.getSelectedElement();
        try {
            UploadResult uploadResult = this.modelRepo.upload(modelElement.getModelFile().getName(), ByteStreams.toByteArray((InputStream)modelElement.getModelFile().getContents()));
            ModelUploadDialog uploadDialog = new ModelUploadDialog(this.getViewer().getControl().getShell(), uploadResult);
            uploadDialog.create();
            int result = uploadDialog.open();
            if (uploadResult.statusOk() && result == 0) {
                this.modelRepo.commit(uploadResult.getHandleId());
                MessageDisplayFactory.getMessageDisplay().displaySuccess("Model " + modelElement.getModelFile().getName() + " saved to repository.");
            }
        }
        catch (Exception e) {
            ExceptionHandlerFactory.getHandler().handle((Throwable)e);
        }
    }

    protected abstract IModelElement getSelectedElement();

    protected abstract TreeViewer getViewer();
}

