/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.ui.internal.assembly.wizard;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.JavaModuleComponentUtility;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.jst.common.internal.modulecore.util.UpdateManifestDataModelProvider;
import org.eclipse.jst.common.ui.internal.Messages;
import org.eclipse.jst.common.ui.internal.assembly.wizard.AddManifestEntryTaskWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.AbstractResourceListVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.ModuleCoreUIPlugin;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.DependencyPageExtensionManager;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.IVirtualComponentLabelProvider;
import org.eclipse.wst.common.componentcore.ui.propertypage.AbstractIModuleDependenciesControl;
import org.eclipse.wst.common.componentcore.ui.propertypage.ModuleAssemblyRootPage;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class ManifestModuleDependencyControl
extends AbstractIModuleDependenciesControl {
    protected IProject project;
    protected IVirtualComponent rootComponent;
    protected IProject parentProject;
    protected ModuleAssemblyRootPage propPage;
    protected Button addButton;
    protected Button removeButton;
    protected Button moveUpButton;
    protected Button moveDownButton;
    protected Combo parentSelection;
    protected TableViewer manifestEntryViewer;
    private ArrayList<IVirtualReference> list = new ArrayList();
    private String previousManifest = null;
    private IVirtualReference[] refsForCurrentProject;

    public ManifestModuleDependencyControl(IProject project, ModuleAssemblyRootPage page) {
        this.project = project;
        this.propPage = page;
        this.rootComponent = ComponentCore.createComponent((IProject)project);
    }

    private static GridLayout glayout(int columns) {
        GridLayout gl = new GridLayout(columns, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        return gl;
    }

    public Composite createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)root, "org.eclipse.jst.common.ui.DEPLOYMENT_ASSEMBLY_PREFERENCE_PAGE_MANIFEST_ENTRIES_TAB");
        root.setLayout((Layout)ManifestModuleDependencyControl.glayout(1));
        Composite parentSelectionComposite = new Composite(root, 0);
        parentSelectionComposite.setLayoutData((Object)new GridData(768));
        parentSelectionComposite.setLayout((Layout)ManifestModuleDependencyControl.glayout(2));
        Label l = new Label(parentSelectionComposite, 0);
        l.setText(Messages.ParentProject);
        l.setLayoutData((Object)new GridData());
        this.parentSelection = new Combo(parentSelectionComposite, 8);
        this.parentSelection.setLayoutData((Object)new GridData(768));
        this.parentSelection.setItems(this.getPossibleParentProjects());
        this.parentSelection.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ManifestModuleDependencyControl.this.refreshViewerFromNewParentProject();
            }
        });
        Composite manifestEntryViewerComposite = new Composite(root, 0);
        GridData manifestEntryViewerCompositeLayoutData = new GridData(1808);
        manifestEntryViewerComposite.setLayoutData((Object)manifestEntryViewerCompositeLayoutData);
        manifestEntryViewerComposite.setLayout((Layout)ManifestModuleDependencyControl.glayout(2));
        this.manifestEntryViewer = ManifestModuleDependencyControl.createManifestReferenceTableViewer(manifestEntryViewerComposite, 4);
        GridData data = new GridData(1808);
        int numlines = Math.min(10, this.manifestEntryViewer.getTable().getItemCount());
        data.heightHint = this.manifestEntryViewer.getTable().getItemHeight() * numlines;
        this.manifestEntryViewer.getTable().setLayoutData((Object)data);
        Composite buttonColumn = new Composite(manifestEntryViewerComposite, 0);
        buttonColumn.setLayoutData((Object)new GridData(1040));
        buttonColumn.setLayout((Layout)ManifestModuleDependencyControl.glayout(1));
        this.addButton = new Button(buttonColumn, 8);
        this.addButton.setText(Messages.Add);
        GridDataFactory.defaultsFor((Control)this.addButton).applyTo((Control)this.addButton);
        this.removeButton = new Button(buttonColumn, 8);
        this.removeButton.setText(Messages.Remove);
        GridDataFactory.defaultsFor((Control)this.removeButton).applyTo((Control)this.removeButton);
        this.moveUpButton = new Button(buttonColumn, 8);
        this.moveUpButton.setText(Messages.MoveUp);
        GridDataFactory.defaultsFor((Control)this.moveUpButton).applyTo((Control)this.moveUpButton);
        this.moveDownButton = new Button(buttonColumn, 8);
        this.moveDownButton.setText(Messages.MoveDown);
        GridDataFactory.defaultsFor((Control)this.moveDownButton).applyTo((Control)this.moveDownButton);
        IFile manifest = this.getManifestIFile(this.rootComponent);
        if (manifest == null) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
            this.previousManifest = manifest.getFullPath().toOSString();
        }
        this.removeButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManifestModuleDependencyControl.this.addPressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManifestModuleDependencyControl.this.removePressed();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManifestModuleDependencyControl.this.moveUp();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManifestModuleDependencyControl.this.moveDown();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.manifestEntryViewer.setLabelProvider((IBaseLabelProvider)new ManifestLabelProvider());
        this.manifestEntryViewer.setContentProvider((IContentProvider)new ManifestContentProvider());
        this.manifestEntryViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.parentSelection.select(0);
        this.manifestEntryViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ManifestModuleDependencyControl.this.viewerSelectionChanged();
            }
        });
        this.manifestEntryViewer.getTable().getColumn(0).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManifestModuleDependencyControl.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.manifestEntryViewer.getTable().getColumn(1).addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManifestModuleDependencyControl.this.updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return root;
    }

    protected void viewerSelectionChanged() {
        this.updateButtons();
    }

    protected void updateButtons() {
        if (!this.addButton.isEnabled()) {
            this.removeButton.setEnabled(false);
            this.moveUpButton.setEnabled(false);
            this.moveDownButton.setEnabled(false);
        } else {
            int index = this.manifestEntryViewer.getTable().getSelectionIndex();
            int size = this.manifestEntryViewer.getTable().getItems().length;
            boolean sorted = this.manifestEntryViewer.getTable().getSortDirection() != 0;
            this.removeButton.setEnabled(index != -1);
            this.moveUpButton.setEnabled(index != -1 && index != 0 && !sorted);
            this.moveDownButton.setEnabled(index != -1 && index != size - 1 && !sorted);
        }
    }

    protected void moveUp() {
        int index = this.manifestEntryViewer.getTable().getSelectionIndex();
        IVirtualReference ref = this.list.remove(index);
        this.list.add(index - 1, ref);
        this.refreshViewer();
        this.updateButtons();
    }

    protected void moveDown() {
        int index = this.manifestEntryViewer.getTable().getSelectionIndex();
        IVirtualReference ref = this.list.remove(index);
        this.list.add(index + 1, ref);
        this.refreshViewer();
        this.updateButtons();
    }

    protected void addPressed() {
        AddManifestEntryTaskWizard wizard = new AddManifestEntryTaskWizard();
        wizard.getTaskModel().putObject("CHILD_PROJECT", (Object)this.project);
        wizard.getTaskModel().putObject("PARENT_PROJECT", (Object)this.parentProject);
        wizard.getTaskModel().putObject("CURRENT_REFERENCES", (Object)this.list.toArray(new IVirtualReference[this.list.size()]));
        WizardDialog wd = new WizardDialog(this.addButton.getShell(), (IWizard)wizard);
        if (wd.open() != 1) {
            IVirtualReference[] ret = (IVirtualReference[])wizard.getTaskModel().getObject("RETURNED_REFERENCES");
            if (ret != null) {
                this.list.addAll(Arrays.asList(ret));
            }
            this.refreshViewer();
            this.updateButtons();
        }
    }

    protected void removePressed() {
        IStructuredSelection sel = (IStructuredSelection)this.manifestEntryViewer.getSelection();
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            this.list.remove(i.next());
        }
        this.refreshViewer();
        this.updateButtons();
    }

    public static TableViewer createManifestReferenceTableViewer(Composite parent, int style) {
        int flags = 0x800 | style;
        Table table = new Table(parent, flags);
        TableViewer viewer = new TableViewer(table);
        final TableViewerColumnSortToggler sortController = new TableViewerColumnSortToggler(viewer);
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(200, true));
        table.setLayout((Layout)tableLayout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn fileNameColumn = new TableColumn(table, 0, 0);
        fileNameColumn.setText(Messages.ManifestEntryColumn);
        fileNameColumn.setResizable(true);
        fileNameColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                sortController.toggleSort(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TableColumn projectColumn = new TableColumn(table, 0, 1);
        projectColumn.setText(Messages.ManifestEntrySourceColumn);
        projectColumn.setResizable(true);
        projectColumn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                sortController.toggleSort(1);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        tableLayout.layout((Composite)table, true);
        return viewer;
    }

    protected void refreshViewerFromNewParentProject() {
        this.list.clear();
        String parentString = this.parentSelection.getText();
        this.refsForCurrentProject = new IVirtualReference[0];
        if (parentString != null && !"".equals(parentString)) {
            this.parentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(parentString);
            IVirtualReference[] current = JavaModuleComponentUtility.findCurrentManifestEntries((IProject)this.parentProject, (IProject)this.project);
            this.refsForCurrentProject = this.sortRefsForCurrentProject(this.addMissingDummyEntries(current));
            int i = 0;
            while (i < this.refsForCurrentProject.length) {
                this.list.add(this.refsForCurrentProject[i]);
                ++i;
            }
        }
        this.manifestEntryViewer.refresh();
    }

    private IVirtualReference[] sortRefsForCurrentProject(IVirtualReference[] currentRefs) {
        IFile manifestFile = this.getManifestIFile(this.rootComponent);
        if (manifestFile == null) {
            return currentRefs;
        }
        HashMap<String, IVirtualReference> unsortedRefMap = new HashMap<String, IVirtualReference>();
        int i = 0;
        while (i < currentRefs.length) {
            IVirtualReference ref = currentRefs[i];
            String entryName = ref.getRuntimePath().toString().length() > 0 ? ref.getRuntimePath().append(ref.getArchiveName()).toString() : ref.getArchiveName();
            unsortedRefMap.put(entryName, ref);
            ++i;
        }
        ArrayList<IVirtualReference> sortedRefs = new ArrayList<IVirtualReference>();
        ArchiveManifest manifest = ManifestUtilities.getManifest((IFile)manifestFile);
        String[] entries = manifest.getClassPathTokenized();
        int i2 = 0;
        while (i2 < entries.length) {
            IVirtualReference ref = (IVirtualReference)unsortedRefMap.get(entries[i2]);
            if (ref != null) {
                sortedRefs.add(ref);
            }
            ++i2;
        }
        return sortedRefs.toArray(new IVirtualReference[sortedRefs.size()]);
    }

    protected void refreshViewer() {
        this.refsForCurrentProject = this.list.toArray(new IVirtualReference[this.list.size()]);
        GridData data = new GridData(1808);
        int numlines = Math.min(10, this.manifestEntryViewer.getTable().getItemCount());
        data.heightHint = this.manifestEntryViewer.getTable().getItemHeight() * numlines;
        this.manifestEntryViewer.getTable().setLayoutData((Object)data);
        this.manifestEntryViewer.refresh();
    }

    protected IVirtualReference[] addMissingDummyEntries(IVirtualReference[] current) {
        IFile manifestFile = this.getManifestIFile(this.rootComponent);
        if (manifestFile != null) {
            ArrayList<IVirtualReference> refs = new ArrayList<IVirtualReference>();
            refs.addAll(Arrays.asList(current));
            ArchiveManifest manifest = ManifestUtilities.getManifest((IFile)manifestFile);
            String[] entries = manifest.getClassPathTokenized();
            String[] unusedEntries = this.findUnusedEntries(current, entries);
            int i = 0;
            while (i < unusedEntries.length) {
                refs.add(this.createDummyReference(unusedEntries[i]));
                ++i;
            }
            return refs.toArray(new IVirtualReference[refs.size()]);
        }
        return current;
    }

    private IVirtualReference createDummyReference(String path) {
        return ManifestModuleDependencyControl.createDummyReference(path, this.parentProject, ComponentCore.createComponent((IProject)this.parentProject));
    }

    public static IVirtualReference createDummyReference(String path, IProject project, IVirtualComponent rootComponent) {
        DummyVirtualComponent comp = new DummyVirtualComponent(project, rootComponent);
        IVirtualReference ref = ComponentCore.createReference((IVirtualComponent)rootComponent, (IVirtualComponent)comp);
        if (path.indexOf("\\") > 0) {
            ref.setRuntimePath((IPath)new Path(""));
            ref.setArchiveName(path);
            return ref;
        }
        Path path2 = new Path(path.trim());
        Path runtimePath = path2.segmentCount() > 1 ? path2.removeLastSegments(1) : new Path("/");
        runtimePath = runtimePath.makeRelative();
        ref.setRuntimePath((IPath)runtimePath);
        ref.setArchiveName(path2.lastSegment());
        return ref;
    }

    private String[] findUnusedEntries(IVirtualReference[] current, String[] entries) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(entries));
        int i = 0;
        while (i < current.length) {
            String currentEntry = current[i].getRuntimePath().append(current[i].getArchiveName()).toString();
            list.remove(currentEntry);
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public IFile getManifestIFile(IVirtualComponent root) {
        IVirtualFolder rootFolder = root.getRootFolder();
        IVirtualFile vf = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        if (vf.exists()) {
            return vf.getUnderlyingFile();
        }
        return null;
    }

    protected String[] getPossibleParentProjects() {
        IProject[] projects = JavaModuleComponentUtility.findParentProjects((IProject)this.project);
        String[] strings = new String[projects.length];
        int i = 0;
        while (i < projects.length) {
            strings[i] = projects[i].getName();
            ++i;
        }
        return strings;
    }

    public boolean performOk() {
        if (this.addButton != null && this.addButton.isEnabled()) {
            IDataModel updateManifestDataModel = DataModelFactory.createDataModel((IDataModelProvider)new UpdateManifestDataModelProvider());
            updateManifestDataModel.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)this.project.getName());
            updateManifestDataModel.setBooleanProperty("UpdateManifestDataModel.MERGE", false);
            updateManifestDataModel.setProperty("UpdateManifestDataModel.MANIFEST_FILE", (Object)this.getManifestIFile(this.rootComponent));
            ArrayList<String> asStrings = new ArrayList<String>();
            for (IVirtualReference tmp : this.list) {
                if (tmp.getArchiveName() == null) continue;
                if (tmp.getRuntimePath().toString().length() > 0) {
                    asStrings.add(tmp.getRuntimePath().append(tmp.getArchiveName()).toString());
                    continue;
                }
                asStrings.add(tmp.getArchiveName());
            }
            updateManifestDataModel.setProperty("UpdateManifestDataModel.CLASSPATH_LIST", asStrings);
            try {
                updateManifestDataModel.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {}
        }
        return true;
    }

    public void performDefaults() {
        this.refreshViewerFromNewParentProject();
    }

    public boolean performCancel() {
        return false;
    }

    public void setVisible(boolean visible) {
    }

    public void dispose() {
    }

    public void performApply() {
        IFile manifest = this.getManifestIFile(this.rootComponent);
        if (manifest == null) {
            this.previousManifest = null;
            this.addButton.setEnabled(false);
            this.performDefaults();
        } else {
            if (this.previousManifest == null) {
                this.performDefaults();
            } else {
                String currentManifest = manifest.getFullPath().toOSString();
                if (!this.previousManifest.equals(currentManifest)) {
                    this.performDefaults();
                }
            }
            this.previousManifest = manifest.getFullPath().toOSString();
            this.addButton.setEnabled(true);
        }
        this.updateButtons();
        this.performOk();
    }

    public static class DummyVirtualComponent
    extends AbstractResourceListVirtualComponent {
        private static final String DUMMY_FIRST_SEGMENT = "dummyVirtualComponent";

        public DummyVirtualComponent(IProject p, IVirtualComponent referencingComponent) {
            super(p, referencingComponent);
        }

        protected String getFirstIdSegment() {
            return DUMMY_FIRST_SEGMENT;
        }

        protected IContainer[] getUnderlyingContainers() {
            return new IContainer[0];
        }

        protected IResource[] getLooseResources() {
            return new IResource[0];
        }
    }

    private class ManifestContentProvider
    implements IStructuredContentProvider {
        private ManifestContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ManifestModuleDependencyControl.this.refsForCurrentProject == null ? new Object[]{} : ManifestModuleDependencyControl.this.refsForCurrentProject;
        }
    }

    public static class ManifestLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private IVirtualComponentLabelProvider[] delegates;

        protected void getDelegates() {
            if (this.delegates == null) {
                this.delegates = DependencyPageExtensionManager.loadDelegates();
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            this.getDelegates();
            if (columnIndex == 1 && element instanceof IVirtualReference) {
                int i = 0;
                while (i < this.delegates.length) {
                    if (this.delegates[i].canHandle(((IVirtualReference)element).getReferencedComponent())) {
                        return this.delegates[i].getSourceImage(((IVirtualReference)element).getReferencedComponent());
                    }
                    ++i;
                }
            }
            return ModuleCoreUIPlugin.getInstance().getImage("jar_obj");
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IVirtualReference) {
                IVirtualReference ref = (IVirtualReference)element;
                if (columnIndex == 0 && ref.getArchiveName() != null) {
                    if (ref.getRuntimePath().toString().length() > 0) {
                        return ref.getRuntimePath().append(ref.getArchiveName()).toString();
                    }
                    return ref.getArchiveName();
                }
                if (columnIndex == 1) {
                    return this.handleSourceText(ref.getReferencedComponent());
                }
            }
            return null;
        }

        private String handleSourceText(IVirtualComponent component) {
            this.getDelegates();
            int i = 0;
            while (i < this.delegates.length) {
                if (this.delegates[i].canHandle(component)) {
                    return this.delegates[i].getSourceText(component);
                }
                ++i;
            }
            if (component.isBinary()) {
                IPath p = (IPath)component.getAdapter(IPath.class);
                return p == null ? null : p.toString();
            }
            return component.getProject().getName();
        }
    }

    private static class TableViewerColumnSortToggler {
        private int sortDirection = 0;
        private int sortColumn = 0;
        private TableViewer tableViewer;

        private TableViewerColumnSortToggler(TableViewer tableViewer) {
            this.tableViewer = tableViewer;
        }

        private void toggleSort(int column) {
            if (this.sortColumn == column) {
                switch (this.sortDirection) {
                    case 0: {
                        this.sortDirection = 128;
                        break;
                    }
                    case 128: {
                        this.sortDirection = 1024;
                        break;
                    }
                    case 1024: {
                        this.sortDirection = 0;
                    }
                }
            } else {
                this.sortColumn = column;
                this.sortDirection = 128;
            }
            ViewerComparator comparator = this.getViewerComparator(column, this.sortDirection);
            this.tableViewer.setComparator(comparator);
            Table table = this.tableViewer.getTable();
            TableColumn sortColumn = this.tableViewer.getTable().getColumn(column);
            table.setSortColumn(sortColumn);
            table.setSortDirection(this.sortDirection);
        }

        private ViewerComparator getViewerComparator(final int columnIndex, final int sortDirection) {
            if (sortDirection == 0) {
                return null;
            }
            return new ViewerComparator(){
                Collator collator = Collator.getInstance();

                public int compare(Viewer viewerLocal, Object e1, Object e2) {
                    ITableLabelProvider tableLabelProvider;
                    String text1;
                    IBaseLabelProvider baseLabelProvider = TableViewerColumnSortToggler.this.tableViewer.getLabelProvider();
                    if (baseLabelProvider instanceof ITableLabelProvider && (text1 = (tableLabelProvider = (ITableLabelProvider)baseLabelProvider).getColumnText(e1, columnIndex)) != null) {
                        String text2 = tableLabelProvider.getColumnText(e2, columnIndex);
                        int comp = this.collator.compare(text1, text2);
                        if (sortDirection == 1024) {
                            comp = -comp;
                        }
                        return comp;
                    }
                    return 0;
                }
            };
        }
    }
}

