/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.core.internal.utility.jdt.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.MemberIndexedAnnotationAdapter;
import org.eclipse.jpt.core.internal.utility.jdt.NestedIndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.NestableAnnotation;
import org.eclipse.jpt.core.resource.java.NestableQueryHintAnnotation;
import org.eclipse.jpt.core.resource.java.QueryHintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.utility.jdt.Member;
import org.eclipse.jpt.core.utility.jdt.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceQueryHintAnnotation
extends SourceAnnotation<Type>
implements NestableQueryHintAnnotation {
    private final DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter;
    private final AnnotationElementAdapter<String> nameAdapter;
    private String name;
    private final DeclarationAnnotationElementAdapter<String> valueDeclarationAdapter;
    private final AnnotationElementAdapter<String> valueAdapter;
    private String value;

    public SourceQueryHintAnnotation(JavaResourceNode parent, Type type, IndexedDeclarationAnnotationAdapter idaa) {
        super(parent, type, idaa, new MemberIndexedAnnotationAdapter((Member)type, idaa));
        this.nameDeclarationAdapter = this.buildNameAdapter(idaa);
        this.nameAdapter = this.buildAdapter(this.nameDeclarationAdapter);
        this.valueDeclarationAdapter = this.buildValueAdapter(idaa);
        this.valueAdapter = this.buildAdapter(this.valueDeclarationAdapter);
    }

    @Override
    public String getAnnotationName() {
        return "javax.persistence.QueryHint";
    }

    private AnnotationElementAdapter<String> buildAdapter(DeclarationAnnotationElementAdapter<String> daea) {
        return new MemberAnnotationElementAdapter<String>(this.member, daea);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(adapter, "name");
    }

    private DeclarationAnnotationElementAdapter<String> buildValueAdapter(DeclarationAnnotationAdapter adapter) {
        return ConversionDeclarationAnnotationElementAdapter.forStrings(adapter, "value");
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.value = this.buildValue(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncValue(this.buildValue(astRoot));
    }

    public IndexedAnnotationAdapter getIndexedAnnotationAdapter() {
        return (IndexedAnnotationAdapter)this.annotationAdapter;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue(name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        if (this.attributeValueHasChanged(this.value, value)) {
            this.value = value;
            this.valueAdapter.setValue(value);
        }
    }

    private void syncValue(String astValue) {
        String old = this.value;
        this.value = astValue;
        this.firePropertyChanged("value", old, astValue);
    }

    private String buildValue(CompilationUnit astRoot) {
        return this.valueAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getValueTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.valueDeclarationAdapter, astRoot);
    }

    @Override
    public void initializeFrom(NestableAnnotation oldAnnotation) {
        QueryHintAnnotation oldHint = (QueryHintAnnotation)((Object)oldAnnotation);
        this.setName(oldHint.getName());
        this.setValue(oldHint.getValue());
    }

    @Override
    public void moveAnnotation(int newIndex) {
        this.getIndexedAnnotationAdapter().moveAnnotation(newIndex);
    }

    static SourceQueryHintAnnotation createNamedQueryQueryHint(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new SourceQueryHintAnnotation(parent, type, SourceQueryHintAnnotation.buildNamedQueryQueryHintAnnotationAdapter(namedQueryAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedQueryAdapter, "hints", index, "javax.persistence.QueryHint");
    }

    static SourceQueryHintAnnotation createNamedNativeQueryQueryHint(JavaResourceNode parent, Type type, DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new SourceQueryHintAnnotation(parent, type, SourceQueryHintAnnotation.buildNamedNativeQueryQueryHintAnnotationAdapter(namedNativeQueryAdapter, index));
    }

    private static IndexedDeclarationAnnotationAdapter buildNamedNativeQueryQueryHintAnnotationAdapter(DeclarationAnnotationAdapter namedNativeQueryAdapter, int index) {
        return new NestedIndexedDeclarationAnnotationAdapter(namedNativeQueryAdapter, "hints", index, "javax.persistence.QueryHint");
    }
}

