/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.CollectionMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmAttributeMappingDefinition;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.jpa2.context.MetamodelField;
import org.eclipse.jpt.core.jpa2.context.java.JavaPersistentAttribute2_0;
import org.eclipse.jpt.core.jpa2.context.orm.OrmPersistentAttribute2_0;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmPersistentAttribute
extends AbstractOrmXmlContextNode
implements OrmPersistentAttribute2_0 {
    protected final OrmPersistentAttribute.Owner owner;
    protected OrmAttributeMapping attributeMapping;
    protected JavaPersistentAttribute javaPersistentAttribute;
    protected AccessType defaultAccess;

    protected AbstractOrmPersistentAttribute(OrmPersistentType parent, OrmPersistentAttribute.Owner owner, XmlAttributeMapping resourceMapping) {
        super(parent);
        this.owner = owner;
        this.attributeMapping = this.buildAttributeMapping(resourceMapping);
        this.javaPersistentAttribute = this.findJavaPersistentAttribute();
        this.defaultAccess = this.buildDefaultAccess();
    }

    public XmlAttributeMapping getResourceAttributeMapping() {
        return this.attributeMapping.getResourceAttributeMapping();
    }

    @Override
    public JavaPersistentAttribute getJavaPersistentAttribute() {
        return this.javaPersistentAttribute;
    }

    protected void setJavaPersistentAttribute(JavaPersistentAttribute javaPersistentAttribute) {
        JavaPersistentAttribute old = this.javaPersistentAttribute;
        this.javaPersistentAttribute = javaPersistentAttribute;
        this.firePropertyChanged("javaPersistentAttribute", old, javaPersistentAttribute);
    }

    protected OrmAttributeMapping buildAttributeMapping(XmlAttributeMapping resourceMapping) {
        OrmAttributeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getOrmAttributeMappingDefinition(resourceMapping.getMappingKey());
        return mappingDefinition.buildContextMapping(this, resourceMapping, this.getXmlContextNodeFactory());
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentAttribute";
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess() != null ? this.getSpecifiedAccess() : this.getDefaultAccess();
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType newAccess) {
        AccessType old = this.defaultAccess;
        this.defaultAccess = newAccess;
        this.firePropertyChanged("defaultAccess", (Object)old, (Object)this.defaultAccess);
    }

    @Override
    public String getName() {
        return this.attributeMapping.getName();
    }

    @Override
    public void nameChanged(String oldName, String newName) {
        this.firePropertyChanged("name", oldName, newName);
    }

    @Override
    public OrmAttributeMapping getSpecifiedMapping() {
        return this.attributeMapping;
    }

    @Override
    public OrmAttributeMapping getMapping() {
        return this.attributeMapping;
    }

    @Override
    public String getMappingKey() {
        return this.attributeMapping.getKey();
    }

    @Override
    public String getDefaultMappingKey() {
        return null;
    }

    @Override
    public void setSpecifiedMappingKey(String newMappingKey) {
        if (this.valuesAreEqual(this.getMappingKey(), newMappingKey)) {
            return;
        }
        OrmAttributeMapping oldMapping = this.attributeMapping;
        OrmAttributeMappingDefinition mappingDefinition = this.getMappingFileDefinition().getOrmAttributeMappingDefinition(newMappingKey);
        XmlAttributeMapping resourceAttributeMapping = mappingDefinition.buildResourceMapping(this.getResourceNodeFactory());
        this.attributeMapping = this.buildAttributeMapping(resourceAttributeMapping);
        this.getOwningPersistentType().changeMapping(this, oldMapping, this.attributeMapping);
        this.firePropertyChanged("specifiedMapping", oldMapping, this.attributeMapping);
    }

    @Override
    public OrmPersistentType getOwningPersistentType() {
        return (OrmPersistentType)this.getParent();
    }

    @Override
    public OrmTypeMapping getOwningTypeMapping() {
        return this.getOwningPersistentType().getMapping();
    }

    @Override
    public boolean isVirtual() {
        return this.getOwningPersistentType().containsVirtualAttribute(this);
    }

    @Override
    public void makeVirtual() {
        if (this.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        this.getOwningPersistentType().makeAttributeVirtual(this);
    }

    @Override
    public void makeSpecified() {
        if (!this.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (this.getMappingKey() == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            throw new IllegalStateException("Use makeSpecified(String) instead and specify a mapping type");
        }
        this.getOwningPersistentType().makeAttributeSpecified(this);
    }

    @Override
    public void makeSpecified(String mappingKey) {
        if (!this.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        this.getOwningPersistentType().makeAttributeSpecified(this, mappingKey);
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return this.attributeMapping.getPrimaryKeyColumnName();
    }

    @Override
    public String getTypeName() {
        JavaPersistentAttribute javaAttribute = this.getJavaPersistentAttribute();
        return javaAttribute == null ? null : javaAttribute.getTypeName();
    }

    @Override
    public void update() {
        this.attributeMapping.update();
        this.setJavaPersistentAttribute(this.findJavaPersistentAttribute());
        this.owner.updateJavaPersistentAttribute();
        this.setDefaultAccess(this.buildDefaultAccess());
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.getMapping().postUpdate();
    }

    protected JavaPersistentAttribute findJavaPersistentAttribute() {
        return this.owner.findJavaPersistentAttribute(this);
    }

    protected AccessType buildDefaultAccess() {
        return this.getOwningPersistentType().getAccess();
    }

    @Override
    public JpaStructureNode getStructureNode(int offset) {
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        if (this.isVirtual()) {
            return false;
        }
        return this.attributeMapping.contains(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        if (this.isVirtual()) {
            return null;
        }
        return this.attributeMapping.getSelectionTextRange();
    }

    @Override
    public void dispose() {
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateAttribute(messages);
        this.validateModifiers(messages);
        this.attributeMapping.validate(messages, reporter);
    }

    protected void validateAttribute(List<IMessage> messages) {
        if (this.javaPersistentAttribute == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_ATTRIBUTE_UNRESOLVED_NAME", new String[]{this.getName(), this.getOwningPersistentType().getMapping().getClass_()}, this.attributeMapping, this.attributeMapping.getNameTextRange()));
        }
    }

    protected void validateModifiers(List<IMessage> messages) {
        if (this.getMappingKey() == "transient") {
            return;
        }
        if (this.javaPersistentAttribute == null) {
            return;
        }
        if (this.javaPersistentAttribute.isField()) {
            if (this.javaPersistentAttribute.isFinal()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_FINAL_FIELD"));
            }
            if (this.javaPersistentAttribute.isPublic()) {
                messages.add(this.buildAttributeMessage("PERSISTENT_ATTRIBUTE_PUBLIC_FIELD"));
            }
        }
    }

    protected IMessage buildAttributeMessage(String msgID) {
        return DefaultJpaValidationMessages.buildMessage(1, msgID, new String[]{this.getName()}, this, this.getValidationTextRange());
    }

    @Override
    public TextRange getValidationTextRange() {
        if (this.isVirtual()) {
            return this.getOwningPersistentType().getMapping().getAttributesTextRange();
        }
        return this.attributeMapping.getValidationTextRange();
    }

    @Override
    public String getMetamodelContainerFieldTypeName() {
        return this.getJpaContainer().getMetamodelContainerFieldTypeName();
    }

    @Override
    public String getMetamodelContainerFieldMapKeyTypeName() {
        return this.getJpaContainer().getMetamodelContainerFieldMapKeyTypeName((CollectionMapping)((Object)this.getMapping()));
    }

    @Override
    public String getMetamodelTypeName() {
        JavaPersistentAttribute2_0 javaAttribute = (JavaPersistentAttribute2_0)this.getJavaPersistentAttribute();
        return javaAttribute == null ? MetamodelField.DEFAULT_TYPE_NAME : javaAttribute.getMetamodelTypeName();
    }

    protected JavaPersistentAttribute.JpaContainer getJpaContainer() {
        JavaPersistentAttribute2_0 javaAttribute = (JavaPersistentAttribute2_0)this.getJavaPersistentAttribute();
        return javaAttribute == null ? JavaPersistentAttribute.JpaContainer.Null.instance() : javaAttribute.getJpaContainer();
    }
}

