/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.jst.common.project.facet.core.internal.JavaFacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectValidator;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public final class JavaFacetValidator
implements IFacetedProjectValidator {
    public static final String MARKER_ID = "org.eclipse.jst.common.project.facet.core.javaVersionMismatch";
    public static final String ATTR_FACET_VERSION = "facetVersion";
    public static final String ATTR_COMPILER_LEVEL = "compilerLevel";

    public void validate(IFacetedProject fproj) throws CoreException {
        String level = JavaFacetUtil.getCompilerLevel(fproj.getProject());
        IProjectFacetVersion fv = fproj.getInstalledVersion(JavaFacet.FACET);
        if (!JavaFacet.FACET.hasVersion(level) || JavaFacet.FACET.getVersion(level) != fv) {
            IMarker marker = fproj.createErrorMarker(MARKER_ID, Resources.versionsDontMatch);
            marker.setAttribute(ATTR_FACET_VERSION, (Object)fv.getVersionString());
            marker.setAttribute(ATTR_COMPILER_LEVEL, (Object)level);
        }
    }

    private static final class Resources
    extends NLS {
        public static String versionsDontMatch;

        static {
            Resources.initializeMessages((String)JavaFacetValidator.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

