/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.internal.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.CallbackJobSynchronizer;
import org.eclipse.jpt.common.core.internal.utility.JobCommand;
import org.eclipse.jpt.common.core.internal.utility.JobSynchronizer;
import org.eclipse.jpt.common.utility.Command;
import org.eclipse.jpt.common.utility.internal.AsynchronousCommandExecutor;
import org.eclipse.jpt.common.utility.internal.SimpleCommandExecutor;
import org.eclipse.jpt.common.utility.internal.StatefulCommandExecutor;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.SynchronizedBoolean;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.synchronizers.CallbackSynchronizer;
import org.eclipse.jpt.common.utility.synchronizers.Synchronizer;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.JptCoreMessages;
import org.eclipse.jpt.jpa.core.internal.SimpleJpaProjectConfig;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericJpaProjectManager
extends AbstractModel
implements JpaProjectManager {
    private final Vector<JpaProject> jpaProjects = new Vector();
    final ILock lock = this.getJobManager().newLock();
    private volatile StatefulCommandExecutor eventHandler = new AsynchronousCommandExecutor(JptCommonCoreMessages.DALI_EVENT_HANDLER_THREAD_NAME);
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private static final int RESOURCE_CHANGE_EVENT_TYPES = 17;
    private static final String FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME = "org.eclipse.wst.common.project.facet.core.xml";
    private final IFacetedProjectListener facetedProjectListener = new FacetedProjectListener();
    private static final IFacetedProjectEvent.Type[] FACETED_PROJECT_EVENT_TYPES = new IFacetedProjectEvent.Type[]{IFacetedProjectEvent.Type.PRE_UNINSTALL};
    private final JavaElementChangeListener javaElementChangeListener = new JavaElementChangeListener();
    private static final int JAVA_CHANGE_EVENT_TYPES = 5;
    private static final boolean DEBUG = false;

    GenericJpaProjectManager() {
    }

    void start() {
        try {
            this.lock.acquire();
            this.start_();
        }
        finally {
            this.lock.release();
        }
    }

    private void start_() {
        GenericJpaProjectManager.debug("*** JPA project manager START ***");
        try {
            this.buildJpaProjects();
            this.eventHandler.start();
            this.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 17);
            FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetedProjectListener, (IFacetedProjectEvent.Type[])FACETED_PROJECT_EVENT_TYPES);
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener, (int)5);
        }
        catch (RuntimeException ex) {
            JptJpaCorePlugin.log(ex);
            this.stop_();
        }
    }

    private void buildJpaProjects() {
        try {
            this.getWorkspace().getRoot().accept((IResourceProxyVisitor)new ResourceProxyVisitor(), 0);
        }
        catch (Exception ex) {
            JptJpaCorePlugin.log(ex);
        }
    }

    void stop() throws Exception {
        try {
            this.lock.acquire();
            this.stop_();
        }
        finally {
            this.lock.release();
        }
    }

    private void stop_() {
        GenericJpaProjectManager.debug("*** JPA project manager STOP ***");
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetedProjectListener);
        this.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.eventHandler.stop();
        this.clearJpaProjects();
    }

    private void clearJpaProjects() {
        for (JpaProject jpaProject : this.getJpaProjects_()) {
            this.removeJpaProject(jpaProject);
        }
    }

    @Override
    public Iterable<JpaProject> getJpaProjects() {
        try {
            this.lock.acquire();
            Iterable<JpaProject> iterable = this.getJpaProjects_();
            return iterable;
        }
        finally {
            this.lock.release();
        }
    }

    private Iterable<JpaProject> getJpaProjects_() {
        return new LiveCloneIterable(this.jpaProjects);
    }

    @Override
    public int getJpaProjectsSize() {
        return this.jpaProjects.size();
    }

    @Override
    public JpaProject getJpaProject(IProject project) {
        try {
            this.lock.acquire();
            JpaProject jpaProject = this.getJpaProject_(project);
            return jpaProject;
        }
        finally {
            this.lock.release();
        }
    }

    private JpaProject getJpaProject_(IProject project) {
        for (JpaProject jpaProject : this.jpaProjects) {
            if (!jpaProject.getProject().equals((Object)project)) continue;
            return jpaProject;
        }
        return null;
    }

    @Override
    public JpaFile getJpaFile(IFile file) {
        JpaProject jpaProject = this.getJpaProject(file.getProject());
        return jpaProject == null ? null : jpaProject.getJpaFile(file);
    }

    @Override
    public void rebuildJpaProject(IProject project) {
        try {
            this.lock.acquire();
            this.rebuildJpaProject_(project);
        }
        finally {
            this.lock.release();
        }
    }

    private void rebuildJpaProject_(IProject project) {
        this.removeJpaProject(this.getJpaProject_(project));
        this.addJpaProject(project);
    }

    @Override
    public boolean javaElementChangeListenerIsActive() {
        return this.javaElementChangeListener.isActive();
    }

    @Override
    public void setJavaElementChangeListenerIsActive(boolean javaElementChangeListenerIsActive) {
        this.javaElementChangeListener.setActive(javaElementChangeListenerIsActive);
    }

    public IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public IJobManager getJobManager() {
        return Job.getJobManager();
    }

    void addJpaProject(IProject project) {
        this.addJpaProject(this.buildJpaProject(project));
    }

    private void addJpaProject(JpaProject jpaProject) {
        GenericJpaProjectManager.dumpStackTrace("add: ", jpaProject);
        if (jpaProject != null) {
            this.addItemToCollection(jpaProject, this.jpaProjects, "jpaProjects");
        }
    }

    private JpaProject buildJpaProject(IProject project) {
        return this.buildJpaProject(this.buildJpaProjectConfig(project));
    }

    private JpaProject buildJpaProject(JpaProject.Config config) {
        JpaPlatform jpaPlatform = config.getJpaPlatform();
        if (jpaPlatform == null) {
            return null;
        }
        JpaProject jpaProject = this.buildJpaProject(jpaPlatform, config);
        if (jpaProject == null) {
            return null;
        }
        jpaProject.setContextModelSynchronizer(this.buildJobContextModelSynchronizer(jpaProject));
        jpaProject.setUpdateSynchronizer(this.buildJobUpdateSynchronizer(jpaProject));
        return jpaProject;
    }

    private JpaProject buildJpaProject(JpaPlatform jpaPlatform, JpaProject.Config config) {
        try {
            return jpaPlatform.getJpaFactory().buildJpaProject(config);
        }
        catch (RuntimeException ex) {
            JptJpaCorePlugin.log(ex);
            return null;
        }
    }

    private JpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setProject(project);
        config.setJpaPlatform(JptJpaCorePlugin.getJpaPlatformManager().buildJpaPlatformImplementation(project));
        config.setConnectionProfileName(JptJpaCorePlugin.getConnectionProfileName(project));
        config.setUserOverrideDefaultCatalog(JptJpaCorePlugin.getUserOverrideDefaultCatalog(project));
        config.setUserOverrideDefaultSchema(JptJpaCorePlugin.getUserOverrideDefaultSchema(project));
        config.setDiscoverAnnotatedClasses(JptJpaCorePlugin.discoverAnnotatedClasses(project));
        config.setMetamodelSourceFolderName(JptJpaCorePlugin.getMetamodelSourceFolderName(project));
        return config;
    }

    private Synchronizer buildJobContextModelSynchronizer(JpaProject jpaProject) {
        return new JobSynchronizer(this.buildContextModelJobName(jpaProject), this.buildContextModelJobCommand(jpaProject), (ISchedulingRule)jpaProject.getProject());
    }

    private String buildContextModelJobName(JpaProject jpaProject) {
        return NLS.bind((String)JptCoreMessages.CONTEXT_MODEL_SYNC_JOB_NAME, (Object)jpaProject.getName());
    }

    private JobCommand buildContextModelJobCommand(final JpaProject jpaProject) {
        return new JobCommand(){

            public IStatus execute(IProgressMonitor monitor) {
                return jpaProject.synchronizeContextModel(monitor);
            }
        };
    }

    private CallbackSynchronizer buildJobUpdateSynchronizer(JpaProject jpaProject) {
        return new CallbackJobSynchronizer(this.buildUpdateJobName(jpaProject), this.buildUpdateJobCommand(jpaProject), (ISchedulingRule)jpaProject.getProject());
    }

    private String buildUpdateJobName(JpaProject jpaProject) {
        return NLS.bind((String)JptCoreMessages.UPDATE_JOB_NAME, (Object)jpaProject.getName());
    }

    private JobCommand buildUpdateJobCommand(final JpaProject jpaProject) {
        return new JobCommand(){

            public IStatus execute(IProgressMonitor monitor) {
                return jpaProject.update(monitor);
            }
        };
    }

    void removeJpaProject(JpaProject jpaProject) {
        GenericJpaProjectManager.dumpStackTrace("remove: ", jpaProject);
        this.removeItemFromCollection(jpaProject, this.jpaProjects, "jpaProjects");
        jpaProject.dispose();
    }

    void projectChanged(IResourceDelta delta) {
        this.eventHandler.execute(this.buildProjectChangedCommand(delta));
    }

    private Command buildProjectChangedCommand(final IResourceDelta delta) {
        return new EventHandlerCommand("Project POST_CHANGE Command"){

            void execute_() {
                GenericJpaProjectManager.this.projectChanged_(delta);
            }
        };
    }

    void projectChanged_(IResourceDelta delta) {
        for (JpaProject jpaProject : this.jpaProjects) {
            jpaProject.projectChanged(delta);
        }
    }

    void projectPostCleanBuild(IProject project) {
        this.executeAfterEventsHandled(this.buildProjectPostCleanBuildCommand(project));
    }

    private Command buildProjectPostCleanBuildCommand(final IProject project) {
        return new EventHandlerCommand("Project POST_BUILD (CLEAN_BUILD) Command"){

            void execute_() {
                GenericJpaProjectManager.this.projectPostCleanBuild_(project);
            }
        };
    }

    void projectPostCleanBuild_(IProject project) {
        JpaProject jpaProject = this.getJpaProject_(project);
        if (jpaProject != null) {
            this.removeJpaProject(jpaProject);
            this.addJpaProject(project);
        }
    }

    void checkForJpaFacetTransition(IProject project) {
        JpaProject jpaProject = this.getJpaProject_(project);
        if (JpaFacet.isInstalled(project)) {
            if (jpaProject == null) {
                this.executeAfterEventsHandled(this.buildAddJpaProjectCommand(project));
            }
        } else if (jpaProject != null) {
            this.executeAfterEventsHandled(this.buildRemoveJpaProjectCommand(jpaProject));
        }
    }

    private Command buildAddJpaProjectCommand(final IProject project) {
        return new EventHandlerCommand("Add JPA Project Command"){

            void execute_() {
                GenericJpaProjectManager.this.addJpaProject(project);
            }
        };
    }

    private Command buildRemoveJpaProjectCommand(final JpaProject jpaProject) {
        return new EventHandlerCommand("Remove JPA Project Command"){

            void execute_() {
                GenericJpaProjectManager.this.removeJpaProject(jpaProject);
            }
        };
    }

    void jpaFacetedProjectPreUninstall(IProjectFacetActionEvent event) {
        IProject project = event.getProject().getProject();
        this.executeAfterEventsHandled(this.buildJpaFacetedProjectPreUninstallCommand(project));
    }

    private Command buildJpaFacetedProjectPreUninstallCommand(final IProject project) {
        return new EventHandlerCommand("Faceted Project PRE_UNINSTALL Command"){

            void execute_() {
                GenericJpaProjectManager.this.jpaFacetedProjectPreUninstall_(project);
            }
        };
    }

    void jpaFacetedProjectPreUninstall_(IProject project) {
        this.removeJpaProject(this.getJpaProject_(project));
    }

    void javaElementChanged(ElementChangedEvent event) {
        this.eventHandler.execute(this.buildJavaElementChangedCommand(event));
    }

    private Command buildJavaElementChangedCommand(final ElementChangedEvent event) {
        return new EventHandlerCommand("Java element changed Command"){

            void execute_() {
                GenericJpaProjectManager.this.javaElementChanged_(event);
            }
        };
    }

    void javaElementChanged_(ElementChangedEvent event) {
        for (JpaProject jpaProject : this.jpaProjects) {
            jpaProject.javaElementChanged(event);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.jpaProjects);
    }

    private void executeAfterEventsHandled(Command command) {
        SynchronizedBoolean flag = new SynchronizedBoolean(false);
        this.eventHandler.execute((Command)new PauseCommand(flag));
        try {
            flag.waitUntilTrue();
        }
        catch (InterruptedException interruptedException) {}
        try {
            command.execute();
        }
        finally {
            flag.setFalse();
        }
    }

    private void handleEventsSynchronously() {
        try {
            this.lock.acquire();
            this.handleEventsSynchronously_();
        }
        finally {
            this.lock.release();
        }
    }

    private void handleEventsSynchronously_() {
        this.eventHandler.stop();
        this.eventHandler = new SimpleCommandExecutor();
        this.eventHandler.start();
    }

    static void debug(String message, Object object) {
    }

    static void debug(String message) {
    }

    private static void debug_(String message) {
        System.out.println(String.valueOf(Thread.currentThread().getName()) + ": " + message);
    }

    static void dumpStackTrace() {
        GenericJpaProjectManager.dumpStackTrace(null);
    }

    static void dumpStackTrace(String message, Object object) {
    }

    static void dumpStackTrace(String message) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpStackTrace_(String message) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            if (message != null) {
                GenericJpaProjectManager.debug_(message);
            }
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 3;
            while (i < stackTrace.length) {
                StackTraceElement element = stackTrace[i];
                if (element.getMethodName().equals("invoke0")) break;
                System.out.println("\t" + element);
                ++i;
            }
        }
    }

    private abstract class EventHandlerCommand
    implements Command {
        private final String name;

        EventHandlerCommand(String name) {
            this.name = name;
        }

        public final void execute() {
            try {
                try {
                    GenericJpaProjectManager.this.lock.acquire();
                    this.execute_();
                }
                catch (RuntimeException ex) {
                    JptJpaCorePlugin.log(ex);
                    GenericJpaProjectManager.this.lock.release();
                }
            }
            finally {
                GenericJpaProjectManager.this.lock.release();
            }
        }

        abstract void execute_();

        public String toString() {
            return this.name;
        }
    }

    private class FacetedProjectListener
    implements IFacetedProjectListener {
        FacetedProjectListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            switch (event.getType()) {
                case PRE_UNINSTALL: {
                    this.processPreUninstallEvent((IProjectFacetActionEvent)event);
                    break;
                }
            }
        }

        private void processPreUninstallEvent(IProjectFacetActionEvent event) {
            GenericJpaProjectManager.debug("Facet PRE_UNINSTALL: ", event.getProjectFacet());
            if (event.getProjectFacet().equals(JpaFacet.FACET)) {
                GenericJpaProjectManager.this.jpaFacetedProjectPreUninstall(event);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        private volatile boolean active = true;

        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.active) {
                GenericJpaProjectManager.this.javaElementChanged(event);
            }
        }

        void setActive(boolean active) {
            this.active = active;
        }

        boolean isActive() {
            return this.active;
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private static class PauseCommand
    implements Command {
        private final Thread producerThread;
        private final SynchronizedBoolean flag;

        PauseCommand(SynchronizedBoolean flag) {
            this(Thread.currentThread(), flag);
        }

        PauseCommand(Thread producerThread, SynchronizedBoolean flag) {
            this.producerThread = producerThread;
            this.flag = flag;
        }

        public void execute() {
            this.flag.setTrue();
            if (Thread.currentThread() != this.producerThread) {
                try {
                    this.flag.waitUntilFalse();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.processPostChangeEvent(event);
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    this.processPostBuildEvent(event);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }

        private void processPostChangeEvent(IResourceChangeEvent event) {
            GenericJpaProjectManager.debug("Resource POST_CHANGE");
            this.processPostChangeDelta(event.getDelta());
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeRootDelta(delta);
                    break;
                }
                case 4: {
                    this.processPostChangeProjectDelta(delta);
                    break;
                }
                case 2: {
                    this.processPostChangeFolderDelta((IFolder)resource, delta);
                    break;
                }
                case 1: {
                    this.processPostChangeFileDelta((IFile)resource, delta);
                    break;
                }
            }
        }

        private void processPostChangeRootDelta(IResourceDelta delta) {
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeProjectDelta(IResourceDelta delta) {
            GenericJpaProjectManager.this.projectChanged(delta);
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeFolderDelta(IFolder folder, IResourceDelta delta) {
            if (folder.getName().equals(".settings")) {
                this.processPostChangeDeltaChildren(delta);
            }
        }

        private void processPostChangeFileDelta(IFile file, IResourceDelta delta) {
            if (file.getName().equals(GenericJpaProjectManager.FACETED_PROJECT_FRAMEWORK_SETTINGS_FILE_NAME)) {
                this.checkForFacetFileChanges(file, delta);
            }
        }

        private void checkForFacetFileChanges(IFile file, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    GenericJpaProjectManager.this.checkForJpaFacetTransition(file.getProject());
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void processPostBuildEvent(IResourceChangeEvent event) {
            GenericJpaProjectManager.debug("Resource POST_BUILD: ", event.getResource());
            if (event.getBuildKind() == 15) {
                this.processPostCleanBuildDelta(event.getDelta());
            }
        }

        private void processPostCleanBuildDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostCleanBuildDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processProjectPostCleanBuild((IProject)resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }

        private void processPostCleanBuildDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostCleanBuildDelta(child);
                ++n2;
            }
        }

        private void processProjectPostCleanBuild(IProject project) {
            GenericJpaProjectManager.debug("\tProject CLEAN: ", project.getName());
            GenericJpaProjectManager.this.projectPostCleanBuild(project);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        ResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) {
            switch (resourceProxy.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    this.processProject(resourceProxy);
                    return false;
                }
                case 2: {
                    return false;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }

        private void processProject(IResourceProxy resourceProxy) {
            IProject project;
            if (resourceProxy.isAccessible() && JpaFacet.isInstalled(project = (IProject)resourceProxy.requestResource())) {
                GenericJpaProjectManager.this.addJpaProject(project);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

