/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.properties;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jpt.core.JpaDataSource;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.JptCoreMessages;
import org.eclipse.jpt.core.internal.platform.JpaPlatformRegistry;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.ConnectionAdapter;
import org.eclipse.jpt.db.ConnectionListener;
import org.eclipse.jpt.db.ConnectionProfile;
import org.eclipse.jpt.db.ConnectionProfileListener;
import org.eclipse.jpt.db.Database;
import org.eclipse.jpt.db.JptDbPlugin;
import org.eclipse.jpt.db.SchemaContainer;
import org.eclipse.jpt.db.ui.internal.DTPUiTools;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.swt.BooleanButtonModelAdapter;
import org.eclipse.jpt.ui.internal.swt.ComboModelAdapter;
import org.eclipse.jpt.ui.internal.util.ControlEnabler;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.utility.internal.model.value.AspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.BufferedWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.CollectionListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.CompositeCollectionValueModel;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ExtendedListValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.ListPropertyValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.PropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.SortedListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.utility.model.listener.ChangeListener;
import org.eclipse.jpt.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryInstallDelegate;
import org.eclipse.jst.common.project.facet.ui.libprov.LibraryFacetPropertyPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectBase;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProjectPropertiesPage
extends LibraryFacetPropertyPage {
    public static final String PROP_ID = "org.eclipse.jpt.ui.jpaProjectPropertiesPage";
    private WritablePropertyValueModel<IProject> projectHolder;
    private PropertyValueModel<JpaProject> jpaProjectHolder;
    private BufferedWritablePropertyValueModel.Trigger trigger;
    private PropertyChangeListener validationListener;
    private PropertyChangeListener overrideDefaultCatalogListener;
    private PropertyChangeListener overrideDefaultSchemaListener;
    private PropertyChangeListener platformChangelistener;
    private BufferedWritablePropertyValueModel<String> platformIdModel;
    private BufferedWritablePropertyValueModel<String> connectionModel;
    private ListValueModel<String> connectionChoicesModel;
    private PropertyValueModel<ConnectionProfile> connectionProfileModel;
    private BufferedWritablePropertyValueModel<Boolean> overrideDefaultCatalogModel;
    private BufferedWritablePropertyValueModel<String> defaultCatalogModel;
    private WritablePropertyValueModel<String> combinedDefaultCatalogModel;
    private ListValueModel<String> catalogChoicesModel;
    private BufferedWritablePropertyValueModel<Boolean> overrideDefaultSchemaModel;
    private BufferedWritablePropertyValueModel<String> defaultSchemaModel;
    private WritablePropertyValueModel<String> combinedDefaultSchemaModel;
    private ListValueModel<String> schemaChoicesModel;
    private BufferedWritablePropertyValueModel<Boolean> discoverAnnotatedClassesModel;
    private WritablePropertyValueModel<Boolean> listAnnotatedClassesModel;

    public JpaProjectPropertiesPage() {
        this.initialize();
    }

    protected void initialize() {
        this.projectHolder = new SimplePropertyValueModel();
        this.jpaProjectHolder = this.initializeJpaProjectHolder();
        this.trigger = new BufferedWritablePropertyValueModel.Trigger();
        this.validationListener = this.initializeValidationListener();
        this.overrideDefaultCatalogListener = this.initializeOverrideDefaultCatalogChangeListener();
        this.overrideDefaultSchemaListener = this.initializeOverrideDefaultSchemaChangeListener();
        this.platformChangelistener = this.initializePlatformChangeListener();
        this.platformIdModel = this.initializePlatformIdModel();
        this.connectionModel = this.initializeConnectionModel();
        this.connectionChoicesModel = this.initializeConnectionChoicesModel();
        this.connectionProfileModel = this.initializeConnectionProfileModel();
        this.overrideDefaultCatalogModel = this.initializeOverrideDefaultCatalogModel();
        this.defaultCatalogModel = this.initializeDefaultCatalogModel();
        this.combinedDefaultCatalogModel = this.initializeCombinedDefaultCatalogModel();
        this.catalogChoicesModel = this.initializeCatalogChoicesModel();
        this.overrideDefaultSchemaModel = this.initializeOverrideDefaultSchemaModel();
        this.defaultSchemaModel = this.initializeDefaultSchemaModel();
        this.combinedDefaultSchemaModel = this.initializeCombinedDefaultSchemaModel();
        this.schemaChoicesModel = this.initializeSchemaChoicesModel();
        this.discoverAnnotatedClassesModel = this.initializeDiscoverAnnotatedClassesModel();
        this.listAnnotatedClassesModel = this.initializeListAnnotatedClassesModel();
    }

    protected PropertyValueModel<JpaProject> initializeJpaProjectHolder() {
        return new JpaProjectHolder((PropertyValueModel)this.projectHolder);
    }

    protected PropertyChangeListener initializeValidationListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                if (!JpaProjectPropertiesPage.this.getControl().isDisposed()) {
                    JpaProjectPropertiesPage.this.updateValidation();
                }
            }
        };
    }

    protected PropertyChangeListener initializeOverrideDefaultCatalogChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Boolean enabled = (Boolean)event.getNewValue();
                if (!enabled.booleanValue()) {
                    JpaProjectPropertiesPage.this.defaultCatalogModel.setValue(null);
                }
            }
        };
    }

    protected PropertyChangeListener initializeOverrideDefaultSchemaChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                Boolean enabled = (Boolean)event.getNewValue();
                if (!enabled.booleanValue()) {
                    JpaProjectPropertiesPage.this.defaultSchemaModel.setValue(null);
                }
            }
        };
    }

    protected PropertyChangeListener initializePlatformChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                if (!JpaProjectPropertiesPage.this.getControl().isDisposed()) {
                    JpaProjectPropertiesPage.this.getLibraryInstallDelegate().setEnablementContextVariable("jpaPlatform", event.getNewValue());
                }
            }
        };
    }

    protected BufferedWritablePropertyValueModel<String> initializePlatformIdModel() {
        BufferedWritablePropertyValueModel model = new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new PlatformIdModel(this.jpaProjectHolder), (PropertyValueModel)this.trigger);
        model.addPropertyChangeListener("value", this.validationListener);
        model.addPropertyChangeListener("value", this.platformChangelistener);
        return model;
    }

    protected BufferedWritablePropertyValueModel<String> initializeConnectionModel() {
        BufferedWritablePropertyValueModel model = new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new ConnectionModel(this.jpaProjectHolder), (PropertyValueModel)this.trigger);
        model.addPropertyChangeListener("value", this.validationListener);
        return model;
    }

    protected ListValueModel<String> initializeConnectionChoicesModel() {
        return new ExtendedListValueModelWrapper(null, (ListValueModel)new SortedListValueModelAdapter((ListValueModel)new CollectionListValueModelAdapter((CollectionValueModel)new ConnectionChoicesModel((PropertyValueModel)this.projectHolder))));
    }

    protected PropertyValueModel<ConnectionProfile> initializeConnectionProfileModel() {
        return new CachingTransformationPropertyValueModel<String, ConnectionProfile>(this.connectionModel){

            protected ConnectionProfile transform_(String value) {
                return JptDbPlugin.instance().getConnectionProfileFactory().buildConnectionProfile(value);
            }
        };
    }

    protected BufferedWritablePropertyValueModel<Boolean> initializeOverrideDefaultCatalogModel() {
        OverrideDefaultCatalogModel model = new OverrideDefaultCatalogModel(this.jpaProjectHolder);
        model.addPropertyChangeListener("value", this.overrideDefaultCatalogListener);
        BufferedWritablePropertyValueModel bufferedModel = new BufferedWritablePropertyValueModel((WritablePropertyValueModel)model, (PropertyValueModel)this.trigger);
        bufferedModel.addPropertyChangeListener("value", this.validationListener);
        return bufferedModel;
    }

    protected BufferedWritablePropertyValueModel<String> initializeDefaultCatalogModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new DefaultCatalogModel(this.jpaProjectHolder), (PropertyValueModel)this.trigger);
    }

    protected WritablePropertyValueModel<String> initializeCombinedDefaultCatalogModel() {
        CombinedDefaultCatalogModel model = new CombinedDefaultCatalogModel((WritablePropertyValueModel<String>)this.defaultCatalogModel, (PropertyValueModel<Boolean>)this.overrideDefaultCatalogModel, (PropertyValueModel<String>)new DefaultDefaultCatalogModel(this.connectionProfileModel));
        model.addPropertyChangeListener("value", this.validationListener);
        return model;
    }

    protected ListValueModel<String> initializeCatalogChoicesModel() {
        ArrayList<Object> cvms = new ArrayList<Object>();
        cvms.add(new PropertyCollectionValueModelAdapter(this.defaultCatalogModel));
        cvms.add((Object)new CatalogChoicesModel(this.connectionProfileModel));
        return new SortedListValueModelAdapter((CollectionValueModel)new CompositeCollectionValueModel<CollectionValueModel, String>(cvms){

            public Iterator<String> iterator() {
                HashSet<String> uniqueValues = new HashSet<String>();
                for (String each : CollectionTools.iterable((Iterator)super.iterator())) {
                    if (each == null) continue;
                    uniqueValues.add(each);
                }
                return uniqueValues.iterator();
            }
        });
    }

    protected BufferedWritablePropertyValueModel<Boolean> initializeOverrideDefaultSchemaModel() {
        OverrideDefaultSchemaModel model = new OverrideDefaultSchemaModel(this.jpaProjectHolder);
        BufferedWritablePropertyValueModel modelBuffer = new BufferedWritablePropertyValueModel((WritablePropertyValueModel)model, (PropertyValueModel)this.trigger);
        model.addPropertyChangeListener("value", this.overrideDefaultSchemaListener);
        modelBuffer.addPropertyChangeListener("value", this.validationListener);
        return modelBuffer;
    }

    protected BufferedWritablePropertyValueModel<String> initializeDefaultSchemaModel() {
        return new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new DefaultSchemaModel(this.jpaProjectHolder), (PropertyValueModel)this.trigger);
    }

    protected WritablePropertyValueModel<String> initializeCombinedDefaultSchemaModel() {
        CombinedDefaultSchemaModel model = new CombinedDefaultSchemaModel((WritablePropertyValueModel<String>)this.defaultSchemaModel, (PropertyValueModel<Boolean>)this.overrideDefaultSchemaModel, (PropertyValueModel<String>)new DefaultDefaultSchemaModel((PropertyValueModel<String>)this.defaultCatalogModel, this.connectionProfileModel));
        model.addPropertyChangeListener("value", this.validationListener);
        return model;
    }

    protected ListValueModel<String> initializeSchemaChoicesModel() {
        ArrayList<Object> cvms = new ArrayList<Object>();
        cvms.add(new PropertyCollectionValueModelAdapter(this.defaultSchemaModel));
        cvms.add((Object)new SchemaChoicesModel((PropertyValueModel<String>)this.defaultCatalogModel, this.connectionProfileModel));
        return new SortedListValueModelAdapter((CollectionValueModel)new CompositeCollectionValueModel<CollectionValueModel, String>(cvms){

            public Iterator<String> iterator() {
                HashSet<String> uniqueValues = new HashSet<String>();
                for (String each : CollectionTools.iterable((Iterator)super.iterator())) {
                    if (each == null) continue;
                    uniqueValues.add(each);
                }
                return uniqueValues.iterator();
            }
        });
    }

    protected BufferedWritablePropertyValueModel<Boolean> initializeDiscoverAnnotatedClassesModel() {
        BufferedWritablePropertyValueModel model = new BufferedWritablePropertyValueModel((WritablePropertyValueModel)new DiscoverAnnotatedClassesModel(this.jpaProjectHolder), (PropertyValueModel)this.trigger);
        model.addPropertyChangeListener("value", this.validationListener);
        return model;
    }

    protected WritablePropertyValueModel<Boolean> initializeListAnnotatedClassesModel() {
        return new TransformationWritablePropertyValueModel<Boolean, Boolean>(this.discoverAnnotatedClassesModel){

            protected Boolean transform_(Boolean value) {
                return value == false;
            }

            protected Boolean reverseTransform_(Boolean value) {
                return value == false;
            }
        };
    }

    protected JpaProject getJpaProject() {
        return (JpaProject)this.jpaProjectHolder.getValue();
    }

    protected String getJpaPlatformId() {
        return (String)this.platformIdModel.getValue();
    }

    protected String getConnectionName() {
        return (String)this.connectionModel.getValue();
    }

    protected ConnectionProfile getConnectionProfile() {
        return JptDbPlugin.instance().getConnectionProfileFactory().buildConnectionProfile(this.getConnectionName());
    }

    protected Boolean getOverrideDefaultCatalog() {
        return (Boolean)this.overrideDefaultCatalogModel.getValue();
    }

    protected List<String> getDefaultCatalogChoices() {
        return CollectionTools.list((Iterator)this.catalogChoicesModel.iterator());
    }

    protected String getDefaultCatalog() {
        return (String)this.defaultCatalogModel.getValue();
    }

    protected Boolean getOverrideDefaultSchema() {
        return (Boolean)this.overrideDefaultSchemaModel.getValue();
    }

    protected List<String> getDefaultSchemaChoices() {
        return CollectionTools.list((Iterator)this.schemaChoicesModel.iterator());
    }

    protected String getDefaultSchema() {
        return (String)this.defaultSchemaModel.getValue();
    }

    public IProjectFacetVersion getProjectFacetVersion() {
        IProjectFacet jsfFacet = ProjectFacetsManager.getProjectFacet((String)"jpt.jpa");
        IFacetedProject fproj = this.getFacetedProject();
        return fproj.getInstalledVersion(jsfFacet);
    }

    protected LibraryInstallDelegate createLibraryInstallDelegate(IFacetedProject project, IProjectFacetVersion fv) {
        HashMap<String, String> enablementVariables = new HashMap<String, String>();
        enablementVariables.put("jpaPlatform", "");
        return new LibraryInstallDelegate((IFacetedProjectBase)project, fv, enablementVariables);
    }

    protected Control createPageContents(Composite parent) {
        this.projectHolder.setValue((Object)this.getProject());
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        new PlatformGroup(composite);
        Control libraryProviderComposite = super.createPageContents(composite);
        libraryProviderComposite.setLayoutData((Object)new GridData(768));
        new ConnectionGroup(composite);
        new PersistentClassManagementGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jpt.ui.properties_javaPersistence");
        this.updateValidation();
        return composite;
    }

    Button createButton(Composite container, int span, String text, int style) {
        Button button = new Button(container, style);
        button.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = span;
        button.setLayoutData((Object)gd);
        return button;
    }

    Combo createCombo(Composite container, int span, boolean fillHorizontal) {
        Combo combo = new Combo(container, 2060);
        GridData gd = fillHorizontal ? new GridData(768) : new GridData();
        gd.horizontalSpan = span;
        combo.setLayoutData((Object)gd);
        return combo;
    }

    public boolean performOk() {
        super.performOk();
        final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JpaProjectPropertiesPage.this.performOkInternal(monitor);
            }
        };
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    IWorkspace ws = ResourcesPlugin.getWorkspace();
                    ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            throw new RuntimeException(te);
        }
        return true;
    }

    private void performOkInternal(IProgressMonitor monitor) throws CoreException {
        if (this.platformIdModel.isBuffering()) {
            this.trigger.accept();
            JpaModelManager.instance().rebuildJpaProject(this.getProject());
            this.getProject().build(6, monitor);
        } else if (this.connectionModel.isBuffering() || this.overrideDefaultCatalogModel.isBuffering() || this.defaultCatalogModel.isBuffering() || this.overrideDefaultSchemaModel.isBuffering() || this.defaultSchemaModel.isBuffering() || this.discoverAnnotatedClassesModel.isBuffering()) {
            this.trigger.accept();
            this.getProject().build(6, monitor);
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.trigger.reset();
    }

    protected IStatus performValidation() {
        HashMap<Integer, ArrayList> statuses = new HashMap<Integer, ArrayList>();
        statuses.put(4, new ArrayList());
        statuses.put(2, new ArrayList());
        statuses.put(1, new ArrayList());
        statuses.put(0, CollectionTools.list((Object[])new IStatus[]{Status.OK_STATUS}));
        IStatus lpStatus = super.performValidation();
        ((List)statuses.get(lpStatus.getSeverity())).add(lpStatus);
        String connectionName = this.getConnectionName();
        ConnectionProfile connectionProfile = this.getConnectionProfile();
        if (!StringTools.stringIsEmpty((String)connectionName)) {
            if (connectionProfile == null) {
                ((List)statuses.get(4)).add(this.buildErrorStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_INVALID, (Object)connectionName)));
            } else if (!connectionProfile.isActive()) {
                ((List)statuses.get(1)).add(this.buildInfoStatus(JptCoreMessages.VALIDATE_CONNECTION_NOT_CONNECTED));
            }
        }
        if (this.getOverrideDefaultCatalog().booleanValue()) {
            String defaultCatalog = this.getDefaultCatalog();
            if (StringTools.stringIsEmpty((String)defaultCatalog)) {
                ((List)statuses.get(4)).add(this.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_CATALOG_NOT_SPECIFIED));
            } else if (connectionProfile != null && connectionProfile.isConnected() && !this.getDefaultCatalogChoices().contains(defaultCatalog)) {
                ((List)statuses.get(2)).add(this.buildWarningStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_DOESNT_CONTAIN_CATALOG, (Object)defaultCatalog)));
            }
        }
        if (this.getOverrideDefaultSchema().booleanValue()) {
            String defaultSchema = this.getDefaultSchema();
            if (StringTools.stringIsEmpty((String)defaultSchema)) {
                ((List)statuses.get(4)).add(this.buildErrorStatus(JptCoreMessages.VALIDATE_DEFAULT_SCHEMA_NOT_SPECIFIED));
            } else if (connectionProfile != null && connectionProfile.isConnected() && !this.getDefaultSchemaChoices().contains(defaultSchema)) {
                ((List)statuses.get(2)).add(this.buildWarningStatus(NLS.bind((String)JptCoreMessages.VALIDATE_CONNECTION_DOESNT_CONTAIN_SCHEMA, (Object)defaultSchema)));
            }
        }
        if (!((List)statuses.get(4)).isEmpty()) {
            return (IStatus)((List)statuses.get(4)).get(0);
        }
        if (!((List)statuses.get(2)).isEmpty()) {
            return (IStatus)((List)statuses.get(2)).get(0);
        }
        if (!((List)statuses.get(1)).isEmpty()) {
            return (IStatus)((List)statuses.get(1)).get(0);
        }
        return (IStatus)((List)statuses.get(0)).get(0);
    }

    private IStatus buildInfoStatus(String message) {
        return this.buildStatus(1, message);
    }

    private IStatus buildWarningStatus(String message) {
        return this.buildStatus(2, message);
    }

    private IStatus buildErrorStatus(String message) {
        return this.buildStatus(4, message);
    }

    private IStatus buildStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.jpt.core", message);
    }

    public void dispose() {
        super.dispose();
        this.platformIdModel.removePropertyChangeListener("value", this.platformChangelistener);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseCollectionAspectAdapter<S, E>
    extends AspectAdapter<S>
    implements CollectionValueModel<E> {
        protected BaseCollectionAspectAdapter(PropertyValueModel<? extends S> subjectHolder) {
            super(subjectHolder);
        }

        public Iterator<E> iterator() {
            return this.subject == null ? EmptyIterator.instance() : this.iterator_();
        }

        public int size() {
            return this.subject == null ? 0 : this.size_();
        }

        protected Object getValue() {
            return this.iterator();
        }

        protected Class<? extends ChangeListener> getListenerClass() {
            return CollectionChangeListener.class;
        }

        protected String getListenerAspectName() {
            return "values";
        }

        protected boolean hasListeners() {
            return this.hasAnyCollectionChangeListeners("values");
        }

        protected void fireAspectChange(Object oldValue, Object newValue) {
            this.fireCollectionChanged("values");
        }

        protected Iterator<E> iterator_() {
            throw new UnsupportedOperationException();
        }

        protected int size_() {
            return CollectionTools.size(this.iterator());
        }

        protected void collectionChanged() {
            this.fireCollectionChanged("values");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BasePropertyAspectAdapter<S, V>
    extends AspectAdapter<S>
    implements WritablePropertyValueModel<V> {
        protected V value = null;

        protected BasePropertyAspectAdapter(PropertyValueModel<S> subjectHolder) {
            super(subjectHolder);
        }

        public V getValue() {
            return this.value;
        }

        public final void setValue(V value) {
            if (this.subject != null) {
                this.setValue_(value);
            }
        }

        protected void setValue_(V value) {
            throw new UnsupportedOperationException("setValue");
        }

        protected Class<? extends ChangeListener> getListenerClass() {
            return PropertyChangeListener.class;
        }

        protected String getListenerAspectName() {
            return "value";
        }

        protected boolean hasListeners() {
            return this.hasAnyPropertyChangeListeners("value");
        }

        protected void fireAspectChange(Object oldValue, Object newValue) {
            this.firePropertyChanged("value", oldValue, newValue);
        }

        protected void engageSubject_() {
            this.value = this.buildValue();
        }

        protected void disengageSubject_() {
            this.value = null;
        }

        public void toString(StringBuilder sb) {
            sb.append(this.getValue());
        }

        protected V buildValue() {
            if (this.subject != null) {
                return this.buildValue_();
            }
            return null;
        }

        protected abstract V buildValue_();

        protected void valueChanged() {
            V oldValue = this.getValue();
            this.value = this.buildValue();
            this.fireAspectChange(oldValue, this.getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CatalogChoicesModel
    extends ConnectionProfileCollectionAspectAdapter<String> {
        CatalogChoicesModel(PropertyValueModel<ConnectionProfile> subjectHolder) {
            super(subjectHolder);
        }

        @Override
        protected Iterator<String> iterator_() {
            Database db = ((ConnectionProfile)this.subject).getDatabase();
            return db == null || !db.supportsCatalogs() ? EmptyIterator.instance() : db.sortedCatalogIdentifiers();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedDefaultCatalogModel
    extends ListPropertyValueModelAdapter<String>
    implements WritablePropertyValueModel<String> {
        private WritablePropertyValueModel<String> defaultCatalogModel;
        private PropertyValueModel<Boolean> overrideDefaultCatalogModel;
        private PropertyValueModel<String> defaultDefaultCatalogModel;

        CombinedDefaultCatalogModel(WritablePropertyValueModel<String> defaultCatalogModel, PropertyValueModel<Boolean> overrideDefaultCatalogModel, PropertyValueModel<String> defaultDefaultCatalogModel) {
            super((ListValueModel)new CompositeListValueModel((List)CollectionTools.list((Object[])new ListValueModel[]{new PropertyListValueModelAdapter(defaultCatalogModel), new PropertyListValueModelAdapter(overrideDefaultCatalogModel), new PropertyListValueModelAdapter(defaultDefaultCatalogModel)})));
            this.defaultCatalogModel = defaultCatalogModel;
            this.overrideDefaultCatalogModel = overrideDefaultCatalogModel;
            this.defaultDefaultCatalogModel = defaultDefaultCatalogModel;
        }

        protected String buildValue() {
            if (((Boolean)this.overrideDefaultCatalogModel.getValue()).booleanValue()) {
                return (String)this.defaultCatalogModel.getValue();
            }
            return (String)this.defaultDefaultCatalogModel.getValue();
        }

        public void setValue(String value) {
            if (((Boolean)this.overrideDefaultCatalogModel.getValue()).booleanValue()) {
                this.defaultCatalogModel.setValue((Object)value);
            }
            this.propertyChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CombinedDefaultSchemaModel
    extends ListPropertyValueModelAdapter<String>
    implements WritablePropertyValueModel<String> {
        private WritablePropertyValueModel<String> defaultSchemaModel;
        private PropertyValueModel<Boolean> overrideDefaultSchemaModel;
        private PropertyValueModel<String> defaultDefaultSchemaModel;

        CombinedDefaultSchemaModel(WritablePropertyValueModel<String> defaultSchemaModel, PropertyValueModel<Boolean> overrideDefaultSchemaModel, PropertyValueModel<String> defaultDefaultSchemaModel) {
            super((ListValueModel)new CompositeListValueModel((List)CollectionTools.list((Object[])new PropertyListValueModelAdapter[]{new PropertyListValueModelAdapter(defaultSchemaModel), new PropertyListValueModelAdapter(overrideDefaultSchemaModel), new PropertyListValueModelAdapter(defaultDefaultSchemaModel)})));
            this.defaultSchemaModel = defaultSchemaModel;
            this.overrideDefaultSchemaModel = overrideDefaultSchemaModel;
            this.defaultDefaultSchemaModel = defaultDefaultSchemaModel;
        }

        protected String buildValue() {
            if (((Boolean)this.overrideDefaultSchemaModel.getValue()).booleanValue()) {
                return (String)this.defaultSchemaModel.getValue();
            }
            return (String)this.defaultDefaultSchemaModel.getValue();
        }

        public void setValue(String value) {
            if (((Boolean)this.overrideDefaultSchemaModel.getValue()).booleanValue()) {
                this.defaultSchemaModel.setValue((Object)value);
            }
            this.propertyChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionChoicesModel
    extends BaseCollectionAspectAdapter<IProject, String> {
        private ConnectionProfileListener connectionProfileListener = this.buildConnectionProfileListener();

        private ConnectionChoicesModel(PropertyValueModel<IProject> subjectHolder) {
            super(subjectHolder);
        }

        private ConnectionProfileListener buildConnectionProfileListener() {
            return new ConnectionProfileListener(){

                public void connectionProfileAdded(String name) {
                    ConnectionChoicesModel.this.collectionChanged();
                }

                public void connectionProfileRemoved(String name) {
                    ConnectionChoicesModel.this.collectionChanged();
                }

                public void connectionProfileRenamed(String oldName, String newName) {
                }
            };
        }

        protected void engageSubject_() {
            JptDbPlugin.instance().getConnectionProfileFactory().addConnectionProfileListener(this.connectionProfileListener);
        }

        protected void disengageSubject_() {
            JptDbPlugin.instance().getConnectionProfileFactory().removeConnectionProfileListener(this.connectionProfileListener);
        }

        @Override
        protected Iterator<String> iterator_() {
            return JptDbPlugin.instance().getConnectionProfileFactory().connectionProfileNames();
        }
    }

    private final class ConnectionGroup {
        private Link connectLink;

        public ConnectionGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_connectionLabel);
            group.setLayout((Layout)new GridLayout(3, false));
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.properties_javaPersistenceConnection");
            Combo connectionCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 3, true);
            ComboModelAdapter.adapt(JpaProjectPropertiesPage.this.connectionChoicesModel, JpaProjectPropertiesPage.this.connectionModel, connectionCombo, new StringConverter<String>(){

                public String convertToString(String o) {
                    return o == null ? JptUiMessages.JpaFacetWizardPage_none : o;
                }
            });
            Link connectionLink = new Link((Composite)group, 0);
            GridData data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            connectionLink.setLayoutData((Object)data);
            connectionLink.setText(JptUiMessages.JpaFacetWizardPage_connectionLink);
            connectionLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openNewConnectionWizard();
                }
            });
            this.connectLink = new Link((Composite)group, 0);
            data = new GridData(3, 2, false, false);
            data.horizontalSpan = 2;
            this.connectLink.setLayoutData((Object)data);
            this.connectLink.setText(JptUiMessages.JpaFacetWizardPage_connectLink);
            this.updateConnectLink();
            this.connectLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionGroup.this.openConnectionProfile();
                }
            });
            PropertyChangeListener linkUpdateListener = new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    ConnectionGroup.this.updateConnectLink();
                }
            };
            JpaProjectPropertiesPage.this.connectionModel.addPropertyChangeListener("value", linkUpdateListener);
            Button overrideDefaultCatalogButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultCatalogLabel, 32);
            BooleanButtonModelAdapter.adapt((WritablePropertyValueModel<Boolean>)JpaProjectPropertiesPage.this.overrideDefaultCatalogModel, overrideDefaultCatalogButton);
            Label defaultCatalogLabel = new Label((Composite)group, 16384);
            defaultCatalogLabel.setText(JptUiMessages.JpaFacetWizardPage_defaultCatalogLabel);
            GridData gd = new GridData();
            gd.horizontalSpan = 1;
            defaultCatalogLabel.setLayoutData((Object)gd);
            Combo defaultCatalogCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 1, true);
            ComboModelAdapter.adapt(JpaProjectPropertiesPage.this.catalogChoicesModel, JpaProjectPropertiesPage.this.combinedDefaultCatalogModel, defaultCatalogCombo);
            new ControlEnabler((PropertyValueModel<Boolean>)JpaProjectPropertiesPage.this.overrideDefaultCatalogModel, new Control[]{defaultCatalogLabel, defaultCatalogCombo});
            Button overrideDefaultSchemaButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 3, JptUiMessages.JpaFacetWizardPage_overrideDefaultSchemaLabel, 32);
            BooleanButtonModelAdapter.adapt((WritablePropertyValueModel<Boolean>)JpaProjectPropertiesPage.this.overrideDefaultSchemaModel, overrideDefaultSchemaButton);
            Label defaultSchemaLabel = new Label((Composite)group, 16384);
            defaultSchemaLabel.setText(JptUiMessages.JpaFacetWizardPage_defaultSchemaLabel);
            gd = new GridData();
            gd.horizontalSpan = 1;
            defaultSchemaLabel.setLayoutData((Object)gd);
            Combo defaultSchemaCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 1, true);
            ComboModelAdapter.adapt(JpaProjectPropertiesPage.this.schemaChoicesModel, JpaProjectPropertiesPage.this.combinedDefaultSchemaModel, defaultSchemaCombo);
            new ControlEnabler((PropertyValueModel<Boolean>)JpaProjectPropertiesPage.this.overrideDefaultSchemaModel, new Control[]{defaultSchemaLabel, defaultSchemaCombo});
        }

        private void openNewConnectionWizard() {
            String connectionName = DTPUiTools.createNewConnectionProfile();
            if (connectionName != null) {
                JpaProjectPropertiesPage.this.connectionModel.setValue((Object)connectionName);
            }
        }

        private void openConnectionProfile() {
            ConnectionProfile cp = JpaProjectPropertiesPage.this.getConnectionProfile();
            if (cp != null) {
                cp.connect();
            }
            this.updateConnectLink();
        }

        private void updateConnectLink() {
            if (!JpaProjectPropertiesPage.this.getControl().isDisposed()) {
                ConnectionProfile cp = JpaProjectPropertiesPage.this.getConnectionProfile();
                this.connectLink.setEnabled(cp != null && cp.isDisconnected());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionModel
    extends BasePropertyAspectAdapter<JpaProject, String> {
        private PropertyChangeListener connectionChangeListener = this.buildConnectionChangeListener();

        private ConnectionModel(PropertyValueModel<JpaProject> jpaProjectHolder) {
            super(jpaProjectHolder);
        }

        private PropertyChangeListener buildConnectionChangeListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    ConnectionModel.this.valueChanged();
                }
            };
        }

        @Override
        public void setValue_(String newConnection) {
            ((JpaProject)this.subject).getDataSource().setConnectionProfileName(newConnection);
        }

        @Override
        protected void engageSubject_() {
            JpaDataSource dataSource = ((JpaProject)this.subject).getDataSource();
            dataSource.addPropertyChangeListener("connectionProfileName", this.connectionChangeListener);
            super.engageSubject_();
        }

        @Override
        protected void disengageSubject_() {
            JpaDataSource dataSource = ((JpaProject)this.subject).getDataSource();
            dataSource.removePropertyChangeListener("connectionProfileName", this.connectionChangeListener);
            super.disengageSubject_();
        }

        @Override
        protected String buildValue_() {
            return ((JpaProject)this.subject).getDataSource().getConnectionProfileName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectionProfileCollectionAspectAdapter<E>
    extends BaseCollectionAspectAdapter<ConnectionProfile, E> {
        private ConnectionListener connectionListener = this.buildConnectionListener();

        ConnectionProfileCollectionAspectAdapter(PropertyValueModel<ConnectionProfile> subjectHolder) {
            super(subjectHolder);
        }

        private ConnectionListener buildConnectionListener() {
            return new ConnectionAdapter(){

                public void opened(ConnectionProfile profile) {
                    ConnectionProfileCollectionAspectAdapter.this.profileOpened(profile);
                }
            };
        }

        void profileOpened(ConnectionProfile profile) {
            if (profile.equals(this.subject)) {
                this.collectionChanged();
            }
        }

        protected void engageSubject_() {
            ((ConnectionProfile)this.subject).addConnectionListener(this.connectionListener);
        }

        protected void disengageSubject_() {
            ((ConnectionProfile)this.subject).removeConnectionListener(this.connectionListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class ConnectionProfilePropertyAspectAdapter<V>
    extends BasePropertyAspectAdapter<ConnectionProfile, V> {
        private ConnectionListener connectionListener = this.buildConnectionListener();

        ConnectionProfilePropertyAspectAdapter(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        private ConnectionListener buildConnectionListener() {
            return new ConnectionAdapter(){

                public void opened(ConnectionProfile profile) {
                    ConnectionProfilePropertyAspectAdapter.this.profileOpened(profile);
                }
            };
        }

        void profileOpened(ConnectionProfile profile) {
            if (profile.equals(this.subject)) {
                this.valueChanged();
            }
        }

        @Override
        protected void engageSubject_() {
            super.engageSubject_();
            ((ConnectionProfile)this.subject).addConnectionListener(this.connectionListener);
        }

        @Override
        protected void disengageSubject_() {
            ((ConnectionProfile)this.subject).removeConnectionListener(this.connectionListener);
            super.disengageSubject_();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultCatalogModel
    extends PropertyAspectAdapter<JpaProject, String> {
        DefaultCatalogModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"userOverrideDefaultCatalog"});
        }

        public void setValue_(String newCatalog) {
            ((JpaProject)this.subject).setUserOverrideDefaultCatalog(newCatalog);
        }

        protected String buildValue_() {
            return ((JpaProject)this.subject).getUserOverrideDefaultCatalog();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultDefaultCatalogModel
    extends ConnectionProfilePropertyAspectAdapter<String> {
        DefaultDefaultCatalogModel(PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
        }

        @Override
        protected String buildValue_() {
            Database db = ((ConnectionProfile)this.subject).getDatabase();
            return db == null ? null : db.getDefaultCatalogIdentifier();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultDefaultSchemaModel
    extends ConnectionProfilePropertyAspectAdapter<String> {
        private final PropertyValueModel<String> defaultCatalogModel;
        private final PropertyChangeListener catalogListener;

        DefaultDefaultSchemaModel(PropertyValueModel<String> defaultCatalogModel, PropertyValueModel<ConnectionProfile> connectionProfileModel) {
            super(connectionProfileModel);
            this.defaultCatalogModel = defaultCatalogModel;
            this.catalogListener = this.buildCatalogListener();
        }

        private PropertyChangeListener buildCatalogListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    DefaultDefaultSchemaModel.this.valueChanged();
                }
            };
        }

        @Override
        protected void engageSubject_() {
            this.defaultCatalogModel.addPropertyChangeListener("value", this.catalogListener);
            super.engageSubject_();
        }

        @Override
        protected void disengageSubject_() {
            super.disengageSubject_();
            this.defaultCatalogModel.removePropertyChangeListener("value", this.catalogListener);
        }

        @Override
        protected String buildValue_() {
            SchemaContainer sc = this.getSchemaContainer();
            return sc == null ? null : sc.getDefaultSchemaIdentifier();
        }

        private SchemaContainer getSchemaContainer() {
            return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
        }

        private boolean databaseSupportsCatalogs() {
            Database db = this.getDatabase();
            return db != null && db.supportsCatalogs();
        }

        private Catalog getCatalog() {
            String name = (String)this.defaultCatalogModel.getValue();
            return name == null ? null : this.getCatalog(name);
        }

        private Catalog getCatalog(String name) {
            Database db = this.getDatabase();
            return db == null ? null : db.getCatalogForIdentifier(name);
        }

        private Database getDatabase() {
            return ((ConnectionProfile)this.subject).getDatabase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultSchemaModel
    extends PropertyAspectAdapter<JpaProject, String> {
        DefaultSchemaModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"userOverrideDefaultSchema"});
        }

        public void setValue_(String newSchema) {
            ((JpaProject)this.subject).setUserOverrideDefaultSchema(newSchema);
        }

        protected String buildValue_() {
            return ((JpaProject)this.subject).getUserOverrideDefaultSchema();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiscoverAnnotatedClassesModel
    extends PropertyAspectAdapter<JpaProject, Boolean> {
        private DiscoverAnnotatedClassesModel(PropertyValueModel<JpaProject> jpaProjectModel) {
            super(jpaProjectModel, new String[]{"discoversAnnotatedClasses"});
        }

        protected void setValue_(Boolean newValue) {
            ((JpaProject)this.subject).setDiscoversAnnotatedClasses(newValue.booleanValue());
        }

        protected Boolean buildValue_() {
            return ((JpaProject)this.subject).discoversAnnotatedClasses();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JpaProjectHolder
    extends BasePropertyAspectAdapter<IProject, JpaProject> {
        private IEclipsePreferences.IPreferenceChangeListener platformChangeListener = this.buildPlatformChangeListener();

        private JpaProjectHolder(PropertyValueModel<IProject> projectHolder) {
            super(projectHolder);
        }

        private IEclipsePreferences.IPreferenceChangeListener buildPlatformChangeListener() {
            return new IEclipsePreferences.IPreferenceChangeListener(){

                public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                    if ("org.eclipse.jpt.core.platform".equals(event.getKey())) {
                        JpaProjectHolder.this.valueChanged();
                    }
                }
            };
        }

        @Override
        protected void engageSubject_() {
            IEclipsePreferences preferences = JptCorePlugin.getProjectPreferences((IProject)((IProject)this.subject));
            preferences.addPreferenceChangeListener(this.platformChangeListener);
            super.engageSubject_();
        }

        @Override
        protected void disengageSubject_() {
            IEclipsePreferences preferences = JptCorePlugin.getProjectPreferences((IProject)((IProject)this.subject));
            preferences.removePreferenceChangeListener(this.platformChangeListener);
            super.disengageSubject_();
        }

        @Override
        protected JpaProject buildValue_() {
            return JptCorePlugin.getJpaProject((IProject)((IProject)this.subject));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OverrideDefaultCatalogModel
    extends OverrideDefaultModel {
        OverrideDefaultCatalogModel(PropertyValueModel<JpaProject> jpaProjectHolder) {
            super(jpaProjectHolder);
        }

        @Override
        protected String getSubjectUserOverrideDefault() {
            return ((JpaProject)this.subject).getUserOverrideDefaultCatalog();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class OverrideDefaultModel
    extends BasePropertyAspectAdapter<JpaProject, Boolean> {
        private Boolean actualValue;

        OverrideDefaultModel(PropertyValueModel<JpaProject> jpaProjectHolder) {
            super(jpaProjectHolder);
        }

        @Override
        public Boolean getValue() {
            Boolean v = (Boolean)super.getValue();
            return v == null ? Boolean.FALSE : v;
        }

        @Override
        public void setValue_(Boolean newValue) {
            this.actualValue = newValue;
            this.valueChanged();
        }

        @Override
        protected void engageSubject_() {
            this.actualValue = this.buildActualValue_();
            super.engageSubject_();
        }

        @Override
        protected void disengageSubject_() {
            super.disengageSubject_();
            this.actualValue = null;
        }

        @Override
        protected Boolean buildValue_() {
            return this.actualValue;
        }

        protected Boolean buildActualValue_() {
            return this.subjectHasUserOverrideDefault();
        }

        protected boolean subjectHasUserOverrideDefault() {
            return !StringTools.stringIsEmpty((String)this.getSubjectUserOverrideDefault());
        }

        protected abstract String getSubjectUserOverrideDefault();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OverrideDefaultSchemaModel
    extends OverrideDefaultModel {
        OverrideDefaultSchemaModel(PropertyValueModel<JpaProject> jpaProjectHolder) {
            super(jpaProjectHolder);
        }

        @Override
        public String getSubjectUserOverrideDefault() {
            return ((JpaProject)this.subject).getUserOverrideDefaultSchema();
        }
    }

    private final class PersistentClassManagementGroup {
        public PersistentClassManagementGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_persistentClassManagementLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)group, "org.eclipse.jpt.ui.dialog_addJavaPersistence_classpath");
            Button discoverClassesButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_discoverClassesButton, 16);
            BooleanButtonModelAdapter.adapt((WritablePropertyValueModel<Boolean>)JpaProjectPropertiesPage.this.discoverAnnotatedClassesModel, discoverClassesButton);
            Button listClassesButton = JpaProjectPropertiesPage.this.createButton((Composite)group, 1, JptUiMessages.JpaFacetWizardPage_listClassesButton, 16);
            BooleanButtonModelAdapter.adapt((WritablePropertyValueModel<Boolean>)JpaProjectPropertiesPage.this.listAnnotatedClassesModel, listClassesButton);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class PlatformGroup {
        private PlatformGroup(Composite composite) {
            Group group = new Group(composite, 0);
            group.setText(JptUiMessages.JpaFacetWizardPage_platformLabel);
            group.setLayout((Layout)new GridLayout());
            group.setLayoutData((Object)new GridData(768));
            Combo platformCombo = JpaProjectPropertiesPage.this.createCombo((Composite)group, 1, true);
            ComboModelAdapter.adapt(this.buildPlatformChoicesListValueModel(), JpaProjectPropertiesPage.this.platformIdModel, platformCombo, this.buildPlatformLabelConverter());
        }

        private ListValueModel<String> buildPlatformChoicesListValueModel() {
            return new SortedListValueModelAdapter((ListValueModel)new SimpleListValueModel((List)CollectionTools.list((Iterator)JpaPlatformRegistry.instance().jpaPlatformIds())), (Comparator)new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return JpaPlatformRegistry.instance().getJpaPlatformLabel(o1).compareTo(JpaPlatformRegistry.instance().getJpaPlatformLabel(o2));
                }
            });
        }

        private StringConverter<String> buildPlatformLabelConverter() {
            return new StringConverter<String>(){

                public String convertToString(String platformId) {
                    return JpaPlatformRegistry.instance().getJpaPlatformLabel(platformId);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlatformIdModel
    extends BasePropertyAspectAdapter<JpaProject, String> {
        private PlatformIdModel(PropertyValueModel<JpaProject> jpaProjectHolder) {
            super(jpaProjectHolder);
        }

        @Override
        public void setValue_(String newPlatformId) {
            JptCorePlugin.setJpaPlatformId((IProject)((JpaProject)this.subject).getProject(), (String)newPlatformId);
        }

        @Override
        protected String buildValue_() {
            return JptCorePlugin.getJpaPlatformId((IProject)((JpaProject)this.subject).getProject());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SchemaChoicesModel
    extends ConnectionProfileCollectionAspectAdapter<String> {
        private final PropertyValueModel<String> defaultCatalogModel;
        private final PropertyChangeListener catalogListener;

        SchemaChoicesModel(PropertyValueModel<String> defaultCatalogModel, PropertyValueModel<ConnectionProfile> subjectHolder) {
            super(subjectHolder);
            this.defaultCatalogModel = defaultCatalogModel;
            this.catalogListener = this.buildCatalogListener();
        }

        private PropertyChangeListener buildCatalogListener() {
            return new PropertyChangeListener(){

                public void propertyChanged(PropertyChangeEvent event) {
                    SchemaChoicesModel.this.collectionChanged();
                }
            };
        }

        @Override
        protected void engageSubject_() {
            this.defaultCatalogModel.addPropertyChangeListener("value", this.catalogListener);
            super.engageSubject_();
        }

        @Override
        protected void disengageSubject_() {
            super.disengageSubject_();
            this.defaultCatalogModel.removePropertyChangeListener("value", this.catalogListener);
        }

        @Override
        protected Iterator<String> iterator_() {
            SchemaContainer sc = this.getSchemaContainer();
            return sc == null ? EmptyIterator.instance() : sc.sortedSchemaIdentifiers();
        }

        private SchemaContainer getSchemaContainer() {
            return this.databaseSupportsCatalogs() ? this.getCatalog() : this.getDatabase();
        }

        private boolean databaseSupportsCatalogs() {
            Database db = this.getDatabase();
            return db != null && db.supportsCatalogs();
        }

        private Catalog getCatalog() {
            String name = (String)this.defaultCatalogModel.getValue();
            return name == null ? null : this.getCatalog(name);
        }

        private Catalog getCatalog(String name) {
            Database db = this.getDatabase();
            return db == null ? null : db.getCatalogForIdentifier(name);
        }

        private Database getDatabase() {
            return ((ConnectionProfile)this.subject).getDatabase();
        }
    }
}

